/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.jose_8_2_1.jwk;

import java.io.Reader;
import java.io.StringReader;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import java.util.ArrayList;
import java.util.List;
import macromedia.externals.com.nimbusds.jose_8_2_1.JOSEException;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.pkcs.PrivateKeyInfo;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.SubjectPublicKeyInfo;
import macromedia.externals.org.bouncycastle_1_60_0_0.cert.X509CertificateHolder;
import macromedia.externals.org.bouncycastle_1_60_0_0.openssl.PEMException;
import macromedia.externals.org.bouncycastle_1_60_0_0.openssl.PEMKeyPair;
import macromedia.externals.org.bouncycastle_1_60_0_0.openssl.PEMParser;
import macromedia.externals.org.bouncycastle_1_60_0_0.openssl.jcajce.JcaPEMKeyConverter;

/*
 * Exception performing whole class analysis ignored.
 */
class PEMEncodedKeyParser {
    private static final JcaPEMKeyConverter pemConverter = new JcaPEMKeyConverter();

    private PEMEncodedKeyParser() {
    }

    static List<KeyPair> parseKeys(String string) throws JOSEException {
        StringReader stringReader = new StringReader(string);
        PEMParser pEMParser = new PEMParser((Reader)stringReader);
        ArrayList<KeyPair> arrayList = new ArrayList<KeyPair>();
        try {
            Object object;
            do {
                if ((object = pEMParser.readObject()) instanceof SubjectPublicKeyInfo) {
                    arrayList.add(PEMEncodedKeyParser.toKeyPair((SubjectPublicKeyInfo)((SubjectPublicKeyInfo)object)));
                    continue;
                }
                if (object instanceof X509CertificateHolder) {
                    arrayList.add(PEMEncodedKeyParser.toKeyPair((X509CertificateHolder)((X509CertificateHolder)object)));
                    continue;
                }
                if (object instanceof PEMKeyPair) {
                    arrayList.add(PEMEncodedKeyParser.toKeyPair((PEMKeyPair)((PEMKeyPair)object)));
                    continue;
                }
                if (!(object instanceof PrivateKeyInfo)) continue;
                arrayList.add(PEMEncodedKeyParser.toKeyPair((PrivateKeyInfo)((PrivateKeyInfo)object)));
            } while (object != null);
            return arrayList;
        }
        catch (Exception exception) {
            throw new JOSEException(exception.getMessage(), (Throwable)exception);
        }
    }

    private static KeyPair toKeyPair(SubjectPublicKeyInfo subjectPublicKeyInfo) throws PEMException {
        return new KeyPair(pemConverter.getPublicKey(subjectPublicKeyInfo), null);
    }

    private static KeyPair toKeyPair(X509CertificateHolder x509CertificateHolder) throws PEMException {
        SubjectPublicKeyInfo subjectPublicKeyInfo = x509CertificateHolder.getSubjectPublicKeyInfo();
        return new KeyPair(pemConverter.getPublicKey(subjectPublicKeyInfo), null);
    }

    private static KeyPair toKeyPair(PEMKeyPair pEMKeyPair) throws PEMException {
        return pemConverter.getKeyPair(pEMKeyPair);
    }

    private static KeyPair toKeyPair(PrivateKeyInfo privateKeyInfo) throws PEMException, NoSuchAlgorithmException, InvalidKeySpecException {
        PrivateKey privateKey = pemConverter.getPrivateKey(privateKeyInfo);
        if (privateKey instanceof RSAPrivateCrtKey) {
            RSAPublicKeySpec rSAPublicKeySpec = new RSAPublicKeySpec(((RSAPrivateCrtKey)privateKey).getModulus(), ((RSAPrivateCrtKey)privateKey).getPublicExponent());
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PublicKey publicKey = keyFactory.generatePublic(rSAPublicKeySpec);
            return new KeyPair(publicKey, privateKey);
        }
        return new KeyPair(null, privateKey);
    }
}

