/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.jose_8_2_1.jwk;

import java.io.Serializable;
import java.net.URI;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.ECParameterSpec;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import macromedia.externals.com.nimbusds.jose_8_2_1.Algorithm;
import macromedia.externals.com.nimbusds.jose_8_2_1.JOSEException;
import macromedia.externals.com.nimbusds.jose_8_2_1.jwk.Curve;
import macromedia.externals.com.nimbusds.jose_8_2_1.jwk.ECKey;
import macromedia.externals.com.nimbusds.jose_8_2_1.jwk.KeyOperation;
import macromedia.externals.com.nimbusds.jose_8_2_1.jwk.KeyType;
import macromedia.externals.com.nimbusds.jose_8_2_1.jwk.KeyUse;
import macromedia.externals.com.nimbusds.jose_8_2_1.jwk.KeyUseAndOpsConsistency;
import macromedia.externals.com.nimbusds.jose_8_2_1.jwk.OctetKeyPair;
import macromedia.externals.com.nimbusds.jose_8_2_1.jwk.OctetSequenceKey;
import macromedia.externals.com.nimbusds.jose_8_2_1.jwk.PEMEncodedKeyParser;
import macromedia.externals.com.nimbusds.jose_8_2_1.jwk.RSAKey;
import macromedia.externals.com.nimbusds.jose_8_2_1.jwk.ThumbprintUtils;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.Base64;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.Base64URL;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.JSONObjectUtils;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.X509CertChainUtils;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.X509CertUtils;
import macromedia.externals.net.minidev.json_1_3_1.JSONArray;
import macromedia.externals.net.minidev.json_1_3_1.JSONAware;
import macromedia.externals.net.minidev.json_1_3_1.JSONObject;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class JWK
implements JSONAware,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String MIME_TYPE = "application/jwk+json; charset=UTF-8";
    private final KeyType kty;
    private final KeyUse use;
    private final Set<KeyOperation> ops;
    private final Algorithm alg;
    private final String kid;
    private final URI x5u;
    @Deprecated
    private final Base64URL x5t;
    private Base64URL x5t256;
    private final List<Base64> x5c;
    private final List<X509Certificate> parsedX5c;
    private final KeyStore keyStore;

    protected JWK(KeyType keyType, KeyUse keyUse, Set<KeyOperation> set, Algorithm algorithm, String string, URI uRI, Base64URL base64URL, Base64URL base64URL2, List<Base64> list, KeyStore keyStore) {
        if (keyType == null) {
            throw new IllegalArgumentException("The key type \"kty\" parameter must not be null");
        }
        this.kty = keyType;
        if (!KeyUseAndOpsConsistency.areConsistent((KeyUse)keyUse, set)) {
            throw new IllegalArgumentException("The key use \"use\" and key options \"key_opts\" parameters are not consistent, see RFC 7517, section 4.3");
        }
        this.use = keyUse;
        this.ops = set;
        this.alg = algorithm;
        this.kid = string;
        this.x5u = uRI;
        this.x5t = base64URL;
        this.x5t256 = base64URL2;
        if (list != null && list.isEmpty()) {
            throw new IllegalArgumentException("The X.509 certificate chain \"x5c\" must not be empty");
        }
        this.x5c = list;
        try {
            this.parsedX5c = X509CertChainUtils.parse(list);
        }
        catch (ParseException parseException) {
            throw new IllegalArgumentException("Invalid X.509 certificate chain \"x5c\": " + parseException.getMessage(), parseException);
        }
        this.keyStore = keyStore;
    }

    public KeyType getKeyType() {
        return this.kty;
    }

    public KeyUse getKeyUse() {
        return this.use;
    }

    public Set<KeyOperation> getKeyOperations() {
        return this.ops;
    }

    public Algorithm getAlgorithm() {
        return this.alg;
    }

    public String getKeyID() {
        return this.kid;
    }

    public URI getX509CertURL() {
        return this.x5u;
    }

    @Deprecated
    public Base64URL getX509CertThumbprint() {
        return this.x5t;
    }

    public Base64URL getX509CertSHA256Thumbprint() {
        return this.x5t256;
    }

    public List<Base64> getX509CertChain() {
        if (this.x5c == null) {
            return null;
        }
        return Collections.unmodifiableList(this.x5c);
    }

    public List<X509Certificate> getParsedX509CertChain() {
        if (this.parsedX5c == null) {
            return null;
        }
        return Collections.unmodifiableList(this.parsedX5c);
    }

    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    public abstract LinkedHashMap<String, ?> getRequiredParams();

    public Base64URL computeThumbprint() throws JOSEException {
        return this.computeThumbprint("SHA-256");
    }

    public Base64URL computeThumbprint(String string) throws JOSEException {
        return ThumbprintUtils.compute((String)string, (JWK)this);
    }

    public abstract boolean isPrivate();

    public abstract JWK toPublicJWK();

    public abstract int size();

    public JSONObject toJSONObject() {
        JSONArray jSONArray;
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"kty", (Object)this.kty.getValue());
        if (this.use != null) {
            jSONObject.put((Object)"use", (Object)this.use.identifier());
        }
        if (this.ops != null) {
            jSONArray = new ArrayList(this.ops.size());
            for (KeyOperation keyOperation : this.ops) {
                jSONArray.add(keyOperation.identifier());
            }
            jSONObject.put((Object)"key_ops", jSONArray);
        }
        if (this.alg != null) {
            jSONObject.put((Object)"alg", (Object)this.alg.getName());
        }
        if (this.kid != null) {
            jSONObject.put((Object)"kid", (Object)this.kid);
        }
        if (this.x5u != null) {
            jSONObject.put((Object)"x5u", (Object)this.x5u.toString());
        }
        if (this.x5t != null) {
            jSONObject.put((Object)"x5t", (Object)this.x5t.toString());
        }
        if (this.x5t256 != null) {
            jSONObject.put((Object)"x5t#S256", (Object)this.x5t256.toString());
        }
        if (this.x5c != null) {
            jSONArray = new JSONArray();
            for (KeyOperation keyOperation : this.x5c) {
                jSONArray.add((Object)keyOperation.toString());
            }
            jSONObject.put((Object)"x5c", (Object)jSONArray);
        }
        return jSONObject;
    }

    public String toJSONString() {
        return this.toJSONObject().toString();
    }

    public String toString() {
        return this.toJSONObject().toString();
    }

    public static JWK parse(String string) throws ParseException {
        return JWK.parse((JSONObject)JSONObjectUtils.parse((String)string));
    }

    public static JWK parse(JSONObject jSONObject) throws ParseException {
        KeyType keyType = KeyType.parse((String)JSONObjectUtils.getString((JSONObject)jSONObject, (String)"kty"));
        if (keyType == KeyType.EC) {
            return ECKey.parse((JSONObject)jSONObject);
        }
        if (keyType == KeyType.RSA) {
            return RSAKey.parse((JSONObject)jSONObject);
        }
        if (keyType == KeyType.OCT) {
            return OctetSequenceKey.parse((JSONObject)jSONObject);
        }
        if (keyType == KeyType.OKP) {
            return OctetKeyPair.parse((JSONObject)jSONObject);
        }
        throw new ParseException("Unsupported key type \"kty\" parameter: " + keyType, 0);
    }

    public static JWK parse(X509Certificate x509Certificate) throws JOSEException {
        if (x509Certificate.getPublicKey() instanceof RSAPublicKey) {
            return RSAKey.parse((X509Certificate)x509Certificate);
        }
        if (x509Certificate.getPublicKey() instanceof ECPublicKey) {
            return ECKey.parse((X509Certificate)x509Certificate);
        }
        throw new JOSEException("Unsupported public key algorithm: " + x509Certificate.getPublicKey().getAlgorithm());
    }

    public static JWK parseFromPEMEncodedX509Cert(String string) throws JOSEException {
        X509Certificate x509Certificate = X509CertUtils.parse((String)string);
        if (x509Certificate == null) {
            throw new JOSEException("Couldn't parse PEM-encoded X.509 certificate");
        }
        return JWK.parse((X509Certificate)x509Certificate);
    }

    public static JWK load(KeyStore keyStore, String string, char[] cArray) throws KeyStoreException, JOSEException {
        Certificate certificate = keyStore.getCertificate(string);
        if (certificate == null) {
            return OctetSequenceKey.load((KeyStore)keyStore, (String)string, (char[])cArray);
        }
        if (certificate.getPublicKey() instanceof RSAPublicKey) {
            return RSAKey.load((KeyStore)keyStore, (String)string, (char[])cArray);
        }
        if (certificate.getPublicKey() instanceof ECPublicKey) {
            return ECKey.load((KeyStore)keyStore, (String)string, (char[])cArray);
        }
        throw new JOSEException("Unsupported public key algorithm: " + certificate.getPublicKey().getAlgorithm());
    }

    public static JWK parseFromPEMEncodedObjects(String string) throws JOSEException {
        List list = PEMEncodedKeyParser.parseKeys((String)string);
        if (list.isEmpty()) {
            throw new JOSEException("No PEM-encoded keys found");
        }
        KeyPair keyPair = JWK.mergeKeyPairs((List)JWK.toKeyPairList((String)string));
        PublicKey publicKey = keyPair.getPublic();
        PrivateKey privateKey = keyPair.getPrivate();
        if (publicKey == null) {
            throw new JOSEException("Missing PEM-encoded public key to construct JWK");
        }
        if (publicKey instanceof ECPublicKey) {
            ECPublicKey eCPublicKey = (ECPublicKey)publicKey;
            ECParameterSpec eCParameterSpec = eCPublicKey.getParams();
            if (privateKey instanceof ECPrivateKey) {
                JWK.validateEcCurves((ECPublicKey)eCPublicKey, (ECPrivateKey)((ECPrivateKey)privateKey));
            }
            if (privateKey != null && !(privateKey instanceof ECPrivateKey)) {
                throw new JOSEException("Unsupported EC private key type: " + privateKey);
            }
            Curve curve = Curve.forECParameterSpec((ECParameterSpec)eCParameterSpec);
            ECKey.Builder builder = new ECKey.Builder(curve, (ECPublicKey)publicKey);
            if (privateKey != null) {
                builder.privateKey((ECPrivateKey)privateKey);
            }
            return builder.build();
        }
        if (publicKey instanceof RSAPublicKey) {
            RSAKey.Builder builder = new RSAKey.Builder((RSAPublicKey)publicKey);
            if (privateKey instanceof RSAPrivateKey) {
                builder.privateKey((RSAPrivateKey)privateKey);
            } else if (privateKey != null) {
                throw new JOSEException("Unsupported RSA private key type: " + privateKey);
            }
            return builder.build();
        }
        throw new JOSEException("Unsupported algorithm of PEM-encoded key: " + publicKey.getAlgorithm());
    }

    private static void validateEcCurves(ECPublicKey eCPublicKey, ECPrivateKey eCPrivateKey) throws JOSEException {
        ECParameterSpec eCParameterSpec = eCPublicKey.getParams();
        ECParameterSpec eCParameterSpec2 = eCPrivateKey.getParams();
        if (!eCParameterSpec.getCurve().equals(eCParameterSpec2.getCurve())) {
            throw new JOSEException("Public/private EC key curve mismatch: " + eCPublicKey);
        }
        if (eCParameterSpec.getCofactor() != eCParameterSpec2.getCofactor()) {
            throw new JOSEException("Public/private EC key cofactor mismatch: " + eCPublicKey);
        }
        if (!eCParameterSpec.getGenerator().equals(eCParameterSpec2.getGenerator())) {
            throw new JOSEException("Public/private EC key generator mismatch: " + eCPublicKey);
        }
        if (!eCParameterSpec.getOrder().equals(eCParameterSpec2.getOrder())) {
            throw new JOSEException("Public/private EC key order mismatch: " + eCPublicKey);
        }
    }

    private static KeyPair mergeKeyPairs(List<KeyPair> list) throws JOSEException {
        KeyPair keyPair;
        if (list.size() == 1) {
            keyPair = list.get(0);
        } else if (list.size() == 2) {
            keyPair = JWK.twoKeysToKeyPair(list);
        } else {
            throw new JOSEException("Expected key or pair of PEM-encoded keys");
        }
        return keyPair;
    }

    private static List<KeyPair> toKeyPairList(String string) throws JOSEException {
        List list = PEMEncodedKeyParser.parseKeys((String)string);
        if (list.isEmpty()) {
            throw new JOSEException("No PEM-encoded keys found");
        }
        return list;
    }

    private static KeyPair twoKeysToKeyPair(List<? extends KeyPair> list) throws JOSEException {
        KeyPair keyPair = list.get(0);
        KeyPair keyPair2 = list.get(1);
        if (keyPair.getPublic() != null && keyPair2.getPrivate() != null) {
            return new KeyPair(keyPair.getPublic(), keyPair2.getPrivate());
        }
        if (keyPair.getPrivate() != null && keyPair2.getPublic() != null) {
            return new KeyPair(keyPair2.getPublic(), keyPair.getPrivate());
        }
        throw new JOSEException("Not a public/private key pair");
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof JWK)) {
            return false;
        }
        JWK jWK = (JWK)object;
        return Objects.equals(this.kty, jWK.kty) && Objects.equals(this.use, jWK.use) && Objects.equals(this.ops, jWK.ops) && Objects.equals(this.alg, jWK.alg) && Objects.equals(this.kid, jWK.kid) && Objects.equals(this.x5u, jWK.x5u) && Objects.equals(this.x5t, jWK.x5t) && Objects.equals(this.x5t256, jWK.x5t256) && Objects.equals(this.x5c, jWK.x5c) && Objects.equals(this.parsedX5c, jWK.parsedX5c) && Objects.equals(this.keyStore, jWK.keyStore);
    }

    public int hashCode() {
        return Objects.hash(this.kty, this.use, this.ops, this.alg, this.kid, this.x5u, this.x5t, this.x5t256, this.x5c, this.parsedX5c, this.keyStore);
    }
}

