/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.jose_8_2_1.jwk;

import java.math.BigInteger;
import java.net.URI;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import macromedia.externals.com.nimbusds.jose_8_2_1.Algorithm;
import macromedia.externals.com.nimbusds.jose_8_2_1.JOSEException;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.utils.ECChecks;
import macromedia.externals.com.nimbusds.jose_8_2_1.jwk.AsymmetricJWK;
import macromedia.externals.com.nimbusds.jose_8_2_1.jwk.Curve;
import macromedia.externals.com.nimbusds.jose_8_2_1.jwk.CurveBasedJWK;
import macromedia.externals.com.nimbusds.jose_8_2_1.jwk.ECKey;
import macromedia.externals.com.nimbusds.jose_8_2_1.jwk.JWK;
import macromedia.externals.com.nimbusds.jose_8_2_1.jwk.JWKMetadata;
import macromedia.externals.com.nimbusds.jose_8_2_1.jwk.KeyOperation;
import macromedia.externals.com.nimbusds.jose_8_2_1.jwk.KeyType;
import macromedia.externals.com.nimbusds.jose_8_2_1.jwk.KeyUse;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.Base64;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.Base64URL;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.BigIntegerUtils;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.JSONObjectUtils;
import macromedia.externals.net.minidev.json_1_3_1.JSONObject;
import macromedia.externals.org.bouncycastle_1_60_0_0.cert.jcajce.JcaX509CertificateHolder;
import net.jcip.annotations.Immutable;

/*
 * Exception performing whole class analysis ignored.
 */
@Immutable
public final class ECKey
extends JWK
implements AsymmetricJWK,
CurveBasedJWK {
    private static final long serialVersionUID = 1L;
    public static final Set<Curve> SUPPORTED_CURVES = Collections.unmodifiableSet(new HashSet<Curve>(Arrays.asList(Curve.P_256, Curve.P_256K, Curve.P_384, Curve.P_521)));
    private final Curve crv;
    private final Base64URL x;
    private final Base64URL y;
    private final Base64URL d;
    private final PrivateKey privateKey;

    public static Base64URL encodeCoordinate(int n2, BigInteger bigInteger) {
        int n3;
        byte[] byArray = BigIntegerUtils.toBytesUnsigned((BigInteger)bigInteger);
        if (byArray.length >= (n3 = (n2 + 7) / 8)) {
            return Base64URL.encode((byte[])byArray);
        }
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, 0, byArray2, n3 - byArray.length, byArray.length);
        return Base64URL.encode((byte[])byArray2);
    }

    private static void ensurePublicCoordinatesOnCurve(Curve curve, Base64URL base64URL, Base64URL base64URL2) {
        if (!SUPPORTED_CURVES.contains(curve)) {
            throw new IllegalArgumentException("Unknown / unsupported curve: " + curve);
        }
        if (!ECChecks.isPointOnCurve((BigInteger)base64URL.decodeToBigInteger(), (BigInteger)base64URL2.decodeToBigInteger(), (ECParameterSpec)curve.toECParameterSpec())) {
            throw new IllegalArgumentException("Invalid EC JWK: The 'x' and 'y' public coordinates are not on the " + curve + " curve");
        }
    }

    public ECKey(Curve curve, Base64URL base64URL, Base64URL base64URL2, KeyUse keyUse, Set<KeyOperation> set, Algorithm algorithm, String string, URI uRI, Base64URL base64URL3, Base64URL base64URL4, List<Base64> list, KeyStore keyStore) {
        super(KeyType.EC, keyUse, set, algorithm, string, uRI, base64URL3, base64URL4, list, keyStore);
        if (curve == null) {
            throw new IllegalArgumentException("The curve must not be null");
        }
        this.crv = curve;
        if (base64URL == null) {
            throw new IllegalArgumentException("The 'x' coordinate must not be null");
        }
        this.x = base64URL;
        if (base64URL2 == null) {
            throw new IllegalArgumentException("The 'y' coordinate must not be null");
        }
        this.y = base64URL2;
        ECKey.ensurePublicCoordinatesOnCurve((Curve)curve, (Base64URL)base64URL, (Base64URL)base64URL2);
        this.ensureMatches(this.getParsedX509CertChain());
        this.d = null;
        this.privateKey = null;
    }

    public ECKey(Curve curve, Base64URL base64URL, Base64URL base64URL2, Base64URL base64URL3, KeyUse keyUse, Set<KeyOperation> set, Algorithm algorithm, String string, URI uRI, Base64URL base64URL4, Base64URL base64URL5, List<Base64> list, KeyStore keyStore) {
        super(KeyType.EC, keyUse, set, algorithm, string, uRI, base64URL4, base64URL5, list, keyStore);
        if (curve == null) {
            throw new IllegalArgumentException("The curve must not be null");
        }
        this.crv = curve;
        if (base64URL == null) {
            throw new IllegalArgumentException("The 'x' coordinate must not be null");
        }
        this.x = base64URL;
        if (base64URL2 == null) {
            throw new IllegalArgumentException("The 'y' coordinate must not be null");
        }
        this.y = base64URL2;
        ECKey.ensurePublicCoordinatesOnCurve((Curve)curve, (Base64URL)base64URL, (Base64URL)base64URL2);
        this.ensureMatches(this.getParsedX509CertChain());
        if (base64URL3 == null) {
            throw new IllegalArgumentException("The 'd' coordinate must not be null");
        }
        this.d = base64URL3;
        this.privateKey = null;
    }

    public ECKey(Curve curve, Base64URL base64URL, Base64URL base64URL2, PrivateKey privateKey, KeyUse keyUse, Set<KeyOperation> set, Algorithm algorithm, String string, URI uRI, Base64URL base64URL3, Base64URL base64URL4, List<Base64> list, KeyStore keyStore) {
        super(KeyType.EC, keyUse, set, algorithm, string, uRI, base64URL3, base64URL4, list, keyStore);
        if (curve == null) {
            throw new IllegalArgumentException("The curve must not be null");
        }
        this.crv = curve;
        if (base64URL == null) {
            throw new IllegalArgumentException("The 'x' coordinate must not be null");
        }
        this.x = base64URL;
        if (base64URL2 == null) {
            throw new IllegalArgumentException("The 'y' coordinate must not be null");
        }
        this.y = base64URL2;
        ECKey.ensurePublicCoordinatesOnCurve((Curve)curve, (Base64URL)base64URL, (Base64URL)base64URL2);
        this.ensureMatches(this.getParsedX509CertChain());
        this.d = null;
        this.privateKey = privateKey;
    }

    public ECKey(Curve curve, ECPublicKey eCPublicKey, KeyUse keyUse, Set<KeyOperation> set, Algorithm algorithm, String string, URI uRI, Base64URL base64URL, Base64URL base64URL2, List<Base64> list, KeyStore keyStore) {
        this(curve, ECKey.encodeCoordinate((int)eCPublicKey.getParams().getCurve().getField().getFieldSize(), (BigInteger)eCPublicKey.getW().getAffineX()), ECKey.encodeCoordinate((int)eCPublicKey.getParams().getCurve().getField().getFieldSize(), (BigInteger)eCPublicKey.getW().getAffineY()), keyUse, set, algorithm, string, uRI, base64URL, base64URL2, list, keyStore);
    }

    public ECKey(Curve curve, ECPublicKey eCPublicKey, ECPrivateKey eCPrivateKey, KeyUse keyUse, Set<KeyOperation> set, Algorithm algorithm, String string, URI uRI, Base64URL base64URL, Base64URL base64URL2, List<Base64> list, KeyStore keyStore) {
        this(curve, ECKey.encodeCoordinate((int)eCPublicKey.getParams().getCurve().getField().getFieldSize(), (BigInteger)eCPublicKey.getW().getAffineX()), ECKey.encodeCoordinate((int)eCPublicKey.getParams().getCurve().getField().getFieldSize(), (BigInteger)eCPublicKey.getW().getAffineY()), ECKey.encodeCoordinate((int)eCPrivateKey.getParams().getCurve().getField().getFieldSize(), (BigInteger)eCPrivateKey.getS()), keyUse, set, algorithm, string, uRI, base64URL, base64URL2, list, keyStore);
    }

    public ECKey(Curve curve, ECPublicKey eCPublicKey, PrivateKey privateKey, KeyUse keyUse, Set<KeyOperation> set, Algorithm algorithm, String string, URI uRI, Base64URL base64URL, Base64URL base64URL2, List<Base64> list, KeyStore keyStore) {
        this(curve, ECKey.encodeCoordinate((int)eCPublicKey.getParams().getCurve().getField().getFieldSize(), (BigInteger)eCPublicKey.getW().getAffineX()), ECKey.encodeCoordinate((int)eCPublicKey.getParams().getCurve().getField().getFieldSize(), (BigInteger)eCPublicKey.getW().getAffineY()), privateKey, keyUse, set, algorithm, string, uRI, base64URL, base64URL2, list, keyStore);
    }

    public Curve getCurve() {
        return this.crv;
    }

    public Base64URL getX() {
        return this.x;
    }

    public Base64URL getY() {
        return this.y;
    }

    public Base64URL getD() {
        return this.d;
    }

    public ECPublicKey toECPublicKey() throws JOSEException {
        return this.toECPublicKey(null);
    }

    public ECPublicKey toECPublicKey(Provider provider) throws JOSEException {
        ECParameterSpec eCParameterSpec = this.crv.toECParameterSpec();
        if (eCParameterSpec == null) {
            throw new JOSEException("Couldn't get EC parameter spec for curve " + this.crv);
        }
        ECPoint eCPoint = new ECPoint(this.x.decodeToBigInteger(), this.y.decodeToBigInteger());
        ECPublicKeySpec eCPublicKeySpec = new ECPublicKeySpec(eCPoint, eCParameterSpec);
        try {
            KeyFactory keyFactory = provider == null ? KeyFactory.getInstance("EC") : KeyFactory.getInstance("EC", provider);
            return (ECPublicKey)keyFactory.generatePublic(eCPublicKeySpec);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException generalSecurityException) {
            throw new JOSEException(generalSecurityException.getMessage(), (Throwable)generalSecurityException);
        }
    }

    public ECPrivateKey toECPrivateKey() throws JOSEException {
        return this.toECPrivateKey(null);
    }

    public ECPrivateKey toECPrivateKey(Provider provider) throws JOSEException {
        if (this.d == null) {
            return null;
        }
        ECParameterSpec eCParameterSpec = this.crv.toECParameterSpec();
        if (eCParameterSpec == null) {
            throw new JOSEException("Couldn't get EC parameter spec for curve " + this.crv);
        }
        ECPrivateKeySpec eCPrivateKeySpec = new ECPrivateKeySpec(this.d.decodeToBigInteger(), eCParameterSpec);
        try {
            KeyFactory keyFactory = provider == null ? KeyFactory.getInstance("EC") : KeyFactory.getInstance("EC", provider);
            return (ECPrivateKey)keyFactory.generatePrivate(eCPrivateKeySpec);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException generalSecurityException) {
            throw new JOSEException(generalSecurityException.getMessage(), (Throwable)generalSecurityException);
        }
    }

    public PublicKey toPublicKey() throws JOSEException {
        return this.toECPublicKey();
    }

    public PrivateKey toPrivateKey() throws JOSEException {
        ECPrivateKey eCPrivateKey = this.toECPrivateKey();
        if (eCPrivateKey != null) {
            return eCPrivateKey;
        }
        return this.privateKey;
    }

    public KeyPair toKeyPair() throws JOSEException {
        return this.toKeyPair(null);
    }

    public KeyPair toKeyPair(Provider provider) throws JOSEException {
        if (this.privateKey != null) {
            return new KeyPair(this.toECPublicKey(provider), this.privateKey);
        }
        return new KeyPair(this.toECPublicKey(provider), this.toECPrivateKey(provider));
    }

    public boolean matches(X509Certificate x509Certificate) {
        ECPublicKey eCPublicKey;
        try {
            eCPublicKey = (ECPublicKey)((X509Certificate)this.getParsedX509CertChain().get(0)).getPublicKey();
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        if (!this.getX().decodeToBigInteger().equals(eCPublicKey.getW().getAffineX())) {
            return false;
        }
        return this.getY().decodeToBigInteger().equals(eCPublicKey.getW().getAffineY());
    }

    private void ensureMatches(List<X509Certificate> list) {
        if (list == null) {
            return;
        }
        if (!this.matches(list.get(0))) {
            throw new IllegalArgumentException("The public subject key info of the first X.509 certificate in the chain must match the JWK type and public parameters");
        }
    }

    public LinkedHashMap<String, ?> getRequiredParams() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("crv", this.crv.toString());
        linkedHashMap.put("kty", this.getKeyType().getValue());
        linkedHashMap.put("x", this.x.toString());
        linkedHashMap.put("y", this.y.toString());
        return linkedHashMap;
    }

    public boolean isPrivate() {
        return this.d != null || this.privateKey != null;
    }

    public int size() {
        ECParameterSpec eCParameterSpec = this.crv.toECParameterSpec();
        if (eCParameterSpec == null) {
            throw new UnsupportedOperationException("Couldn't determine field size for curve " + this.crv.getName());
        }
        return eCParameterSpec.getCurve().getField().getFieldSize();
    }

    public ECKey toPublicJWK() {
        return new ECKey(this.getCurve(), this.getX(), this.getY(), this.getKeyUse(), this.getKeyOperations(), this.getAlgorithm(), this.getKeyID(), this.getX509CertURL(), this.getX509CertThumbprint(), this.getX509CertSHA256Thumbprint(), this.getX509CertChain(), this.getKeyStore());
    }

    public JSONObject toJSONObject() {
        JSONObject jSONObject = super.toJSONObject();
        jSONObject.put((Object)"crv", (Object)this.crv.toString());
        jSONObject.put((Object)"x", (Object)this.x.toString());
        jSONObject.put((Object)"y", (Object)this.y.toString());
        if (this.d != null) {
            jSONObject.put((Object)"d", (Object)this.d.toString());
        }
        return jSONObject;
    }

    public static ECKey parse(String string) throws ParseException {
        return ECKey.parse((JSONObject)JSONObjectUtils.parse((String)string));
    }

    public static ECKey parse(JSONObject jSONObject) throws ParseException {
        Curve curve = Curve.parse((String)JSONObjectUtils.getString((JSONObject)jSONObject, (String)"crv"));
        Base64URL base64URL = new Base64URL(JSONObjectUtils.getString((JSONObject)jSONObject, (String)"x"));
        Base64URL base64URL2 = new Base64URL(JSONObjectUtils.getString((JSONObject)jSONObject, (String)"y"));
        KeyType keyType = JWKMetadata.parseKeyType((JSONObject)jSONObject);
        if (keyType != KeyType.EC) {
            throw new ParseException("The key type \"kty\" must be EC", 0);
        }
        Base64URL base64URL3 = null;
        if (jSONObject.get((Object)"d") != null) {
            base64URL3 = new Base64URL(JSONObjectUtils.getString((JSONObject)jSONObject, (String)"d"));
        }
        try {
            if (base64URL3 == null) {
                return new ECKey(curve, base64URL, base64URL2, JWKMetadata.parseKeyUse((JSONObject)jSONObject), JWKMetadata.parseKeyOperations((JSONObject)jSONObject), JWKMetadata.parseAlgorithm((JSONObject)jSONObject), JWKMetadata.parseKeyID((JSONObject)jSONObject), JWKMetadata.parseX509CertURL((JSONObject)jSONObject), JWKMetadata.parseX509CertThumbprint((JSONObject)jSONObject), JWKMetadata.parseX509CertSHA256Thumbprint((JSONObject)jSONObject), JWKMetadata.parseX509CertChain((JSONObject)jSONObject), null);
            }
            return new ECKey(curve, base64URL, base64URL2, base64URL3, JWKMetadata.parseKeyUse((JSONObject)jSONObject), JWKMetadata.parseKeyOperations((JSONObject)jSONObject), JWKMetadata.parseAlgorithm((JSONObject)jSONObject), JWKMetadata.parseKeyID((JSONObject)jSONObject), JWKMetadata.parseX509CertURL((JSONObject)jSONObject), JWKMetadata.parseX509CertThumbprint((JSONObject)jSONObject), JWKMetadata.parseX509CertSHA256Thumbprint((JSONObject)jSONObject), JWKMetadata.parseX509CertChain((JSONObject)jSONObject), null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ParseException(illegalArgumentException.getMessage(), 0);
        }
    }

    public static ECKey parse(X509Certificate x509Certificate) throws JOSEException {
        if (!(x509Certificate.getPublicKey() instanceof ECPublicKey)) {
            throw new JOSEException("The public key of the X.509 certificate is not EC");
        }
        ECPublicKey eCPublicKey = (ECPublicKey)x509Certificate.getPublicKey();
        try {
            JcaX509CertificateHolder jcaX509CertificateHolder = new JcaX509CertificateHolder(x509Certificate);
            String string = jcaX509CertificateHolder.getSubjectPublicKeyInfo().getAlgorithm().getParameters().toString();
            Curve curve = Curve.forOID((String)string);
            if (curve == null) {
                throw new JOSEException("Couldn't determine EC JWK curve for OID " + string);
            }
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            return new Builder(curve, eCPublicKey).keyUse(KeyUse.from((X509Certificate)x509Certificate)).keyID(x509Certificate.getSerialNumber().toString(10)).x509CertChain(Collections.singletonList(Base64.encode((byte[])x509Certificate.getEncoded()))).x509CertSHA256Thumbprint(Base64URL.encode((byte[])messageDigest.digest(x509Certificate.getEncoded()))).build();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new JOSEException("Couldn't encode x5t parameter: " + noSuchAlgorithmException.getMessage(), (Throwable)noSuchAlgorithmException);
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new JOSEException("Couldn't encode x5c parameter: " + certificateEncodingException.getMessage(), (Throwable)certificateEncodingException);
        }
    }

    public static ECKey load(KeyStore keyStore, String string, char[] cArray) throws KeyStoreException, JOSEException {
        Key key;
        Certificate certificate = keyStore.getCertificate(string);
        if (certificate == null || !(certificate instanceof X509Certificate)) {
            return null;
        }
        X509Certificate x509Certificate = (X509Certificate)certificate;
        if (!(x509Certificate.getPublicKey() instanceof ECPublicKey)) {
            throw new JOSEException("Couldn't load EC JWK: The key algorithm is not EC");
        }
        ECKey eCKey = ECKey.parse((X509Certificate)x509Certificate);
        eCKey = new Builder(eCKey).keyID(string).keyStore(keyStore).build();
        try {
            key = keyStore.getKey(string, cArray);
        }
        catch (NoSuchAlgorithmException | UnrecoverableKeyException generalSecurityException) {
            throw new JOSEException("Couldn't retrieve private EC key (bad pin?): " + generalSecurityException.getMessage(), (Throwable)generalSecurityException);
        }
        if (key instanceof ECPrivateKey) {
            return new Builder(eCKey).privateKey((ECPrivateKey)key).build();
        }
        if (key instanceof PrivateKey && "EC".equalsIgnoreCase(key.getAlgorithm())) {
            return new Builder(eCKey).privateKey((PrivateKey)key).build();
        }
        return eCKey;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ECKey)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        ECKey eCKey = (ECKey)object;
        return Objects.equals(this.crv, eCKey.crv) && Objects.equals(this.x, eCKey.x) && Objects.equals(this.y, eCKey.y) && Objects.equals(this.d, eCKey.d) && Objects.equals(this.privateKey, eCKey.privateKey);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.crv, this.x, this.y, this.d, this.privateKey);
    }

    static /* synthetic */ Curve access$000(ECKey eCKey) {
        return eCKey.crv;
    }

    static /* synthetic */ Base64URL access$100(ECKey eCKey) {
        return eCKey.x;
    }

    static /* synthetic */ Base64URL access$200(ECKey eCKey) {
        return eCKey.y;
    }

    static /* synthetic */ Base64URL access$300(ECKey eCKey) {
        return eCKey.d;
    }

    static /* synthetic */ PrivateKey access$400(ECKey eCKey) {
        return eCKey.privateKey;
    }
}

