/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.jose_8_2_1.jca;

import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import macromedia.externals.com.nimbusds.jose_8_2_1.Algorithm;
import macromedia.externals.com.nimbusds.jose_8_2_1.EncryptionMethod;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWEAlgorithm;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWSAlgorithm;

/*
 * Exception performing whole class analysis ignored.
 */
public final class JCASupport {
    public static boolean isUnlimitedStrength() {
        try {
            return Cipher.getMaxAllowedKeyLength("AES") >= 256;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return false;
        }
    }

    public static boolean isSupported(Algorithm algorithm) {
        if (algorithm instanceof JWSAlgorithm) {
            return JCASupport.isSupported((JWSAlgorithm)((JWSAlgorithm)algorithm));
        }
        if (algorithm instanceof JWEAlgorithm) {
            return JCASupport.isSupported((JWEAlgorithm)((JWEAlgorithm)algorithm));
        }
        if (algorithm instanceof EncryptionMethod) {
            return JCASupport.isSupported((EncryptionMethod)((EncryptionMethod)algorithm));
        }
        throw new IllegalArgumentException("Unexpected algorithm class: " + algorithm.getClass().getCanonicalName());
    }

    public static boolean isSupported(Algorithm algorithm, Provider provider) {
        if (algorithm instanceof JWSAlgorithm) {
            return JCASupport.isSupported((JWSAlgorithm)((JWSAlgorithm)algorithm), (Provider)provider);
        }
        if (algorithm instanceof JWEAlgorithm) {
            return JCASupport.isSupported((JWEAlgorithm)((JWEAlgorithm)algorithm), (Provider)provider);
        }
        if (algorithm instanceof EncryptionMethod) {
            return JCASupport.isSupported((EncryptionMethod)((EncryptionMethod)algorithm), (Provider)provider);
        }
        throw new IllegalArgumentException("Unexpected algorithm class: " + algorithm.getClass().getCanonicalName());
    }

    public static boolean isSupported(JWSAlgorithm jWSAlgorithm) {
        if (jWSAlgorithm.getName().equals(Algorithm.NONE.getName())) {
            return true;
        }
        for (Provider provider : Security.getProviders()) {
            if (!JCASupport.isSupported((JWSAlgorithm)jWSAlgorithm, (Provider)provider)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSupported(JWSAlgorithm jWSAlgorithm, Provider provider) {
        if (JWSAlgorithm.Family.HMAC_SHA.contains((Object)jWSAlgorithm)) {
            String string;
            if (jWSAlgorithm.equals((Object)JWSAlgorithm.HS256)) {
                string = "HMACSHA256";
            } else if (jWSAlgorithm.equals((Object)JWSAlgorithm.HS384)) {
                string = "HMACSHA384";
            } else if (jWSAlgorithm.equals((Object)JWSAlgorithm.HS512)) {
                string = "HMACSHA512";
            } else {
                return false;
            }
            return provider.getService("KeyGenerator", string) != null;
        }
        if (JWSAlgorithm.Family.RSA.contains((Object)jWSAlgorithm)) {
            String string;
            if (jWSAlgorithm.equals((Object)JWSAlgorithm.RS256)) {
                string = "SHA256withRSA";
            } else if (jWSAlgorithm.equals((Object)JWSAlgorithm.RS384)) {
                string = "SHA384withRSA";
            } else if (jWSAlgorithm.equals((Object)JWSAlgorithm.RS512)) {
                string = "SHA512withRSA";
            } else if (jWSAlgorithm.equals((Object)JWSAlgorithm.PS256)) {
                string = "SHA256withRSAandMGF1";
            } else if (jWSAlgorithm.equals((Object)JWSAlgorithm.PS384)) {
                string = "SHA384withRSAandMGF1";
            } else if (jWSAlgorithm.equals((Object)JWSAlgorithm.PS512)) {
                string = "SHA512withRSAandMGF1";
            } else {
                return false;
            }
            return provider.getService("Signature", string) != null;
        }
        if (JWSAlgorithm.Family.EC.contains((Object)jWSAlgorithm)) {
            String string;
            if (jWSAlgorithm.equals((Object)JWSAlgorithm.ES256)) {
                string = "SHA256withECDSA";
            } else if (jWSAlgorithm.equals((Object)JWSAlgorithm.ES384)) {
                string = "SHA384withECDSA";
            } else if (jWSAlgorithm.equals((Object)JWSAlgorithm.ES512)) {
                string = "SHA512withECDSA";
            } else {
                return false;
            }
            return provider.getService("Signature", string) != null;
        }
        return false;
    }

    public static boolean isSupported(JWEAlgorithm jWEAlgorithm) {
        for (Provider provider : Security.getProviders()) {
            if (!JCASupport.isSupported((JWEAlgorithm)jWEAlgorithm, (Provider)provider)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSupported(JWEAlgorithm jWEAlgorithm, Provider provider) {
        if (JWEAlgorithm.Family.RSA.contains((Object)jWEAlgorithm)) {
            String string;
            if (jWEAlgorithm.equals((Object)JWEAlgorithm.RSA1_5)) {
                string = "RSA/ECB/PKCS1Padding";
            } else if (jWEAlgorithm.equals((Object)JWEAlgorithm.RSA_OAEP)) {
                string = "RSA/ECB/OAEPWithSHA-1AndMGF1Padding";
            } else if (jWEAlgorithm.equals((Object)JWEAlgorithm.RSA_OAEP_256)) {
                string = "RSA/ECB/OAEPWithSHA-256AndMGF1Padding";
            } else {
                return false;
            }
            try {
                Cipher.getInstance(string, provider);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                return false;
            }
            catch (NoSuchPaddingException noSuchPaddingException) {
                return false;
            }
            return true;
        }
        if (JWEAlgorithm.Family.AES_KW.contains((Object)jWEAlgorithm)) {
            return provider.getService("Cipher", "AESWrap") != null;
        }
        if (JWEAlgorithm.Family.ECDH_ES.contains((Object)jWEAlgorithm)) {
            return provider.getService("KeyAgreement", "ECDH") != null;
        }
        if (JWEAlgorithm.Family.AES_GCM_KW.contains((Object)jWEAlgorithm)) {
            try {
                Cipher.getInstance("AES/GCM/NoPadding", provider);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                return false;
            }
            catch (NoSuchPaddingException noSuchPaddingException) {
                return false;
            }
            return true;
        }
        if (JWEAlgorithm.Family.PBES2.contains((Object)jWEAlgorithm)) {
            String string = jWEAlgorithm.equals((Object)JWEAlgorithm.PBES2_HS256_A128KW) ? "HmacSHA256" : (jWEAlgorithm.equals((Object)JWEAlgorithm.PBES2_HS384_A192KW) ? "HmacSHA384" : "HmacSHA512");
            return provider.getService("KeyGenerator", string) != null;
        }
        return JWEAlgorithm.DIR.equals((Object)jWEAlgorithm);
    }

    public static boolean isSupported(EncryptionMethod encryptionMethod) {
        for (Provider provider : Security.getProviders()) {
            if (!JCASupport.isSupported((EncryptionMethod)encryptionMethod, (Provider)provider)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSupported(EncryptionMethod encryptionMethod, Provider provider) {
        if (EncryptionMethod.Family.AES_CBC_HMAC_SHA.contains((Object)encryptionMethod)) {
            try {
                Cipher.getInstance("AES/CBC/PKCS5Padding", provider);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                return false;
            }
            catch (NoSuchPaddingException noSuchPaddingException) {
                return false;
            }
            String string = encryptionMethod.equals((Object)EncryptionMethod.A128CBC_HS256) ? "HmacSHA256" : (encryptionMethod.equals((Object)EncryptionMethod.A192CBC_HS384) ? "HmacSHA384" : "HmacSHA512");
            return provider.getService("KeyGenerator", string) != null;
        }
        if (EncryptionMethod.Family.AES_GCM.contains((Object)encryptionMethod)) {
            try {
                Cipher.getInstance("AES/GCM/NoPadding", provider);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                return false;
            }
            catch (NoSuchPaddingException noSuchPaddingException) {
                return false;
            }
            return true;
        }
        return false;
    }

    private JCASupport() {
    }
}

