/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.jose_8_2_1.crypto.impl;

import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.MGF1ParameterSpec;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.SecretKey;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.PSource;
import javax.crypto.spec.SecretKeySpec;
import macromedia.externals.com.nimbusds.jose_8_2_1.JOSEException;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.impl.AlgorithmParametersHelper;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.impl.CipherHelper;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class RSA_OAEP_256 {
    private static final String RSA_OEAP_256_JCA_ALG = "RSA/ECB/OAEPWithSHA-256AndMGF1Padding";

    public static byte[] encryptCEK(RSAPublicKey rSAPublicKey, SecretKey secretKey, Provider provider) throws JOSEException {
        try {
            AlgorithmParameters algorithmParameters = AlgorithmParametersHelper.getInstance((String)"OAEP", (Provider)provider);
            OAEPParameterSpec oAEPParameterSpec = new OAEPParameterSpec("SHA-256", "MGF1", MGF1ParameterSpec.SHA256, PSource.PSpecified.DEFAULT);
            algorithmParameters.init(oAEPParameterSpec);
            Cipher cipher = CipherHelper.getInstance((String)RSA_OEAP_256_JCA_ALG, (Provider)provider);
            cipher.init(1, (Key)rSAPublicKey, algorithmParameters);
            return cipher.doFinal(secretKey.getEncoded());
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new JOSEException("RSA block size exception: The RSA key is too short, try a longer one", (Throwable)illegalBlockSizeException);
        }
        catch (Exception exception) {
            throw new JOSEException(exception.getMessage(), (Throwable)exception);
        }
    }

    public static SecretKey decryptCEK(PrivateKey privateKey, byte[] byArray, Provider provider) throws JOSEException {
        try {
            AlgorithmParameters algorithmParameters = AlgorithmParametersHelper.getInstance((String)"OAEP", (Provider)provider);
            OAEPParameterSpec oAEPParameterSpec = new OAEPParameterSpec("SHA-256", "MGF1", MGF1ParameterSpec.SHA256, PSource.PSpecified.DEFAULT);
            algorithmParameters.init(oAEPParameterSpec);
            Cipher cipher = CipherHelper.getInstance((String)RSA_OEAP_256_JCA_ALG, (Provider)provider);
            cipher.init(2, (Key)privateKey, algorithmParameters);
            return new SecretKeySpec(cipher.doFinal(byArray), "AES");
        }
        catch (Exception exception) {
            throw new JOSEException(exception.getMessage(), (Throwable)exception);
        }
    }

    private RSA_OAEP_256() {
    }
}

