/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.jose_8_2_1.crypto.impl;

import java.security.PrivateKey;
import java.security.interfaces.RSAPrivateKey;
import macromedia.externals.com.nimbusds.jose_8_2_1.JOSEException;
import macromedia.externals.com.nimbusds.jose_8_2_1.jwk.RSAKey;

public class RSAKeyUtils {
    public static PrivateKey toRSAPrivateKey(RSAKey rSAKey) throws JOSEException {
        if (!rSAKey.isPrivate()) {
            throw new JOSEException("The RSA JWK doesn't contain a private part");
        }
        return rSAKey.toPrivateKey();
    }

    public static int keyBitLength(PrivateKey privateKey) {
        if (!(privateKey instanceof RSAPrivateKey)) {
            return -1;
        }
        RSAPrivateKey rSAPrivateKey = (RSAPrivateKey)privateKey;
        try {
            return rSAPrivateKey.getModulus().bitLength();
        }
        catch (Exception exception) {
            return -1;
        }
    }
}

