/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.jose_8_2_1.crypto.impl;

import java.security.PrivateKey;
import java.security.Provider;
import java.security.interfaces.RSAPublicKey;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import macromedia.externals.com.nimbusds.jose_8_2_1.JOSEException;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.impl.CipherHelper;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.ByteUtils;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class RSA1_5 {
    public static byte[] encryptCEK(RSAPublicKey rSAPublicKey, SecretKey secretKey, Provider provider) throws JOSEException {
        try {
            Cipher cipher = CipherHelper.getInstance((String)"RSA/ECB/PKCS1Padding", (Provider)provider);
            cipher.init(1, rSAPublicKey);
            return cipher.doFinal(secretKey.getEncoded());
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new JOSEException("RSA block size exception: The RSA key is too short, try a longer one", (Throwable)illegalBlockSizeException);
        }
        catch (Exception exception) {
            throw new JOSEException("Couldn't encrypt Content Encryption Key (CEK): " + exception.getMessage(), (Throwable)exception);
        }
    }

    public static SecretKey decryptCEK(PrivateKey privateKey, byte[] byArray, int n2, Provider provider) throws JOSEException {
        try {
            Cipher cipher = CipherHelper.getInstance((String)"RSA/ECB/PKCS1Padding", (Provider)provider);
            cipher.init(2, privateKey);
            byte[] byArray2 = cipher.doFinal(byArray);
            if (ByteUtils.safeBitLength((byte[])byArray2) != n2) {
                return null;
            }
            return new SecretKeySpec(byArray2, "AES");
        }
        catch (Exception exception) {
            throw new JOSEException("Couldn't decrypt Content Encryption Key (CEK): " + exception.getMessage(), (Throwable)exception);
        }
    }

    private RSA1_5() {
    }
}

