/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.jose_8_2_1.crypto.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.Provider;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import macromedia.externals.com.nimbusds.jose_8_2_1.JOSEException;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWEAlgorithm;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.impl.HMAC;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.impl.PRFParams;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.ByteUtils;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.IntegerUtils;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.StandardCharset;

/*
 * Exception performing whole class analysis ignored.
 */
public class PBKDF2 {
    public static byte[] ZERO_BYTE = new byte[]{0};

    public static byte[] formatSalt(JWEAlgorithm jWEAlgorithm, byte[] byArray) throws JOSEException {
        byte[] byArray2 = jWEAlgorithm.toString().getBytes(StandardCharset.UTF_8);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            byteArrayOutputStream.write(byArray2);
            byteArrayOutputStream.write(ZERO_BYTE);
            byteArrayOutputStream.write(byArray);
        }
        catch (IOException iOException) {
            throw new JOSEException(iOException.getMessage(), (Throwable)iOException);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static SecretKey deriveKey(byte[] byArray, byte[] byArray2, int n2, PRFParams pRFParams) throws JOSEException {
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, pRFParams.getMACAlgorithm());
        Mac mac = HMAC.getInitMac((SecretKey)secretKeySpec, (Provider)pRFParams.getMacProvider());
        int n3 = mac.getMacLength();
        long l2 = 0xFFFFFFFFL;
        if ((long)pRFParams.getDerivedKeyByteLength() > l2) {
            throw new JOSEException("derived key too long " + pRFParams.getDerivedKeyByteLength());
        }
        int n4 = (int)Math.ceil((double)pRFParams.getDerivedKeyByteLength() / (double)n3);
        int n5 = pRFParams.getDerivedKeyByteLength() - (n4 - 1) * n3;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (int i2 = 0; i2 < n4; ++i2) {
            byte[] byArray3 = PBKDF2.extractBlock((byte[])byArray2, (int)n2, (int)(i2 + 1), (Mac)mac);
            if (i2 == n4 - 1) {
                byArray3 = ByteUtils.subArray((byte[])byArray3, (int)0, (int)n5);
            }
            byteArrayOutputStream.write(byArray3, 0, byArray3.length);
        }
        return new SecretKeySpec(byteArrayOutputStream.toByteArray(), "AES");
    }

    private static byte[] extractBlock(byte[] byArray, int n2, int n3, Mac mac) {
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        for (int i2 = 1; i2 <= n2; ++i2) {
            byte[] byArray4;
            if (i2 == 1) {
                byte[] byArray5 = ByteUtils.concat((byte[][])new byte[][]{byArray, IntegerUtils.toBytes((int)n3)});
                byArray3 = byArray4 = mac.doFinal(byArray5);
            } else {
                byArray4 = mac.doFinal(byArray2);
                for (int i3 = 0; i3 < byArray4.length; ++i3) {
                    byArray3[i3] = (byte)(byArray4[i3] ^ byArray3[i3]);
                }
            }
            byArray2 = byArray4;
        }
        return byArray3;
    }

    private PBKDF2() {
    }
}

