/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.jose_8_2_1.crypto.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import macromedia.externals.com.nimbusds.jose_8_2_1.EncryptionMethod;
import macromedia.externals.com.nimbusds.jose_8_2_1.JOSEException;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.IntegerUtils;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.StandardCharset;

public class LegacyConcatKDF {
    private static final byte[] ONE_BYTES = new byte[]{0, 0, 0, 1};
    private static final byte[] ZERO_BYTES = new byte[]{0, 0, 0, 0};
    private static final byte[] ENCRYPTION_BYTES = new byte[]{69, 110, 99, 114, 121, 112, 116, 105, 111, 110};
    private static final byte[] INTEGRITY_BYTES = new byte[]{73, 110, 116, 101, 103, 114, 105, 116, 121};

    public static SecretKey generateCEK(SecretKey secretKey, EncryptionMethod encryptionMethod, byte[] byArray, byte[] byArray2) throws JOSEException {
        MessageDigest messageDigest;
        byte[] byArray3;
        int n2;
        byte[] byArray4;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            int n3;
            byteArrayOutputStream.write(ONE_BYTES);
            byArray4 = secretKey.getEncoded();
            byteArrayOutputStream.write(byArray4);
            n2 = n3 = byArray4.length * 8;
            int n4 = n3 / 2;
            byArray3 = IntegerUtils.toBytes((int)n4);
            byteArrayOutputStream.write(byArray3);
            byte[] byArray5 = encryptionMethod.toString().getBytes(StandardCharset.UTF_8);
            byteArrayOutputStream.write(byArray5);
            if (byArray != null) {
                byteArrayOutputStream.write(IntegerUtils.toBytes((int)byArray.length));
                byteArrayOutputStream.write(byArray);
            } else {
                byteArrayOutputStream.write(ZERO_BYTES);
            }
            if (byArray2 != null) {
                byteArrayOutputStream.write(IntegerUtils.toBytes((int)byArray2.length));
                byteArrayOutputStream.write(byArray2);
            } else {
                byteArrayOutputStream.write(ZERO_BYTES);
            }
            byteArrayOutputStream.write(ENCRYPTION_BYTES);
        }
        catch (IOException iOException) {
            throw new JOSEException(iOException.getMessage(), (Throwable)iOException);
        }
        byArray4 = byteArrayOutputStream.toByteArray();
        try {
            messageDigest = MessageDigest.getInstance("SHA-" + n2);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new JOSEException(noSuchAlgorithmException.getMessage(), (Throwable)noSuchAlgorithmException);
        }
        byte[] byArray6 = messageDigest.digest(byArray4);
        byArray3 = new byte[byArray6.length / 2];
        System.arraycopy(byArray6, 0, byArray3, 0, byArray3.length);
        return new SecretKeySpec(byArray3, "AES");
    }

    public static SecretKey generateCIK(SecretKey secretKey, EncryptionMethod encryptionMethod, byte[] byArray, byte[] byArray2) throws JOSEException {
        MessageDigest messageDigest;
        int n2;
        int n3;
        byte[] byArray3;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            int n4;
            byteArrayOutputStream.write(ONE_BYTES);
            byArray3 = secretKey.getEncoded();
            byteArrayOutputStream.write(byArray3);
            n3 = n4 = byArray3.length * 8;
            n2 = n4;
            byte[] byArray4 = IntegerUtils.toBytes((int)n2);
            byteArrayOutputStream.write(byArray4);
            byte[] byArray5 = encryptionMethod.toString().getBytes(StandardCharset.UTF_8);
            byteArrayOutputStream.write(byArray5);
            if (byArray != null) {
                byteArrayOutputStream.write(IntegerUtils.toBytes((int)byArray.length));
                byteArrayOutputStream.write(byArray);
            } else {
                byteArrayOutputStream.write(ZERO_BYTES);
            }
            if (byArray2 != null) {
                byteArrayOutputStream.write(IntegerUtils.toBytes((int)byArray2.length));
                byteArrayOutputStream.write(byArray2);
            } else {
                byteArrayOutputStream.write(ZERO_BYTES);
            }
            byteArrayOutputStream.write(INTEGRITY_BYTES);
        }
        catch (IOException iOException) {
            throw new JOSEException(iOException.getMessage(), (Throwable)iOException);
        }
        byArray3 = byteArrayOutputStream.toByteArray();
        try {
            messageDigest = MessageDigest.getInstance("SHA-" + n3);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new JOSEException(noSuchAlgorithmException.getMessage(), (Throwable)noSuchAlgorithmException);
        }
        return new SecretKeySpec(messageDigest.digest(byArray3), "HMACSHA" + n2);
    }

    private LegacyConcatKDF() {
    }
}

