/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.jose_8_2_1.crypto.impl;

import java.security.Provider;
import java.security.SecureRandom;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.crypto.SecretKey;
import macromedia.externals.com.nimbusds.jose_8_2_1.EncryptionMethod;
import macromedia.externals.com.nimbusds.jose_8_2_1.JOSEException;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWEAlgorithm;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWECryptoParts;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWEHeader;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.impl.AESKW;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.impl.AlgorithmSupportMessage;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.impl.BaseJWEProvider;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.impl.ConcatKDF;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.impl.ContentCryptoProvider;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.impl.ECDH;
import macromedia.externals.com.nimbusds.jose_8_2_1.jca.JWEJCAContext;
import macromedia.externals.com.nimbusds.jose_8_2_1.jwk.Curve;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.Base64URL;

public abstract class ECDHCryptoProvider
extends BaseJWEProvider {
    public static final Set<JWEAlgorithm> SUPPORTED_ALGORITHMS;
    public static final Set<EncryptionMethod> SUPPORTED_ENCRYPTION_METHODS;
    private final Curve curve;
    private final ConcatKDF concatKDF;

    protected ECDHCryptoProvider(Curve curve) throws JOSEException {
        super(SUPPORTED_ALGORITHMS, ContentCryptoProvider.SUPPORTED_ENCRYPTION_METHODS);
        Curve curve2;
        Curve curve3 = curve2 = curve != null ? curve : new Curve("unknown");
        if (!this.supportedEllipticCurves().contains(curve)) {
            throw new JOSEException(AlgorithmSupportMessage.unsupportedEllipticCurve((Curve)curve2, (Collection)this.supportedEllipticCurves()));
        }
        this.curve = curve;
        this.concatKDF = new ConcatKDF("SHA-256");
    }

    protected ConcatKDF getConcatKDF() {
        return this.concatKDF;
    }

    public abstract Set<Curve> supportedEllipticCurves();

    public Curve getCurve() {
        return this.curve;
    }

    protected JWECryptoParts encryptWithZ(JWEHeader jWEHeader, SecretKey secretKey, byte[] byArray) throws JOSEException {
        return this.encryptWithZ(jWEHeader, secretKey, byArray, null);
    }

    protected JWECryptoParts encryptWithZ(JWEHeader jWEHeader, SecretKey secretKey, byte[] byArray, SecretKey secretKey2) throws JOSEException {
        Base64URL base64URL;
        SecretKey secretKey3;
        JWEAlgorithm jWEAlgorithm = jWEHeader.getAlgorithm();
        ECDH.AlgorithmMode algorithmMode = ECDH.resolveAlgorithmMode((JWEAlgorithm)jWEAlgorithm);
        EncryptionMethod encryptionMethod = jWEHeader.getEncryptionMethod();
        this.getConcatKDF().getJCAContext().setProvider(this.getJCAContext().getMACProvider());
        SecretKey secretKey4 = ECDH.deriveSharedKey((JWEHeader)jWEHeader, (SecretKey)secretKey, (ConcatKDF)this.getConcatKDF());
        if (algorithmMode.equals((Object)ECDH.AlgorithmMode.DIRECT)) {
            secretKey3 = secretKey4;
            base64URL = null;
        } else if (algorithmMode.equals((Object)ECDH.AlgorithmMode.KW)) {
            secretKey3 = secretKey2 != null ? secretKey2 : ContentCryptoProvider.generateCEK((EncryptionMethod)encryptionMethod, (SecureRandom)this.getJCAContext().getSecureRandom());
            base64URL = Base64URL.encode((byte[])AESKW.wrapCEK((SecretKey)secretKey3, (SecretKey)secretKey4, (Provider)this.getJCAContext().getKeyEncryptionProvider()));
        } else {
            throw new JOSEException("Unexpected JWE ECDH algorithm mode: " + algorithmMode);
        }
        return ContentCryptoProvider.encrypt((JWEHeader)jWEHeader, (byte[])byArray, (SecretKey)secretKey3, base64URL, (JWEJCAContext)this.getJCAContext());
    }

    protected byte[] decryptWithZ(JWEHeader jWEHeader, SecretKey secretKey, Base64URL base64URL, Base64URL base64URL2, Base64URL base64URL3, Base64URL base64URL4) throws JOSEException {
        SecretKey secretKey2;
        JWEAlgorithm jWEAlgorithm = jWEHeader.getAlgorithm();
        ECDH.AlgorithmMode algorithmMode = ECDH.resolveAlgorithmMode((JWEAlgorithm)jWEAlgorithm);
        this.getConcatKDF().getJCAContext().setProvider(this.getJCAContext().getMACProvider());
        SecretKey secretKey3 = ECDH.deriveSharedKey((JWEHeader)jWEHeader, (SecretKey)secretKey, (ConcatKDF)this.getConcatKDF());
        if (algorithmMode.equals((Object)ECDH.AlgorithmMode.DIRECT)) {
            secretKey2 = secretKey3;
        } else if (algorithmMode.equals((Object)ECDH.AlgorithmMode.KW)) {
            if (base64URL == null) {
                throw new JOSEException("Missing JWE encrypted key");
            }
            secretKey2 = AESKW.unwrapCEK((SecretKey)secretKey3, (byte[])base64URL.decode(), (Provider)this.getJCAContext().getKeyEncryptionProvider());
        } else {
            throw new JOSEException("Unexpected JWE ECDH algorithm mode: " + algorithmMode);
        }
        return ContentCryptoProvider.decrypt((JWEHeader)jWEHeader, (Base64URL)base64URL, (Base64URL)base64URL2, (Base64URL)base64URL3, (Base64URL)base64URL4, (SecretKey)secretKey2, (JWEJCAContext)this.getJCAContext());
    }

    static {
        SUPPORTED_ENCRYPTION_METHODS = ContentCryptoProvider.SUPPORTED_ENCRYPTION_METHODS;
        LinkedHashSet<JWEAlgorithm> linkedHashSet = new LinkedHashSet<JWEAlgorithm>();
        linkedHashSet.add(JWEAlgorithm.ECDH_ES);
        linkedHashSet.add(JWEAlgorithm.ECDH_ES_A128KW);
        linkedHashSet.add(JWEAlgorithm.ECDH_ES_A192KW);
        linkedHashSet.add(JWEAlgorithm.ECDH_ES_A256KW);
        SUPPORTED_ALGORITHMS = Collections.unmodifiableSet(linkedHashSet);
    }
}

