/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.jose_8_2_1.crypto.impl;

import java.util.Collections;
import java.util.Set;
import macromedia.externals.com.nimbusds.jose_8_2_1.EncryptionMethod;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWEAlgorithm;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWEProvider;
import macromedia.externals.com.nimbusds.jose_8_2_1.jca.JWEJCAContext;

abstract class BaseJWEProvider
implements JWEProvider {
    private final Set<JWEAlgorithm> algs;
    private final Set<EncryptionMethod> encs;
    private final JWEJCAContext jcaContext = new JWEJCAContext();

    public BaseJWEProvider(Set<JWEAlgorithm> set, Set<EncryptionMethod> set2) {
        if (set == null) {
            throw new IllegalArgumentException("The supported JWE algorithm set must not be null");
        }
        this.algs = Collections.unmodifiableSet(set);
        if (set2 == null) {
            throw new IllegalArgumentException("The supported encryption methods must not be null");
        }
        this.encs = set2;
    }

    public Set<JWEAlgorithm> supportedJWEAlgorithms() {
        return this.algs;
    }

    public Set<EncryptionMethod> supportedEncryptionMethods() {
        return this.encs;
    }

    public JWEJCAContext getJCAContext() {
        return this.jcaContext;
    }
}

