/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.jose_8_2_1.crypto.impl;

import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import macromedia.externals.com.nimbusds.jose_8_2_1.JOSEException;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.impl.AuthenticatedCipherText;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.impl.LegacyAESGCM;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.ByteUtils;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.Container;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.KeyUtils;
import net.jcip.annotations.ThreadSafe;

/*
 * Exception performing whole class analysis ignored.
 */
@ThreadSafe
public class AESGCM {
    public static final int IV_BIT_LENGTH = 96;
    public static final int AUTH_TAG_BIT_LENGTH = 128;

    public static byte[] generateIV(SecureRandom secureRandom) {
        byte[] byArray = new byte[12];
        secureRandom.nextBytes(byArray);
        return byArray;
    }

    public static AuthenticatedCipherText encrypt(SecretKey secretKey, Container<byte[]> container, byte[] byArray, byte[] byArray2, Provider provider) throws JOSEException {
        Object object;
        Cipher cipher;
        SecretKey secretKey2 = KeyUtils.toAESKey((SecretKey)secretKey);
        byte[] byArray3 = (byte[])container.get();
        try {
            cipher = provider != null ? Cipher.getInstance("AES/GCM/NoPadding", provider) : Cipher.getInstance("AES/GCM/NoPadding");
            object = new GCMParameterSpec(128, byArray3);
            cipher.init(1, (Key)secretKey2, (AlgorithmParameterSpec)object);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException generalSecurityException) {
            throw new JOSEException("Couldn't create AES/GCM/NoPadding cipher: " + generalSecurityException.getMessage(), (Throwable)generalSecurityException);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            return LegacyAESGCM.encrypt((SecretKey)secretKey2, (byte[])byArray3, (byte[])byArray, (byte[])byArray2);
        }
        cipher.updateAAD(byArray2);
        try {
            object = cipher.doFinal(byArray);
        }
        catch (BadPaddingException | IllegalBlockSizeException generalSecurityException) {
            throw new JOSEException("Couldn't encrypt with AES/GCM/NoPadding: " + generalSecurityException.getMessage(), (Throwable)generalSecurityException);
        }
        int n2 = ((Object)object).length - ByteUtils.byteLength((int)128);
        byte[] byArray4 = ByteUtils.subArray((byte[])object, (int)0, (int)n2);
        byte[] byArray5 = ByteUtils.subArray((byte[])object, (int)n2, (int)ByteUtils.byteLength((int)128));
        container.set((Object)AESGCM.actualIVOf((Cipher)cipher));
        return new AuthenticatedCipherText(byArray4, byArray5);
    }

    private static byte[] actualIVOf(Cipher cipher) throws JOSEException {
        GCMParameterSpec gCMParameterSpec = AESGCM.actualParamsOf((Cipher)cipher);
        byte[] byArray = gCMParameterSpec.getIV();
        int n2 = gCMParameterSpec.getTLen();
        AESGCM.validate((byte[])byArray, (int)n2);
        return byArray;
    }

    private static void validate(byte[] byArray, int n2) throws JOSEException {
        if (ByteUtils.safeBitLength((byte[])byArray) != 96) {
            throw new JOSEException(String.format("IV length of %d bits is required, got %d", 96, ByteUtils.safeBitLength((byte[])byArray)));
        }
        if (n2 != 128) {
            throw new JOSEException(String.format("Authentication tag length of %d bits is required, got %d", 128, n2));
        }
    }

    private static GCMParameterSpec actualParamsOf(Cipher cipher) throws JOSEException {
        AlgorithmParameters algorithmParameters = cipher.getParameters();
        if (algorithmParameters == null) {
            throw new JOSEException("AES GCM ciphers are expected to make use of algorithm parameters");
        }
        try {
            return algorithmParameters.getParameterSpec(GCMParameterSpec.class);
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new JOSEException(invalidParameterSpecException.getMessage(), (Throwable)invalidParameterSpecException);
        }
    }

    public static byte[] decrypt(SecretKey secretKey, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, Provider provider) throws JOSEException {
        Cipher cipher;
        SecretKey secretKey2 = KeyUtils.toAESKey((SecretKey)secretKey);
        try {
            cipher = provider != null ? Cipher.getInstance("AES/GCM/NoPadding", provider) : Cipher.getInstance("AES/GCM/NoPadding");
            GCMParameterSpec gCMParameterSpec = new GCMParameterSpec(128, byArray);
            cipher.init(2, (Key)secretKey2, gCMParameterSpec);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException generalSecurityException) {
            throw new JOSEException("Couldn't create AES/GCM/NoPadding cipher: " + generalSecurityException.getMessage(), (Throwable)generalSecurityException);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            return LegacyAESGCM.decrypt((SecretKey)secretKey2, (byte[])byArray, (byte[])byArray2, (byte[])byArray3, (byte[])byArray4);
        }
        cipher.updateAAD(byArray3);
        try {
            return cipher.doFinal(ByteUtils.concat((byte[][])new byte[][]{byArray2, byArray4}));
        }
        catch (BadPaddingException | IllegalBlockSizeException generalSecurityException) {
            throw new JOSEException("AES/GCM/NoPadding decryption failed: " + generalSecurityException.getMessage(), (Throwable)generalSecurityException);
        }
    }

    private AESGCM() {
    }
}

