/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.jose_8_2_1.crypto.impl;

import java.nio.ByteBuffer;
import java.security.Key;
import java.security.Provider;
import java.security.SecureRandom;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import macromedia.externals.com.nimbusds.jose_8_2_1.EncryptionMethod;
import macromedia.externals.com.nimbusds.jose_8_2_1.JOSEException;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWEHeader;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.impl.AAD;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.impl.AuthenticatedCipherText;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.impl.CipherHelper;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.impl.CompositeKey;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.impl.HMAC;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.impl.LegacyConcatKDF;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.utils.ConstantTimeUtils;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.Base64URL;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.ByteUtils;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.StandardCharset;
import net.jcip.annotations.ThreadSafe;

/*
 * Exception performing whole class analysis ignored.
 */
@ThreadSafe
public class AESCBC {
    public static final int IV_BIT_LENGTH = 128;

    public static byte[] generateIV(SecureRandom secureRandom) {
        byte[] byArray = new byte[ByteUtils.byteLength((int)128)];
        secureRandom.nextBytes(byArray);
        return byArray;
    }

    private static Cipher createAESCBCCipher(SecretKey secretKey, boolean bl2, byte[] byArray, Provider provider) throws JOSEException {
        Cipher cipher;
        try {
            cipher = CipherHelper.getInstance((String)"AES/CBC/PKCS5Padding", (Provider)provider);
            SecretKeySpec secretKeySpec = new SecretKeySpec(secretKey.getEncoded(), "AES");
            IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray);
            if (bl2) {
                cipher.init(1, (Key)secretKeySpec, ivParameterSpec);
            } else {
                cipher.init(2, (Key)secretKeySpec, ivParameterSpec);
            }
        }
        catch (Exception exception) {
            throw new JOSEException(exception.getMessage(), (Throwable)exception);
        }
        return cipher;
    }

    public static byte[] encrypt(SecretKey secretKey, byte[] byArray, byte[] byArray2, Provider provider) throws JOSEException {
        Cipher cipher = AESCBC.createAESCBCCipher((SecretKey)secretKey, (boolean)true, (byte[])byArray, (Provider)provider);
        try {
            return cipher.doFinal(byArray2);
        }
        catch (Exception exception) {
            throw new JOSEException(exception.getMessage(), (Throwable)exception);
        }
    }

    public static AuthenticatedCipherText encryptAuthenticated(SecretKey secretKey, byte[] byArray, byte[] byArray2, byte[] byArray3, Provider provider, Provider provider2) throws JOSEException {
        CompositeKey compositeKey = new CompositeKey(secretKey);
        byte[] byArray4 = AESCBC.encrypt((SecretKey)compositeKey.getAESKey(), (byte[])byArray, (byte[])byArray2, (Provider)provider);
        byte[] byArray5 = AAD.computeLength((byte[])byArray3);
        int n2 = byArray3.length + byArray.length + byArray4.length + byArray5.length;
        byte[] byArray6 = ByteBuffer.allocate(n2).put(byArray3).put(byArray).put(byArray4).put(byArray5).array();
        byte[] byArray7 = HMAC.compute((SecretKey)compositeKey.getMACKey(), (byte[])byArray6, (Provider)provider2);
        byte[] byArray8 = Arrays.copyOf(byArray7, compositeKey.getTruncatedMACByteLength());
        return new AuthenticatedCipherText(byArray4, byArray8);
    }

    public static AuthenticatedCipherText encryptWithConcatKDF(JWEHeader jWEHeader, SecretKey secretKey, Base64URL base64URL, byte[] byArray, byte[] byArray2, Provider provider, Provider provider2) throws JOSEException {
        byte[] byArray3 = null;
        if (jWEHeader.getCustomParam("epu") instanceof String) {
            byArray3 = new Base64URL((String)jWEHeader.getCustomParam("epu")).decode();
        }
        byte[] byArray4 = null;
        if (jWEHeader.getCustomParam("epv") instanceof String) {
            byArray4 = new Base64URL((String)jWEHeader.getCustomParam("epv")).decode();
        }
        SecretKey secretKey2 = LegacyConcatKDF.generateCEK((SecretKey)secretKey, (EncryptionMethod)jWEHeader.getEncryptionMethod(), (byte[])byArray3, byArray4);
        byte[] byArray5 = AESCBC.encrypt((SecretKey)secretKey2, (byte[])byArray, (byte[])byArray2, (Provider)provider);
        SecretKey secretKey3 = LegacyConcatKDF.generateCIK((SecretKey)secretKey, (EncryptionMethod)jWEHeader.getEncryptionMethod(), (byte[])byArray3, (byte[])byArray4);
        String string = jWEHeader.toBase64URL().toString() + "." + base64URL.toString() + "." + Base64URL.encode((byte[])byArray).toString() + "." + Base64URL.encode((byte[])byArray5);
        byte[] byArray6 = HMAC.compute((SecretKey)secretKey3, (byte[])string.getBytes(StandardCharset.UTF_8), (Provider)provider2);
        return new AuthenticatedCipherText(byArray5, byArray6);
    }

    public static byte[] decrypt(SecretKey secretKey, byte[] byArray, byte[] byArray2, Provider provider) throws JOSEException {
        Cipher cipher = AESCBC.createAESCBCCipher((SecretKey)secretKey, (boolean)false, (byte[])byArray, (Provider)provider);
        try {
            return cipher.doFinal(byArray2);
        }
        catch (Exception exception) {
            throw new JOSEException(exception.getMessage(), (Throwable)exception);
        }
    }

    public static byte[] decryptAuthenticated(SecretKey secretKey, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, Provider provider, Provider provider2) throws JOSEException {
        CompositeKey compositeKey = new CompositeKey(secretKey);
        byte[] byArray5 = AAD.computeLength((byte[])byArray3);
        int n2 = byArray3.length + byArray.length + byArray2.length + byArray5.length;
        byte[] byArray6 = ByteBuffer.allocate(n2).put(byArray3).put(byArray).put(byArray2).put(byArray5).array();
        byte[] byArray7 = HMAC.compute((SecretKey)compositeKey.getMACKey(), (byte[])byArray6, (Provider)provider2);
        byte[] byArray8 = Arrays.copyOf(byArray7, compositeKey.getTruncatedMACByteLength());
        if (!ConstantTimeUtils.areEqual((byte[])byArray8, (byte[])byArray4)) {
            throw new JOSEException("MAC check failed");
        }
        return AESCBC.decrypt((SecretKey)compositeKey.getAESKey(), (byte[])byArray, (byte[])byArray2, (Provider)provider);
    }

    public static byte[] decryptWithConcatKDF(JWEHeader jWEHeader, SecretKey secretKey, Base64URL base64URL, Base64URL base64URL2, Base64URL base64URL3, Base64URL base64URL4, Provider provider, Provider provider2) throws JOSEException {
        byte[] byArray = null;
        if (jWEHeader.getCustomParam("epu") instanceof String) {
            byArray = new Base64URL((String)jWEHeader.getCustomParam("epu")).decode();
        }
        byte[] byArray2 = null;
        if (jWEHeader.getCustomParam("epv") instanceof String) {
            byArray2 = new Base64URL((String)jWEHeader.getCustomParam("epv")).decode();
        }
        SecretKey secretKey2 = LegacyConcatKDF.generateCIK((SecretKey)secretKey, (EncryptionMethod)jWEHeader.getEncryptionMethod(), (byte[])byArray, byArray2);
        String string = jWEHeader.toBase64URL().toString() + "." + base64URL.toString() + "." + base64URL2.toString() + "." + base64URL3.toString();
        byte[] byArray3 = HMAC.compute((SecretKey)secretKey2, (byte[])string.getBytes(StandardCharset.UTF_8), (Provider)provider2);
        if (!ConstantTimeUtils.areEqual((byte[])base64URL4.decode(), (byte[])byArray3)) {
            throw new JOSEException("MAC check failed");
        }
        SecretKey secretKey3 = LegacyConcatKDF.generateCEK((SecretKey)secretKey, (EncryptionMethod)jWEHeader.getEncryptionMethod(), (byte[])byArray, (byte[])byArray2);
        return AESCBC.decrypt((SecretKey)secretKey3, (byte[])base64URL2.decode(), (byte[])base64URL3.decode(), (Provider)provider);
    }

    private AESCBC() {
    }
}

