/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.jose_8_2_1.crypto;

import com.google.crypto.tink.subtle.X25519;
import java.security.InvalidKeyException;
import java.util.Collections;
import java.util.Set;
import javax.crypto.SecretKey;
import macromedia.externals.com.nimbusds.jose_8_2_1.JOSEException;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWECryptoParts;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWEEncrypter;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWEHeader;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.impl.ECDH;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.impl.ECDHCryptoProvider;
import macromedia.externals.com.nimbusds.jose_8_2_1.jwk.Curve;
import macromedia.externals.com.nimbusds.jose_8_2_1.jwk.JWK;
import macromedia.externals.com.nimbusds.jose_8_2_1.jwk.OctetKeyPair;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.Base64URL;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class X25519Encrypter
extends ECDHCryptoProvider
implements JWEEncrypter {
    private final OctetKeyPair publicKey;

    public X25519Encrypter(OctetKeyPair octetKeyPair) throws JOSEException {
        super(octetKeyPair.getCurve());
        if (!Curve.X25519.equals((Object)octetKeyPair.getCurve())) {
            throw new JOSEException("X25519Encrypter only supports OctetKeyPairs with crv=X25519");
        }
        if (octetKeyPair.isPrivate()) {
            throw new JOSEException("X25519Encrypter requires a public key, use OctetKeyPair.toPublicJWK()");
        }
        this.publicKey = octetKeyPair;
    }

    public Set<Curve> supportedEllipticCurves() {
        return Collections.singleton(Curve.X25519);
    }

    public OctetKeyPair getPublicKey() {
        return this.publicKey;
    }

    public JWECryptoParts encrypt(JWEHeader jWEHeader, byte[] byArray) throws JOSEException {
        byte[] byArray2;
        byte[] byArray3 = X25519.generatePrivateKey();
        try {
            byArray2 = X25519.publicFromPrivate((byte[])byArray3);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new JOSEException(invalidKeyException.getMessage(), (Throwable)invalidKeyException);
        }
        OctetKeyPair octetKeyPair = new OctetKeyPair.Builder(this.getCurve(), Base64URL.encode((byte[])byArray2)).d(Base64URL.encode((byte[])byArray3)).build();
        OctetKeyPair octetKeyPair2 = octetKeyPair.toPublicJWK();
        JWEHeader jWEHeader2 = new JWEHeader.Builder(jWEHeader).ephemeralPublicKey((JWK)octetKeyPair2).build();
        SecretKey secretKey = ECDH.deriveSharedSecret((OctetKeyPair)this.publicKey, (OctetKeyPair)octetKeyPair);
        return this.encryptWithZ(jWEHeader2, secretKey, byArray);
    }
}

