/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.jose_8_2_1.crypto;

import java.security.InvalidKeyException;
import java.security.Provider;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.RSAPublicKey;
import java.util.Set;
import macromedia.externals.com.nimbusds.jose_8_2_1.CriticalHeaderParamsAware;
import macromedia.externals.com.nimbusds.jose_8_2_1.Header;
import macromedia.externals.com.nimbusds.jose_8_2_1.JOSEException;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWSAlgorithm;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWSHeader;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWSVerifier;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.impl.CriticalHeaderParamsDeferral;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.impl.RSASSA;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.impl.RSASSAProvider;
import macromedia.externals.com.nimbusds.jose_8_2_1.jwk.RSAKey;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.Base64URL;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class RSASSAVerifier
extends RSASSAProvider
implements CriticalHeaderParamsAware,
JWSVerifier {
    private final CriticalHeaderParamsDeferral critPolicy = new CriticalHeaderParamsDeferral();
    private final RSAPublicKey publicKey;

    public RSASSAVerifier(RSAPublicKey rSAPublicKey) {
        this(rSAPublicKey, null);
    }

    public RSASSAVerifier(RSAKey rSAKey) throws JOSEException {
        this(rSAKey.toRSAPublicKey(), null);
    }

    public RSASSAVerifier(RSAPublicKey rSAPublicKey, Set<String> set) {
        if (rSAPublicKey == null) {
            throw new IllegalArgumentException("The public RSA key must not be null");
        }
        this.publicKey = rSAPublicKey;
        this.critPolicy.setDeferredCriticalHeaderParams(set);
    }

    public RSAPublicKey getPublicKey() {
        return this.publicKey;
    }

    public Set<String> getProcessedCriticalHeaderParams() {
        return this.critPolicy.getProcessedCriticalHeaderParams();
    }

    public Set<String> getDeferredCriticalHeaderParams() {
        return this.critPolicy.getProcessedCriticalHeaderParams();
    }

    public boolean verify(JWSHeader jWSHeader, byte[] byArray, Base64URL base64URL) throws JOSEException {
        if (!this.critPolicy.headerPasses((Header)jWSHeader)) {
            return false;
        }
        Signature signature = RSASSA.getSignerAndVerifier((JWSAlgorithm)jWSHeader.getAlgorithm(), (Provider)this.getJCAContext().getProvider());
        try {
            signature.initVerify(this.publicKey);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new JOSEException("Invalid public RSA key: " + invalidKeyException.getMessage(), (Throwable)invalidKeyException);
        }
        try {
            signature.update(byArray);
            return signature.verify(base64URL.decode());
        }
        catch (SignatureException signatureException) {
            return false;
        }
    }
}

