/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.jose_8_2_1.crypto;

import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Signature;
import java.security.SignatureException;
import macromedia.externals.com.nimbusds.jose_8_2_1.JOSEException;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWSAlgorithm;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWSHeader;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWSSigner;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.impl.RSAKeyUtils;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.impl.RSASSA;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.impl.RSASSAProvider;
import macromedia.externals.com.nimbusds.jose_8_2_1.jwk.RSAKey;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.Base64URL;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class RSASSASigner
extends RSASSAProvider
implements JWSSigner {
    private final PrivateKey privateKey;

    public RSASSASigner(PrivateKey privateKey) {
        this(privateKey, false);
    }

    public RSASSASigner(PrivateKey privateKey, boolean bl2) {
        int n2;
        if (!"RSA".equalsIgnoreCase(privateKey.getAlgorithm())) {
            throw new IllegalArgumentException("The private key algorithm must be RSA");
        }
        if (!bl2 && (n2 = RSAKeyUtils.keyBitLength((PrivateKey)privateKey)) > 0 && n2 < 2048) {
            throw new IllegalArgumentException("The RSA key size must be at least 2048 bits");
        }
        this.privateKey = privateKey;
    }

    public RSASSASigner(RSAKey rSAKey) throws JOSEException {
        this(rSAKey, false);
    }

    public RSASSASigner(RSAKey rSAKey, boolean bl2) throws JOSEException {
        this(RSAKeyUtils.toRSAPrivateKey((RSAKey)rSAKey), bl2);
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public Base64URL sign(JWSHeader jWSHeader, byte[] byArray) throws JOSEException {
        Signature signature = RSASSA.getSignerAndVerifier((JWSAlgorithm)jWSHeader.getAlgorithm(), (Provider)this.getJCAContext().getProvider());
        try {
            signature.initSign(this.privateKey);
            signature.update(byArray);
            return Base64URL.encode((byte[])signature.sign());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new JOSEException("Invalid private RSA key: " + invalidKeyException.getMessage(), (Throwable)invalidKeyException);
        }
        catch (SignatureException signatureException) {
            throw new JOSEException("RSA signature exception: " + signatureException.getMessage(), (Throwable)signatureException);
        }
    }
}

