/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.jose_8_2_1.crypto;

import java.security.Provider;
import java.security.SecureRandom;
import java.security.interfaces.RSAPublicKey;
import java.util.Collection;
import javax.crypto.SecretKey;
import macromedia.externals.com.nimbusds.jose_8_2_1.EncryptionMethod;
import macromedia.externals.com.nimbusds.jose_8_2_1.JOSEException;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWEAlgorithm;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWECryptoParts;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWEEncrypter;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWEHeader;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.impl.AlgorithmSupportMessage;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.impl.ContentCryptoProvider;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.impl.RSA1_5;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.impl.RSACryptoProvider;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.impl.RSA_OAEP;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.impl.RSA_OAEP_256;
import macromedia.externals.com.nimbusds.jose_8_2_1.jca.JWEJCAContext;
import macromedia.externals.com.nimbusds.jose_8_2_1.jwk.RSAKey;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.Base64URL;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class RSAEncrypter
extends RSACryptoProvider
implements JWEEncrypter {
    private final RSAPublicKey publicKey;
    private final SecretKey contentEncryptionKey;

    public RSAEncrypter(RSAPublicKey rSAPublicKey) {
        this(rSAPublicKey, null);
    }

    public RSAEncrypter(RSAKey rSAKey) throws JOSEException {
        this(rSAKey.toRSAPublicKey());
    }

    public RSAEncrypter(RSAPublicKey rSAPublicKey, SecretKey secretKey) {
        if (rSAPublicKey == null) {
            throw new IllegalArgumentException("The public RSA key must not be null");
        }
        this.publicKey = rSAPublicKey;
        if (secretKey != null) {
            if (secretKey.getAlgorithm() == null || !secretKey.getAlgorithm().equals("AES")) {
                throw new IllegalArgumentException("The algorithm of the content encryption key (CEK) must be AES");
            }
            this.contentEncryptionKey = secretKey;
        } else {
            this.contentEncryptionKey = null;
        }
    }

    public RSAPublicKey getPublicKey() {
        return this.publicKey;
    }

    public JWECryptoParts encrypt(JWEHeader jWEHeader, byte[] byArray) throws JOSEException {
        Base64URL base64URL;
        JWEAlgorithm jWEAlgorithm = jWEHeader.getAlgorithm();
        EncryptionMethod encryptionMethod = jWEHeader.getEncryptionMethod();
        SecretKey secretKey = this.contentEncryptionKey != null ? this.contentEncryptionKey : ContentCryptoProvider.generateCEK((EncryptionMethod)encryptionMethod, (SecureRandom)this.getJCAContext().getSecureRandom());
        if (jWEAlgorithm.equals((Object)JWEAlgorithm.RSA1_5)) {
            base64URL = Base64URL.encode((byte[])RSA1_5.encryptCEK((RSAPublicKey)this.publicKey, (SecretKey)secretKey, (Provider)this.getJCAContext().getKeyEncryptionProvider()));
        } else if (jWEAlgorithm.equals((Object)JWEAlgorithm.RSA_OAEP)) {
            base64URL = Base64URL.encode((byte[])RSA_OAEP.encryptCEK((RSAPublicKey)this.publicKey, (SecretKey)secretKey, (Provider)this.getJCAContext().getKeyEncryptionProvider()));
        } else if (jWEAlgorithm.equals((Object)JWEAlgorithm.RSA_OAEP_256)) {
            base64URL = Base64URL.encode((byte[])RSA_OAEP_256.encryptCEK((RSAPublicKey)this.publicKey, (SecretKey)secretKey, (Provider)this.getJCAContext().getKeyEncryptionProvider()));
        } else {
            throw new JOSEException(AlgorithmSupportMessage.unsupportedJWEAlgorithm((JWEAlgorithm)jWEAlgorithm, (Collection)SUPPORTED_ALGORITHMS));
        }
        return ContentCryptoProvider.encrypt((JWEHeader)jWEHeader, (byte[])byArray, (SecretKey)secretKey, (Base64URL)base64URL, (JWEJCAContext)this.getJCAContext());
    }
}

