/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.jose_8_2_1.crypto;

import java.security.Provider;
import java.security.SecureRandom;
import javax.crypto.SecretKey;
import macromedia.externals.com.nimbusds.jose_8_2_1.EncryptionMethod;
import macromedia.externals.com.nimbusds.jose_8_2_1.JOSEException;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWEAlgorithm;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWECryptoParts;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWEEncrypter;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWEHeader;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.impl.AESKW;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.impl.ContentCryptoProvider;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.impl.PBKDF2;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.impl.PRFParams;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.impl.PasswordBasedCryptoProvider;
import macromedia.externals.com.nimbusds.jose_8_2_1.jca.JWEJCAContext;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.Base64URL;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.StandardCharset;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class PasswordBasedEncrypter
extends PasswordBasedCryptoProvider
implements JWEEncrypter {
    public static final int MIN_SALT_LENGTH = 8;
    private final int saltLength;
    public static final int MIN_RECOMMENDED_ITERATION_COUNT = 1000;
    private final int iterationCount;

    public PasswordBasedEncrypter(byte[] byArray, int n2, int n3) {
        super(byArray);
        if (n2 < 8) {
            throw new IllegalArgumentException("The minimum salt length (p2s) is 8 bytes");
        }
        this.saltLength = n2;
        if (n3 < 1000) {
            throw new IllegalArgumentException("The minimum recommended iteration count (p2c) is 1000");
        }
        this.iterationCount = n3;
    }

    public PasswordBasedEncrypter(String string, int n2, int n3) {
        this(string.getBytes(StandardCharset.UTF_8), n2, n3);
    }

    public JWECryptoParts encrypt(JWEHeader jWEHeader, byte[] byArray) throws JOSEException {
        JWEAlgorithm jWEAlgorithm = jWEHeader.getAlgorithm();
        EncryptionMethod encryptionMethod = jWEHeader.getEncryptionMethod();
        byte[] byArray2 = new byte[this.saltLength];
        this.getJCAContext().getSecureRandom().nextBytes(byArray2);
        byte[] byArray3 = PBKDF2.formatSalt((JWEAlgorithm)jWEAlgorithm, (byte[])byArray2);
        PRFParams pRFParams = PRFParams.resolve((JWEAlgorithm)jWEAlgorithm, (Provider)this.getJCAContext().getMACProvider());
        SecretKey secretKey = PBKDF2.deriveKey((byte[])this.getPassword(), (byte[])byArray3, (int)this.iterationCount, (PRFParams)pRFParams);
        JWEHeader jWEHeader2 = new JWEHeader.Builder(jWEHeader).pbes2Salt(Base64URL.encode((byte[])byArray2)).pbes2Count(this.iterationCount).build();
        SecretKey secretKey2 = ContentCryptoProvider.generateCEK((EncryptionMethod)encryptionMethod, (SecureRandom)this.getJCAContext().getSecureRandom());
        Base64URL base64URL = Base64URL.encode((byte[])AESKW.wrapCEK((SecretKey)secretKey2, (SecretKey)secretKey, (Provider)this.getJCAContext().getKeyEncryptionProvider()));
        return ContentCryptoProvider.encrypt((JWEHeader)jWEHeader2, (byte[])byArray, (SecretKey)secretKey2, (Base64URL)base64URL, (JWEJCAContext)this.getJCAContext());
    }

    public int getSaltLength() {
        return this.saltLength;
    }

    public int getIterationCount() {
        return this.iterationCount;
    }
}

