/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.jose_8_2_1.crypto;

import java.security.Provider;
import java.util.Set;
import javax.crypto.SecretKey;
import macromedia.externals.com.nimbusds.jose_8_2_1.CriticalHeaderParamsAware;
import macromedia.externals.com.nimbusds.jose_8_2_1.Header;
import macromedia.externals.com.nimbusds.jose_8_2_1.JOSEException;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWSAlgorithm;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWSHeader;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWSVerifier;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.impl.CriticalHeaderParamsDeferral;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.impl.HMAC;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.impl.MACProvider;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.utils.ConstantTimeUtils;
import macromedia.externals.com.nimbusds.jose_8_2_1.jwk.OctetSequenceKey;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.Base64URL;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.StandardCharset;
import net.jcip.annotations.ThreadSafe;

/*
 * Exception performing whole class analysis ignored.
 */
@ThreadSafe
public class MACVerifier
extends MACProvider
implements CriticalHeaderParamsAware,
JWSVerifier {
    private final CriticalHeaderParamsDeferral critPolicy = new CriticalHeaderParamsDeferral();

    public MACVerifier(byte[] byArray) throws JOSEException {
        this(byArray, null);
    }

    public MACVerifier(String string) throws JOSEException {
        this(string.getBytes(StandardCharset.UTF_8));
    }

    public MACVerifier(SecretKey secretKey) throws JOSEException {
        this(secretKey.getEncoded());
    }

    public MACVerifier(OctetSequenceKey octetSequenceKey) throws JOSEException {
        this(octetSequenceKey.toByteArray());
    }

    public MACVerifier(OctetSequenceKey octetSequenceKey, Set<String> set) throws JOSEException {
        this(octetSequenceKey.toByteArray(), set);
    }

    public MACVerifier(byte[] byArray, Set<String> set) throws JOSEException {
        super(byArray, SUPPORTED_ALGORITHMS);
        this.critPolicy.setDeferredCriticalHeaderParams(set);
    }

    public Set<String> getProcessedCriticalHeaderParams() {
        return this.critPolicy.getProcessedCriticalHeaderParams();
    }

    public Set<String> getDeferredCriticalHeaderParams() {
        return this.critPolicy.getProcessedCriticalHeaderParams();
    }

    public boolean verify(JWSHeader jWSHeader, byte[] byArray, Base64URL base64URL) throws JOSEException {
        if (!this.critPolicy.headerPasses((Header)jWSHeader)) {
            return false;
        }
        String string = MACVerifier.getJCAAlgorithmName((JWSAlgorithm)jWSHeader.getAlgorithm());
        byte[] byArray2 = HMAC.compute((String)string, (byte[])this.getSecret(), (byte[])byArray, (Provider)this.getJCAContext().getProvider());
        return ConstantTimeUtils.areEqual((byte[])byArray2, (byte[])base64URL.decode());
    }
}

