/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.jose_8_2_1.crypto;

import java.security.Provider;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.crypto.SecretKey;
import macromedia.externals.com.nimbusds.jose_8_2_1.JOSEException;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWSAlgorithm;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWSHeader;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWSSigner;
import macromedia.externals.com.nimbusds.jose_8_2_1.KeyLengthException;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.impl.AlgorithmSupportMessage;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.impl.HMAC;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.impl.MACProvider;
import macromedia.externals.com.nimbusds.jose_8_2_1.jwk.OctetSequenceKey;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.Base64URL;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.ByteUtils;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.StandardCharset;
import net.jcip.annotations.ThreadSafe;

/*
 * Exception performing whole class analysis ignored.
 */
@ThreadSafe
public class MACSigner
extends MACProvider
implements JWSSigner {
    public static int getMinRequiredSecretLength(JWSAlgorithm jWSAlgorithm) throws JOSEException {
        if (JWSAlgorithm.HS256.equals((Object)jWSAlgorithm)) {
            return 256;
        }
        if (JWSAlgorithm.HS384.equals((Object)jWSAlgorithm)) {
            return 384;
        }
        if (JWSAlgorithm.HS512.equals((Object)jWSAlgorithm)) {
            return 512;
        }
        throw new JOSEException(AlgorithmSupportMessage.unsupportedJWSAlgorithm((JWSAlgorithm)jWSAlgorithm, (Collection)SUPPORTED_ALGORITHMS));
    }

    public static Set<JWSAlgorithm> getCompatibleAlgorithms(int n2) {
        LinkedHashSet<JWSAlgorithm> linkedHashSet = new LinkedHashSet<JWSAlgorithm>();
        if (n2 >= 256) {
            linkedHashSet.add(JWSAlgorithm.HS256);
        }
        if (n2 >= 384) {
            linkedHashSet.add(JWSAlgorithm.HS384);
        }
        if (n2 >= 512) {
            linkedHashSet.add(JWSAlgorithm.HS512);
        }
        return Collections.unmodifiableSet(linkedHashSet);
    }

    public MACSigner(byte[] byArray) throws KeyLengthException {
        super(byArray, MACSigner.getCompatibleAlgorithms((int)ByteUtils.bitLength((int)byArray.length)));
    }

    public MACSigner(String string) throws KeyLengthException {
        this(string.getBytes(StandardCharset.UTF_8));
    }

    public MACSigner(SecretKey secretKey) throws KeyLengthException {
        this(secretKey.getEncoded());
    }

    public MACSigner(OctetSequenceKey octetSequenceKey) throws KeyLengthException {
        this(octetSequenceKey.toByteArray());
    }

    public Base64URL sign(JWSHeader jWSHeader, byte[] byArray) throws JOSEException {
        int n2 = MACSigner.getMinRequiredSecretLength((JWSAlgorithm)jWSHeader.getAlgorithm());
        if (this.getSecret().length < ByteUtils.byteLength((int)n2)) {
            throw new KeyLengthException("The secret length for " + jWSHeader.getAlgorithm() + " must be at least " + n2 + " bits");
        }
        String string = MACSigner.getJCAAlgorithmName((JWSAlgorithm)jWSHeader.getAlgorithm());
        byte[] byArray2 = HMAC.compute((String)string, (byte[])this.getSecret(), (byte[])byArray, (Provider)this.getJCAContext().getProvider());
        return Base64URL.encode((byte[])byArray2);
    }
}

