/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.jose_8_2_1.crypto;

import com.google.crypto.tink.subtle.Ed25519Sign;
import java.security.GeneralSecurityException;
import macromedia.externals.com.nimbusds.jose_8_2_1.JOSEException;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWSAlgorithm;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWSHeader;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWSSigner;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.impl.EdDSAProvider;
import macromedia.externals.com.nimbusds.jose_8_2_1.jwk.Curve;
import macromedia.externals.com.nimbusds.jose_8_2_1.jwk.OctetKeyPair;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.Base64URL;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class Ed25519Signer
extends EdDSAProvider
implements JWSSigner {
    private final OctetKeyPair privateKey;
    private final Ed25519Sign tinkSigner;

    public Ed25519Signer(OctetKeyPair octetKeyPair) throws JOSEException {
        if (!Curve.Ed25519.equals((Object)octetKeyPair.getCurve())) {
            throw new JOSEException("Ed25519Signer only supports OctetKeyPairs with crv=Ed25519");
        }
        if (!octetKeyPair.isPrivate()) {
            throw new JOSEException("The OctetKeyPair doesn't contain a private part");
        }
        this.privateKey = octetKeyPair;
        try {
            this.tinkSigner = new Ed25519Sign(octetKeyPair.getDecodedD());
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new JOSEException(generalSecurityException.getMessage(), (Throwable)generalSecurityException);
        }
    }

    public OctetKeyPair getPrivateKey() {
        return this.privateKey;
    }

    public Base64URL sign(JWSHeader jWSHeader, byte[] byArray) throws JOSEException {
        byte[] byArray2;
        JWSAlgorithm jWSAlgorithm = jWSHeader.getAlgorithm();
        if (!JWSAlgorithm.EdDSA.equals((Object)jWSAlgorithm)) {
            throw new JOSEException("Ed25519Signer requires alg=EdDSA in JWSHeader");
        }
        try {
            byArray2 = this.tinkSigner.sign(byArray);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new JOSEException(generalSecurityException.getMessage(), (Throwable)generalSecurityException);
        }
        return Base64URL.encode((byte[])byArray2);
    }
}

