/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.jose_8_2_1.crypto;

import java.security.InvalidKeyException;
import java.security.Provider;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.ECKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.util.Collection;
import java.util.Set;
import macromedia.externals.com.nimbusds.jose_8_2_1.CriticalHeaderParamsAware;
import macromedia.externals.com.nimbusds.jose_8_2_1.Header;
import macromedia.externals.com.nimbusds.jose_8_2_1.JOSEException;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWSAlgorithm;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWSHeader;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWSVerifier;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.impl.AlgorithmSupportMessage;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.impl.CriticalHeaderParamsDeferral;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.impl.ECDSA;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.impl.ECDSAProvider;
import macromedia.externals.com.nimbusds.jose_8_2_1.crypto.utils.ECChecks;
import macromedia.externals.com.nimbusds.jose_8_2_1.jwk.Curve;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.Base64URL;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class ECDSAVerifier
extends ECDSAProvider
implements CriticalHeaderParamsAware,
JWSVerifier {
    private final CriticalHeaderParamsDeferral critPolicy = new CriticalHeaderParamsDeferral();
    private final ECPublicKey publicKey;

    public ECDSAVerifier(ECPublicKey eCPublicKey) throws JOSEException {
        this(eCPublicKey, null);
    }

    public ECDSAVerifier(macromedia.externals.com.nimbusds.jose_8_2_1.jwk.ECKey eCKey) throws JOSEException {
        this(eCKey.toECPublicKey());
    }

    public ECDSAVerifier(ECPublicKey eCPublicKey, Set<String> set) throws JOSEException {
        super(ECDSA.resolveAlgorithm((ECKey)eCPublicKey));
        this.publicKey = eCPublicKey;
        if (!ECChecks.isPointOnCurve((ECPublicKey)eCPublicKey, (ECParameterSpec)((Curve)Curve.forJWSAlgorithm((JWSAlgorithm)this.supportedECDSAAlgorithm()).iterator().next()).toECParameterSpec())) {
            throw new JOSEException("Curve / public key parameters mismatch");
        }
        this.critPolicy.setDeferredCriticalHeaderParams(set);
    }

    public ECPublicKey getPublicKey() {
        return this.publicKey;
    }

    public Set<String> getProcessedCriticalHeaderParams() {
        return this.critPolicy.getProcessedCriticalHeaderParams();
    }

    public Set<String> getDeferredCriticalHeaderParams() {
        return this.critPolicy.getProcessedCriticalHeaderParams();
    }

    public boolean verify(JWSHeader jWSHeader, byte[] byArray, Base64URL base64URL) throws JOSEException {
        byte[] byArray2;
        JWSAlgorithm jWSAlgorithm = jWSHeader.getAlgorithm();
        if (!this.supportedJWSAlgorithms().contains(jWSAlgorithm)) {
            throw new JOSEException(AlgorithmSupportMessage.unsupportedJWSAlgorithm((JWSAlgorithm)jWSAlgorithm, (Collection)this.supportedJWSAlgorithms()));
        }
        if (!this.critPolicy.headerPasses((Header)jWSHeader)) {
            return false;
        }
        byte[] byArray3 = base64URL.decode();
        try {
            byArray2 = ECDSA.transcodeSignatureToDER((byte[])byArray3);
        }
        catch (JOSEException jOSEException) {
            return false;
        }
        Signature signature = ECDSA.getSignerAndVerifier((JWSAlgorithm)jWSAlgorithm, (Provider)this.getJCAContext().getProvider());
        try {
            signature.initVerify(this.publicKey);
            signature.update(byArray);
            return signature.verify(byArray2);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new JOSEException("Invalid EC public key: " + invalidKeyException.getMessage(), (Throwable)invalidKeyException);
        }
        catch (SignatureException signatureException) {
            return false;
        }
    }
}

