/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.jose_8_2_1;

import java.text.ParseException;
import macromedia.externals.com.nimbusds.jose_8_2_1.JOSEObject;
import macromedia.externals.com.nimbusds.jose_8_2_1.Payload;
import macromedia.externals.com.nimbusds.jose_8_2_1.PlainHeader;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.Base64URL;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class PlainObject
extends JOSEObject {
    private static final long serialVersionUID = 1L;
    private final PlainHeader header;

    public PlainObject(Payload payload) {
        if (payload == null) {
            throw new IllegalArgumentException("The payload must not be null");
        }
        this.setPayload(payload);
        this.header = new PlainHeader();
    }

    public PlainObject(PlainHeader plainHeader, Payload payload) {
        if (plainHeader == null) {
            throw new IllegalArgumentException("The unsecured header must not be null");
        }
        this.header = plainHeader;
        if (payload == null) {
            throw new IllegalArgumentException("The payload must not be null");
        }
        this.setPayload(payload);
    }

    public PlainObject(Base64URL base64URL, Base64URL base64URL2) throws ParseException {
        if (base64URL == null) {
            throw new IllegalArgumentException("The first part must not be null");
        }
        try {
            this.header = PlainHeader.parse((Base64URL)base64URL);
        }
        catch (ParseException parseException) {
            throw new ParseException("Invalid unsecured header: " + parseException.getMessage(), 0);
        }
        if (base64URL2 == null) {
            throw new IllegalArgumentException("The second part must not be null");
        }
        this.setPayload(new Payload(base64URL2));
        this.setParsedParts(new Base64URL[]{base64URL, base64URL2, null});
    }

    public PlainHeader getHeader() {
        return this.header;
    }

    public String serialize() {
        return this.header.toBase64URL().toString() + '.' + this.getPayload().toBase64URL().toString() + '.';
    }

    public static PlainObject parse(String string) throws ParseException {
        Base64URL[] base64URLArray = JOSEObject.split((String)string);
        if (!base64URLArray[2].toString().isEmpty()) {
            throw new ParseException("Unexpected third Base64URL part", 0);
        }
        return new PlainObject(base64URLArray[0], base64URLArray[1]);
    }
}

