/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.jose_8_2_1;

import java.io.Serializable;
import java.text.ParseException;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWSObject;
import macromedia.externals.com.nimbusds.jose_8_2_1.Payload;
import macromedia.externals.com.nimbusds.jose_8_2_1.PayloadTransformer;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.Base64URL;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.JSONObjectUtils;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.StandardCharset;
import macromedia.externals.com.nimbusds.jwt_8_2_1.SignedJWT;
import macromedia.externals.net.minidev.json_1_3_1.JSONObject;
import net.jcip.annotations.Immutable;

/*
 * Exception performing whole class analysis ignored.
 */
@Immutable
public final class Payload
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Origin origin;
    private final JSONObject jsonObject;
    private final String string;
    private final byte[] bytes;
    private final Base64URL base64URL;
    private final JWSObject jwsObject;
    private final SignedJWT signedJWT;

    private static String byteArrayToString(byte[] byArray) {
        return byArray != null ? new String(byArray, StandardCharset.UTF_8) : null;
    }

    private static byte[] stringToByteArray(String string) {
        return string != null ? string.getBytes(StandardCharset.UTF_8) : null;
    }

    public Payload(JSONObject jSONObject) {
        if (jSONObject == null) {
            throw new IllegalArgumentException("The JSON object must not be null");
        }
        this.jsonObject = jSONObject;
        this.string = null;
        this.bytes = null;
        this.base64URL = null;
        this.jwsObject = null;
        this.signedJWT = null;
        this.origin = Origin.JSON;
    }

    public Payload(String string) {
        if (string == null) {
            throw new IllegalArgumentException("The string must not be null");
        }
        this.jsonObject = null;
        this.string = string;
        this.bytes = null;
        this.base64URL = null;
        this.jwsObject = null;
        this.signedJWT = null;
        this.origin = Origin.STRING;
    }

    public Payload(byte[] byArray) {
        if (byArray == null) {
            throw new IllegalArgumentException("The byte array must not be null");
        }
        this.jsonObject = null;
        this.string = null;
        this.bytes = byArray;
        this.base64URL = null;
        this.jwsObject = null;
        this.signedJWT = null;
        this.origin = Origin.BYTE_ARRAY;
    }

    public Payload(Base64URL base64URL) {
        if (base64URL == null) {
            throw new IllegalArgumentException("The Base64URL-encoded object must not be null");
        }
        this.jsonObject = null;
        this.string = null;
        this.bytes = null;
        this.base64URL = base64URL;
        this.jwsObject = null;
        this.signedJWT = null;
        this.origin = Origin.BASE64URL;
    }

    public Payload(JWSObject jWSObject) {
        if (jWSObject == null) {
            throw new IllegalArgumentException("The JWS object must not be null");
        }
        if (jWSObject.getState() == JWSObject.State.UNSIGNED) {
            throw new IllegalArgumentException("The JWS object must be signed");
        }
        this.jsonObject = null;
        this.string = null;
        this.bytes = null;
        this.base64URL = null;
        this.jwsObject = jWSObject;
        this.signedJWT = null;
        this.origin = Origin.JWS_OBJECT;
    }

    public Payload(SignedJWT signedJWT) {
        if (signedJWT == null) {
            throw new IllegalArgumentException("The signed JWT must not be null");
        }
        if (signedJWT.getState() == JWSObject.State.UNSIGNED) {
            throw new IllegalArgumentException("The JWT must be signed");
        }
        this.jsonObject = null;
        this.string = null;
        this.bytes = null;
        this.base64URL = null;
        this.signedJWT = signedJWT;
        this.jwsObject = signedJWT;
        this.origin = Origin.SIGNED_JWT;
    }

    public Origin getOrigin() {
        return this.origin;
    }

    public JSONObject toJSONObject() {
        if (this.jsonObject != null) {
            return this.jsonObject;
        }
        String string = this.toString();
        if (string == null) {
            return null;
        }
        try {
            return JSONObjectUtils.parse((String)string);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public String toString() {
        if (this.string != null) {
            return this.string;
        }
        if (this.jwsObject != null) {
            if (this.jwsObject.getParsedString() != null) {
                return this.jwsObject.getParsedString();
            }
            return this.jwsObject.serialize();
        }
        if (this.jsonObject != null) {
            return this.jsonObject.toString();
        }
        if (this.bytes != null) {
            return Payload.byteArrayToString((byte[])this.bytes);
        }
        if (this.base64URL != null) {
            return this.base64URL.decodeToString();
        }
        return null;
    }

    public byte[] toBytes() {
        if (this.bytes != null) {
            return this.bytes;
        }
        if (this.base64URL != null) {
            return this.base64URL.decode();
        }
        return Payload.stringToByteArray((String)this.toString());
    }

    public Base64URL toBase64URL() {
        if (this.base64URL != null) {
            return this.base64URL;
        }
        return Base64URL.encode((byte[])this.toBytes());
    }

    public JWSObject toJWSObject() {
        if (this.jwsObject != null) {
            return this.jwsObject;
        }
        try {
            return JWSObject.parse((String)this.toString());
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public SignedJWT toSignedJWT() {
        if (this.signedJWT != null) {
            return this.signedJWT;
        }
        try {
            return SignedJWT.parse((String)this.toString());
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public <T> T toType(PayloadTransformer<T> payloadTransformer) {
        return (T)payloadTransformer.transform(this);
    }
}

