/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.jose_8_2_1;

import macromedia.externals.com.nimbusds.jose_8_2_1.Algorithm;
import macromedia.externals.com.nimbusds.jose_8_2_1.Requirement;
import net.jcip.annotations.Immutable;

@Immutable
public final class JWSAlgorithm
extends Algorithm {
    private static final long serialVersionUID = 1L;
    public static final JWSAlgorithm HS256 = new JWSAlgorithm("HS256", Requirement.REQUIRED);
    public static final JWSAlgorithm HS384 = new JWSAlgorithm("HS384", Requirement.OPTIONAL);
    public static final JWSAlgorithm HS512 = new JWSAlgorithm("HS512", Requirement.OPTIONAL);
    public static final JWSAlgorithm RS256 = new JWSAlgorithm("RS256", Requirement.RECOMMENDED);
    public static final JWSAlgorithm RS384 = new JWSAlgorithm("RS384", Requirement.OPTIONAL);
    public static final JWSAlgorithm RS512 = new JWSAlgorithm("RS512", Requirement.OPTIONAL);
    public static final JWSAlgorithm ES256 = new JWSAlgorithm("ES256", Requirement.RECOMMENDED);
    public static final JWSAlgorithm ES256K = new JWSAlgorithm("ES256K", Requirement.OPTIONAL);
    public static final JWSAlgorithm ES384 = new JWSAlgorithm("ES384", Requirement.OPTIONAL);
    public static final JWSAlgorithm ES512 = new JWSAlgorithm("ES512", Requirement.OPTIONAL);
    public static final JWSAlgorithm PS256 = new JWSAlgorithm("PS256", Requirement.OPTIONAL);
    public static final JWSAlgorithm PS384 = new JWSAlgorithm("PS384", Requirement.OPTIONAL);
    public static final JWSAlgorithm PS512 = new JWSAlgorithm("PS512", Requirement.OPTIONAL);
    public static final JWSAlgorithm EdDSA = new JWSAlgorithm("EdDSA", Requirement.OPTIONAL);

    public JWSAlgorithm(String string, Requirement requirement) {
        super(string, requirement);
    }

    public JWSAlgorithm(String string) {
        super(string, null);
    }

    public static JWSAlgorithm parse(String string) {
        if (string.equals(HS256.getName())) {
            return HS256;
        }
        if (string.equals(HS384.getName())) {
            return HS384;
        }
        if (string.equals(HS512.getName())) {
            return HS512;
        }
        if (string.equals(RS256.getName())) {
            return RS256;
        }
        if (string.equals(RS384.getName())) {
            return RS384;
        }
        if (string.equals(RS512.getName())) {
            return RS512;
        }
        if (string.equals(ES256.getName())) {
            return ES256;
        }
        if (string.equals(ES256K.getName())) {
            return ES256K;
        }
        if (string.equals(ES384.getName())) {
            return ES384;
        }
        if (string.equals(ES512.getName())) {
            return ES512;
        }
        if (string.equals(PS256.getName())) {
            return PS256;
        }
        if (string.equals(PS384.getName())) {
            return PS384;
        }
        if (string.equals(PS512.getName())) {
            return PS512;
        }
        if (string.equals(EdDSA.getName())) {
            return EdDSA;
        }
        return new JWSAlgorithm(string);
    }
}

