/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.jose_8_2_1;

import java.text.ParseException;
import macromedia.externals.com.nimbusds.jose_8_2_1.JOSEException;
import macromedia.externals.com.nimbusds.jose_8_2_1.JOSEObject;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWECryptoParts;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWEDecrypter;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWEEncrypter;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWEHeader;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWEObject;
import macromedia.externals.com.nimbusds.jose_8_2_1.Payload;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.Base64URL;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class JWEObject
extends JOSEObject {
    private static final long serialVersionUID = 1L;
    private JWEHeader header;
    private Base64URL encryptedKey;
    private Base64URL iv;
    private Base64URL cipherText;
    private Base64URL authTag;
    private State state;

    public JWEObject(JWEHeader jWEHeader, Payload payload) {
        if (jWEHeader == null) {
            throw new IllegalArgumentException("The JWE header must not be null");
        }
        this.header = jWEHeader;
        if (payload == null) {
            throw new IllegalArgumentException("The payload must not be null");
        }
        this.setPayload(payload);
        this.encryptedKey = null;
        this.cipherText = null;
        this.state = State.UNENCRYPTED;
    }

    public JWEObject(Base64URL base64URL, Base64URL base64URL2, Base64URL base64URL3, Base64URL base64URL4, Base64URL base64URL5) throws ParseException {
        if (base64URL == null) {
            throw new IllegalArgumentException("The first part must not be null");
        }
        try {
            this.header = JWEHeader.parse((Base64URL)base64URL);
        }
        catch (ParseException parseException) {
            throw new ParseException("Invalid JWE header: " + parseException.getMessage(), 0);
        }
        this.encryptedKey = base64URL2 == null || base64URL2.toString().isEmpty() ? null : base64URL2;
        this.iv = base64URL3 == null || base64URL3.toString().isEmpty() ? null : base64URL3;
        if (base64URL4 == null) {
            throw new IllegalArgumentException("The fourth part must not be null");
        }
        this.cipherText = base64URL4;
        this.authTag = base64URL5 == null || base64URL5.toString().isEmpty() ? null : base64URL5;
        this.state = State.ENCRYPTED;
        this.setParsedParts(new Base64URL[]{base64URL, base64URL2, base64URL3, base64URL4, base64URL5});
    }

    public JWEHeader getHeader() {
        return this.header;
    }

    public Base64URL getEncryptedKey() {
        return this.encryptedKey;
    }

    public Base64URL getIV() {
        return this.iv;
    }

    public Base64URL getCipherText() {
        return this.cipherText;
    }

    public Base64URL getAuthTag() {
        return this.authTag;
    }

    public State getState() {
        return this.state;
    }

    private void ensureUnencryptedState() {
        if (this.state != State.UNENCRYPTED) {
            throw new IllegalStateException("The JWE object must be in an unencrypted state");
        }
    }

    private void ensureEncryptedState() {
        if (this.state != State.ENCRYPTED) {
            throw new IllegalStateException("The JWE object must be in an encrypted state");
        }
    }

    private void ensureEncryptedOrDecryptedState() {
        if (this.state != State.ENCRYPTED && this.state != State.DECRYPTED) {
            throw new IllegalStateException("The JWE object must be in an encrypted or decrypted state");
        }
    }

    private void ensureJWEEncrypterSupport(JWEEncrypter jWEEncrypter) throws JOSEException {
        if (!jWEEncrypter.supportedJWEAlgorithms().contains(this.getHeader().getAlgorithm())) {
            throw new JOSEException("The \"" + this.getHeader().getAlgorithm() + "\" algorithm is not supported by the JWE encrypter: Supported algorithms: " + jWEEncrypter.supportedJWEAlgorithms());
        }
        if (!jWEEncrypter.supportedEncryptionMethods().contains(this.getHeader().getEncryptionMethod())) {
            throw new JOSEException("The \"" + this.getHeader().getEncryptionMethod() + "\" encryption method or key size is not supported by the JWE encrypter: Supported methods: " + jWEEncrypter.supportedEncryptionMethods());
        }
    }

    public synchronized void encrypt(JWEEncrypter jWEEncrypter) throws JOSEException {
        JWECryptoParts jWECryptoParts;
        this.ensureUnencryptedState();
        this.ensureJWEEncrypterSupport(jWEEncrypter);
        try {
            jWECryptoParts = jWEEncrypter.encrypt(this.getHeader(), this.getPayload().toBytes());
        }
        catch (JOSEException jOSEException) {
            throw jOSEException;
        }
        catch (Exception exception) {
            throw new JOSEException(exception.getMessage(), (Throwable)exception);
        }
        if (jWECryptoParts.getHeader() != null) {
            this.header = jWECryptoParts.getHeader();
        }
        this.encryptedKey = jWECryptoParts.getEncryptedKey();
        this.iv = jWECryptoParts.getInitializationVector();
        this.cipherText = jWECryptoParts.getCipherText();
        this.authTag = jWECryptoParts.getAuthenticationTag();
        this.state = State.ENCRYPTED;
    }

    public synchronized void decrypt(JWEDecrypter jWEDecrypter) throws JOSEException {
        this.ensureEncryptedState();
        try {
            this.setPayload(new Payload(jWEDecrypter.decrypt(this.getHeader(), this.getEncryptedKey(), this.getIV(), this.getCipherText(), this.getAuthTag())));
        }
        catch (JOSEException jOSEException) {
            throw jOSEException;
        }
        catch (Exception exception) {
            throw new JOSEException(exception.getMessage(), (Throwable)exception);
        }
        this.state = State.DECRYPTED;
    }

    public String serialize() {
        this.ensureEncryptedOrDecryptedState();
        StringBuilder stringBuilder = new StringBuilder(this.header.toBase64URL().toString());
        stringBuilder.append('.');
        if (this.encryptedKey != null) {
            stringBuilder.append(this.encryptedKey.toString());
        }
        stringBuilder.append('.');
        if (this.iv != null) {
            stringBuilder.append(this.iv.toString());
        }
        stringBuilder.append('.');
        stringBuilder.append(this.cipherText.toString());
        stringBuilder.append('.');
        if (this.authTag != null) {
            stringBuilder.append(this.authTag.toString());
        }
        return stringBuilder.toString();
    }

    public static JWEObject parse(String string) throws ParseException {
        Base64URL[] base64URLArray = JOSEObject.split((String)string);
        if (base64URLArray.length != 5) {
            throw new ParseException("Unexpected number of Base64URL parts, must be five", 0);
        }
        return new JWEObject(base64URLArray[0], base64URLArray[1], base64URLArray[2], base64URLArray[3], base64URLArray[4]);
    }
}

