/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.jose_8_2_1;

import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import macromedia.externals.com.nimbusds.jose_8_2_1.Algorithm;
import macromedia.externals.com.nimbusds.jose_8_2_1.JOSEObjectType;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWEAlgorithm;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWEHeader;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWSAlgorithm;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWSHeader;
import macromedia.externals.com.nimbusds.jose_8_2_1.PlainHeader;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.Base64URL;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.JSONObjectUtils;
import macromedia.externals.net.minidev.json_1_3_1.JSONObject;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class Header
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Algorithm alg;
    private final JOSEObjectType typ;
    private final String cty;
    private final Set<String> crit;
    private final Map<String, Object> customParams;
    private static final Map<String, Object> EMPTY_CUSTOM_PARAMS = Collections.unmodifiableMap(new HashMap());
    private final Base64URL parsedBase64URL;

    protected Header(Algorithm algorithm, JOSEObjectType jOSEObjectType, String string, Set<String> set, Map<String, Object> map, Base64URL base64URL) {
        if (algorithm == null) {
            throw new IllegalArgumentException("The algorithm \"alg\" header parameter must not be null");
        }
        this.alg = algorithm;
        this.typ = jOSEObjectType;
        this.cty = string;
        this.crit = set != null ? Collections.unmodifiableSet(new HashSet<String>(set)) : null;
        this.customParams = map != null ? Collections.unmodifiableMap(new HashMap<String, Object>(map)) : EMPTY_CUSTOM_PARAMS;
        this.parsedBase64URL = base64URL;
    }

    protected Header(Header header) {
        this(header.getAlgorithm(), header.getType(), header.getContentType(), header.getCriticalParams(), header.getCustomParams(), header.getParsedBase64URL());
    }

    public Algorithm getAlgorithm() {
        return this.alg;
    }

    public JOSEObjectType getType() {
        return this.typ;
    }

    public String getContentType() {
        return this.cty;
    }

    public Set<String> getCriticalParams() {
        return this.crit;
    }

    public Object getCustomParam(String string) {
        return this.customParams.get(string);
    }

    public Map<String, Object> getCustomParams() {
        return this.customParams;
    }

    public Base64URL getParsedBase64URL() {
        return this.parsedBase64URL;
    }

    public Set<String> getIncludedParams() {
        HashSet<String> hashSet = new HashSet<String>(this.getCustomParams().keySet());
        hashSet.add("alg");
        if (this.getType() != null) {
            hashSet.add("typ");
        }
        if (this.getContentType() != null) {
            hashSet.add("cty");
        }
        if (this.getCriticalParams() != null && !this.getCriticalParams().isEmpty()) {
            hashSet.add("crit");
        }
        return hashSet;
    }

    public JSONObject toJSONObject() {
        JSONObject jSONObject = new JSONObject(this.customParams);
        jSONObject.put((Object)"alg", (Object)this.alg.toString());
        if (this.typ != null) {
            jSONObject.put((Object)"typ", (Object)this.typ.toString());
        }
        if (this.cty != null) {
            jSONObject.put((Object)"cty", (Object)this.cty);
        }
        if (this.crit != null && !this.crit.isEmpty()) {
            jSONObject.put((Object)"crit", new ArrayList(this.crit));
        }
        return jSONObject;
    }

    public String toString() {
        return this.toJSONObject().toString();
    }

    public Base64URL toBase64URL() {
        if (this.parsedBase64URL == null) {
            return Base64URL.encode((String)this.toString());
        }
        return this.parsedBase64URL;
    }

    public static Algorithm parseAlgorithm(JSONObject jSONObject) throws ParseException {
        String string = JSONObjectUtils.getString((JSONObject)jSONObject, (String)"alg");
        if (string == null) {
            throw new ParseException("Missing \"alg\" in header JSON object", 0);
        }
        if (string.equals(Algorithm.NONE.getName())) {
            return Algorithm.NONE;
        }
        if (jSONObject.containsKey((Object)"enc")) {
            return JWEAlgorithm.parse((String)string);
        }
        return JWSAlgorithm.parse((String)string);
    }

    public static Header parse(JSONObject jSONObject) throws ParseException {
        return Header.parse((JSONObject)jSONObject, null);
    }

    public static Header parse(JSONObject jSONObject, Base64URL base64URL) throws ParseException {
        Algorithm algorithm = Header.parseAlgorithm((JSONObject)jSONObject);
        if (algorithm.equals((Object)Algorithm.NONE)) {
            return PlainHeader.parse((JSONObject)jSONObject, (Base64URL)base64URL);
        }
        if (algorithm instanceof JWSAlgorithm) {
            return JWSHeader.parse((JSONObject)jSONObject, (Base64URL)base64URL);
        }
        if (algorithm instanceof JWEAlgorithm) {
            return JWEHeader.parse((JSONObject)jSONObject, (Base64URL)base64URL);
        }
        throw new AssertionError((Object)("Unexpected algorithm type: " + algorithm));
    }

    public static Header parse(String string) throws ParseException {
        return Header.parse((String)string, null);
    }

    public static Header parse(String string, Base64URL base64URL) throws ParseException {
        JSONObject jSONObject = JSONObjectUtils.parse((String)string);
        return Header.parse((JSONObject)jSONObject, (Base64URL)base64URL);
    }

    public static Header parse(Base64URL base64URL) throws ParseException {
        return Header.parse((String)base64URL.decodeToString(), (Base64URL)base64URL);
    }
}

