/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.jose_8_2_1;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import macromedia.externals.com.nimbusds.jose_8_2_1.Algorithm;
import macromedia.externals.com.nimbusds.jose_8_2_1.Header;
import macromedia.externals.com.nimbusds.jose_8_2_1.JOSEObjectType;
import macromedia.externals.com.nimbusds.jose_8_2_1.jwk.JWK;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.Base64;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.Base64URL;
import macromedia.externals.net.minidev.json_1_3_1.JSONObject;

abstract class CommonSEHeader
extends Header {
    private static final long serialVersionUID = 1L;
    private final URI jku;
    private final JWK jwk;
    private final URI x5u;
    private final Base64URL x5t;
    private final Base64URL x5t256;
    private final List<Base64> x5c;
    private final String kid;

    protected CommonSEHeader(Algorithm algorithm, JOSEObjectType jOSEObjectType, String string, Set<String> set, URI uRI, JWK jWK, URI uRI2, Base64URL base64URL, Base64URL base64URL2, List<Base64> list, String string2, Map<String, Object> map, Base64URL base64URL3) {
        super(algorithm, jOSEObjectType, string, set, map, base64URL3);
        this.jku = uRI;
        this.jwk = jWK;
        this.x5u = uRI2;
        this.x5t = base64URL;
        this.x5t256 = base64URL2;
        this.x5c = list != null ? Collections.unmodifiableList(new ArrayList<Base64>(list)) : null;
        this.kid = string2;
    }

    public URI getJWKURL() {
        return this.jku;
    }

    public JWK getJWK() {
        return this.jwk;
    }

    public URI getX509CertURL() {
        return this.x5u;
    }

    @Deprecated
    public Base64URL getX509CertThumbprint() {
        return this.x5t;
    }

    public Base64URL getX509CertSHA256Thumbprint() {
        return this.x5t256;
    }

    public List<Base64> getX509CertChain() {
        return this.x5c;
    }

    public String getKeyID() {
        return this.kid;
    }

    public Set<String> getIncludedParams() {
        Set set = super.getIncludedParams();
        if (this.jku != null) {
            set.add("jku");
        }
        if (this.jwk != null) {
            set.add("jwk");
        }
        if (this.x5u != null) {
            set.add("x5u");
        }
        if (this.x5t != null) {
            set.add("x5t");
        }
        if (this.x5t256 != null) {
            set.add("x5t#S256");
        }
        if (this.x5c != null && !this.x5c.isEmpty()) {
            set.add("x5c");
        }
        if (this.kid != null) {
            set.add("kid");
        }
        return set;
    }

    public JSONObject toJSONObject() {
        JSONObject jSONObject = super.toJSONObject();
        if (this.jku != null) {
            jSONObject.put((Object)"jku", (Object)this.jku.toString());
        }
        if (this.jwk != null) {
            jSONObject.put((Object)"jwk", (Object)this.jwk.toJSONObject());
        }
        if (this.x5u != null) {
            jSONObject.put((Object)"x5u", (Object)this.x5u.toString());
        }
        if (this.x5t != null) {
            jSONObject.put((Object)"x5t", (Object)this.x5t.toString());
        }
        if (this.x5t256 != null) {
            jSONObject.put((Object)"x5t#S256", (Object)this.x5t256.toString());
        }
        if (this.x5c != null && !this.x5c.isEmpty()) {
            jSONObject.put((Object)"x5c", (Object)this.x5c);
        }
        if (this.kid != null) {
            jSONObject.put((Object)"kid", (Object)this.kid);
        }
        return jSONObject;
    }
}

