/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.microsoft.aad_1_3_0.adal4j;

import java.io.Serializable;
import java.util.Date;
import java.util.Objects;
import macromedia.externals.com.microsoft.aad_1_3_0.adal4j.UserInfo;

public final class AuthenticationResult
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String accessTokenType;
    private final long expiresIn;
    private final Date expiresOn;
    private final String idToken;
    private final UserInfo userInfo;
    private final String accessToken;
    private final String refreshToken;
    private final boolean isMultipleResourceRefreshToken;

    public AuthenticationResult(String string, String string2, String string3, long l2, String string4, UserInfo userInfo, boolean bl2) {
        this.accessTokenType = string;
        this.accessToken = string2;
        this.refreshToken = string3;
        this.expiresIn = l2;
        Date date = new Date();
        date.setTime(date.getTime() + l2 * 1000L);
        this.expiresOn = date;
        this.idToken = string4;
        this.userInfo = userInfo;
        this.isMultipleResourceRefreshToken = bl2;
    }

    public String getAccessTokenType() {
        return this.accessTokenType;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    @Deprecated
    public long getExpiresOn() {
        return this.expiresIn;
    }

    public long getExpiresAfter() {
        return this.expiresIn;
    }

    public Date getExpiresOnDate() {
        if (this.expiresOn != null) {
            return (Date)this.expiresOn.clone();
        }
        return null;
    }

    public String getIdToken() {
        return this.idToken;
    }

    public UserInfo getUserInfo() {
        return this.userInfo;
    }

    public boolean isMultipleResourceRefreshToken() {
        return this.isMultipleResourceRefreshToken;
    }

    public int hashCode() {
        int n2 = 3;
        n2 = 41 * n2 + Objects.hashCode(this.accessTokenType);
        n2 = 41 * n2 + (int)(this.expiresIn ^ this.expiresIn >>> 32);
        n2 = 41 * n2 + Objects.hashCode(this.expiresOn);
        n2 = 41 * n2 + Objects.hashCode(this.idToken);
        n2 = 41 * n2 + Objects.hashCode(this.userInfo);
        n2 = 41 * n2 + Objects.hashCode(this.accessToken);
        n2 = 41 * n2 + Objects.hashCode(this.refreshToken);
        n2 = 41 * n2 + (this.isMultipleResourceRefreshToken ? 1 : 0);
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        AuthenticationResult authenticationResult = (AuthenticationResult)object;
        if (this.expiresIn != authenticationResult.expiresIn) {
            return false;
        }
        if (this.isMultipleResourceRefreshToken != authenticationResult.isMultipleResourceRefreshToken) {
            return false;
        }
        if (!Objects.equals(this.accessTokenType, authenticationResult.accessTokenType)) {
            return false;
        }
        if (!Objects.equals(this.idToken, authenticationResult.idToken)) {
            return false;
        }
        if (!Objects.equals(this.accessToken, authenticationResult.accessToken)) {
            return false;
        }
        if (!Objects.equals(this.refreshToken, authenticationResult.refreshToken)) {
            return false;
        }
        if (!Objects.equals(this.expiresOn, authenticationResult.expiresOn)) {
            return false;
        }
        return Objects.equals(this.userInfo, authenticationResult.userInfo);
    }
}

