/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.microsoft.aad_1_3_0.adal4j;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URI;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.net.ssl.SSLSocketFactory;
import macromedia.externals.com.microsoft.aad_1_3_0.adal4j.AdalAuthorizatonGrant;
import macromedia.externals.com.microsoft.aad_1_3_0.adal4j.AdalTokenRequest;
import macromedia.externals.com.microsoft.aad_1_3_0.adal4j.AsymmetricKeyCredential;
import macromedia.externals.com.microsoft.aad_1_3_0.adal4j.AuthenticationAuthority;
import macromedia.externals.com.microsoft.aad_1_3_0.adal4j.AuthenticationCallback;
import macromedia.externals.com.microsoft.aad_1_3_0.adal4j.AuthenticationContext;
import macromedia.externals.com.microsoft.aad_1_3_0.adal4j.AuthenticationException;
import macromedia.externals.com.microsoft.aad_1_3_0.adal4j.AuthenticationResult;
import macromedia.externals.com.microsoft.aad_1_3_0.adal4j.ClientAssertion;
import macromedia.externals.com.microsoft.aad_1_3_0.adal4j.ClientAuthenticationPost;
import macromedia.externals.com.microsoft.aad_1_3_0.adal4j.ClientCredential;
import macromedia.externals.com.microsoft.aad_1_3_0.adal4j.ClientDataHttpHeaders;
import macromedia.externals.com.microsoft.aad_1_3_0.adal4j.JwtHelper;
import macromedia.externals.com.microsoft.aad_1_3_0.adal4j.LogHelper;
import macromedia.externals.com.microsoft.aad_1_3_0.adal4j.SAML11BearerGrant;
import macromedia.externals.com.microsoft.aad_1_3_0.adal4j.StringHelper;
import macromedia.externals.com.microsoft.aad_1_3_0.adal4j.UserAssertion;
import macromedia.externals.com.microsoft.aad_1_3_0.adal4j.UserDiscoveryRequest;
import macromedia.externals.com.microsoft.aad_1_3_0.adal4j.UserDiscoveryResponse;
import macromedia.externals.com.microsoft.aad_1_3_0.adal4j.WSTrustRequest;
import macromedia.externals.com.microsoft.aad_1_3_0.adal4j.WSTrustResponse;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.Base64URL;
import macromedia.externals.com.nimbusds.jwt_8_2_1.SignedJWT;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.AuthorizationCode;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.AuthorizationCodeGrant;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.AuthorizationGrant;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.ClientCredentialsGrant;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.JWTBearerGrant;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.ParseException;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.RefreshTokenGrant;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.ResourceOwnerPasswordCredentialsGrant;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.SAML2BearerGrant;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.auth.ClientAuthentication;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.auth.ClientAuthenticationMethod;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.auth.ClientSecretPost;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.auth.PrivateKeyJWT;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.auth.Secret;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.id.ClientID;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.token.RefreshToken;
import macromedia.externals.org.apache.commons_1_10.codec.binary.Base64;
import macromedia.externals.org.slf4j_1_7_5.Logger;
import macromedia.externals.org.slf4j_1_7_5.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class AuthenticationContext {
    private final Logger log = LoggerFactory.getLogger(AuthenticationContext.class);
    private final AuthenticationAuthority authenticationAuthority;
    private String correlationId;
    private String authority;
    private final ExecutorService service;
    private final boolean validateAuthority;
    private Proxy proxy;
    private SSLSocketFactory sslSocketFactory;

    public AuthenticationContext(String string, boolean bl2, ExecutorService executorService) throws MalformedURLException {
        if (StringHelper.isBlank((String)string)) {
            throw new IllegalArgumentException("authority is null or empty");
        }
        if (executorService == null) {
            throw new IllegalArgumentException("service is null");
        }
        this.service = executorService;
        this.validateAuthority = bl2;
        this.authority = this.canonicalizeUri(string);
        this.authenticationAuthority = new AuthenticationAuthority(new URL(this.getAuthority()), this.shouldValidateAuthority());
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    public SSLSocketFactory getSslSocketFactory() {
        return this.sslSocketFactory;
    }

    public void setSslSocketFactory(SSLSocketFactory sSLSocketFactory) {
        this.sslSocketFactory = sSLSocketFactory;
    }

    private String canonicalizeUri(String string) {
        if (!string.endsWith("/")) {
            string = string + "/";
        }
        return string;
    }

    private Future<AuthenticationResult> acquireToken(AdalAuthorizatonGrant adalAuthorizatonGrant, ClientAuthentication clientAuthentication, AuthenticationCallback authenticationCallback) {
        return this.service.submit(1.access$400(new /* Unavailable Anonymous Inner Class!! */, (AdalAuthorizatonGrant)adalAuthorizatonGrant, (ClientAuthentication)clientAuthentication, (ClientDataHttpHeaders)new ClientDataHttpHeaders(this.getCorrelationId())));
    }

    public Future<AuthenticationResult> acquireToken(String string, String string2, String string3, String string4, AuthenticationCallback authenticationCallback) {
        if (StringHelper.isBlank((String)string)) {
            throw new IllegalArgumentException("resource is null or empty");
        }
        if (StringHelper.isBlank((String)string2)) {
            throw new IllegalArgumentException("clientId is null or empty");
        }
        if (StringHelper.isBlank((String)string3)) {
            throw new IllegalArgumentException("username is null or empty");
        }
        if (StringHelper.isBlank((String)string4)) {
            throw new IllegalArgumentException("password is null or empty");
        }
        return this.acquireToken(new AdalAuthorizatonGrant((AuthorizationGrant)new ResourceOwnerPasswordCredentialsGrant(string3, new Secret(string4)), string), (ClientAuthentication)new ClientAuthenticationPost(ClientAuthenticationMethod.NONE, new ClientID(string2)), authenticationCallback);
    }

    public Future<AuthenticationResult> acquireToken(String string, ClientAssertion clientAssertion, AuthenticationCallback authenticationCallback) {
        this.validateInput(string, (Object)clientAssertion, true);
        ClientAuthentication clientAuthentication = this.createClientAuthFromClientAssertion(clientAssertion);
        AdalAuthorizatonGrant adalAuthorizatonGrant = new AdalAuthorizatonGrant((AuthorizationGrant)new ClientCredentialsGrant(), string);
        return this.acquireToken(adalAuthorizatonGrant, clientAuthentication, authenticationCallback);
    }

    private void validateInput(String string, Object object, boolean bl2) {
        if (bl2 && StringHelper.isBlank((String)string)) {
            throw new IllegalArgumentException("resource is null or empty");
        }
        if (object == null) {
            throw new IllegalArgumentException("credential is null");
        }
    }

    public Future<AuthenticationResult> acquireToken(String string, UserAssertion userAssertion, ClientCredential clientCredential, AuthenticationCallback authenticationCallback) {
        this.validateInput(string, (Object)clientCredential, true);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("resource", string);
        hashMap.put("requested_token_use", "on_behalf_of");
        try {
            AdalAuthorizatonGrant adalAuthorizatonGrant = new AdalAuthorizatonGrant((AuthorizationGrant)new JWTBearerGrant(SignedJWT.parse((String)userAssertion.getAssertion())), hashMap);
            ClientSecretPost clientSecretPost = new ClientSecretPost(new ClientID(clientCredential.getClientId()), new Secret(clientCredential.getClientSecret()));
            return this.acquireToken(adalAuthorizatonGrant, (ClientAuthentication)clientSecretPost, authenticationCallback);
        }
        catch (Exception exception) {
            throw new AuthenticationException((Throwable)exception);
        }
    }

    public Future<AuthenticationResult> acquireToken(String string, ClientCredential clientCredential, AuthenticationCallback authenticationCallback) {
        this.validateInput(string, (Object)clientCredential, true);
        ClientSecretPost clientSecretPost = new ClientSecretPost(new ClientID(clientCredential.getClientId()), new Secret(clientCredential.getClientSecret()));
        AdalAuthorizatonGrant adalAuthorizatonGrant = new AdalAuthorizatonGrant((AuthorizationGrant)new ClientCredentialsGrant(), string);
        return this.acquireToken(adalAuthorizatonGrant, (ClientAuthentication)clientSecretPost, authenticationCallback);
    }

    public Future<AuthenticationResult> acquireToken(String string, AsymmetricKeyCredential asymmetricKeyCredential, AuthenticationCallback authenticationCallback) throws AuthenticationException {
        return this.acquireToken(string, JwtHelper.buildJwt((AsymmetricKeyCredential)asymmetricKeyCredential, (String)this.authenticationAuthority.getSelfSignedJwtAudience()), authenticationCallback);
    }

    public Future<AuthenticationResult> acquireTokenByAuthorizationCode(String string, String string2, String string3, URI uRI, AuthenticationCallback authenticationCallback) {
        ClientAuthenticationPost clientAuthenticationPost = new ClientAuthenticationPost(ClientAuthenticationMethod.NONE, new ClientID(string3));
        this.validateAuthCodeRequestInput(string, uRI, (Object)clientAuthenticationPost, string2);
        AdalAuthorizatonGrant adalAuthorizatonGrant = new AdalAuthorizatonGrant((AuthorizationGrant)new AuthorizationCodeGrant(new AuthorizationCode(string), uRI), string2);
        return this.acquireToken(adalAuthorizatonGrant, (ClientAuthentication)clientAuthenticationPost, authenticationCallback);
    }

    public Future<AuthenticationResult> acquireTokenByAuthorizationCode(String string, URI uRI, ClientAssertion clientAssertion, AuthenticationCallback authenticationCallback) {
        return this.acquireTokenByAuthorizationCode(string, uRI, clientAssertion, (String)null, authenticationCallback);
    }

    public Future<AuthenticationResult> acquireTokenByAuthorizationCode(String string, URI uRI, ClientAssertion clientAssertion, String string2, AuthenticationCallback authenticationCallback) {
        this.validateAuthCodeRequestInput(string, uRI, (Object)clientAssertion, string2);
        ClientAuthentication clientAuthentication = this.createClientAuthFromClientAssertion(clientAssertion);
        AdalAuthorizatonGrant adalAuthorizatonGrant = new AdalAuthorizatonGrant((AuthorizationGrant)new AuthorizationCodeGrant(new AuthorizationCode(string), uRI), string2);
        return this.acquireToken(adalAuthorizatonGrant, clientAuthentication, authenticationCallback);
    }

    public Future<AuthenticationResult> acquireTokenByAuthorizationCode(String string, URI uRI, ClientCredential clientCredential, AuthenticationCallback authenticationCallback) {
        this.validateAuthCodeRequestInput(string, uRI, (Object)clientCredential, null);
        return this.acquireTokenByAuthorizationCode(string, uRI, clientCredential, null, authenticationCallback);
    }

    public Future<AuthenticationResult> acquireTokenByAuthorizationCode(String string, URI uRI, ClientCredential clientCredential, String string2, AuthenticationCallback authenticationCallback) {
        this.validateAuthCodeRequestInput(string, uRI, (Object)clientCredential, string2);
        ClientSecretPost clientSecretPost = new ClientSecretPost(new ClientID(clientCredential.getClientId()), new Secret(clientCredential.getClientSecret()));
        AdalAuthorizatonGrant adalAuthorizatonGrant = new AdalAuthorizatonGrant((AuthorizationGrant)new AuthorizationCodeGrant(new AuthorizationCode(string), uRI), string2);
        return this.acquireToken(adalAuthorizatonGrant, (ClientAuthentication)clientSecretPost, authenticationCallback);
    }

    public Future<AuthenticationResult> acquireTokenByAuthorizationCode(String string, URI uRI, AsymmetricKeyCredential asymmetricKeyCredential, AuthenticationCallback authenticationCallback) throws AuthenticationException {
        return this.acquireTokenByAuthorizationCode(string, uRI, asymmetricKeyCredential, null, authenticationCallback);
    }

    public Future<AuthenticationResult> acquireTokenByAuthorizationCode(String string, URI uRI, AsymmetricKeyCredential asymmetricKeyCredential, String string2, AuthenticationCallback authenticationCallback) throws AuthenticationException {
        this.validateAuthCodeRequestInput(string, uRI, (Object)asymmetricKeyCredential, string2);
        return this.acquireTokenByAuthorizationCode(string, uRI, JwtHelper.buildJwt((AsymmetricKeyCredential)asymmetricKeyCredential, (String)this.authenticationAuthority.getSelfSignedJwtAudience()), string2, authenticationCallback);
    }

    public Future<AuthenticationResult> acquireTokenByRefreshToken(String string, String string2, ClientAssertion clientAssertion, AuthenticationCallback authenticationCallback) {
        return this.acquireTokenByRefreshToken(string, string2, clientAssertion, null, authenticationCallback);
    }

    public Future<AuthenticationResult> acquireTokenByRefreshToken(String string, String string2, ClientAssertion clientAssertion, String string3, AuthenticationCallback authenticationCallback) {
        this.validateRefreshTokenRequestInput(string, string2, (Object)clientAssertion);
        ClientAuthentication clientAuthentication = this.createClientAuthFromClientAssertion(clientAssertion);
        AdalAuthorizatonGrant adalAuthorizatonGrant = new AdalAuthorizatonGrant((AuthorizationGrant)new RefreshTokenGrant(new RefreshToken(string)), string3);
        return this.acquireToken(adalAuthorizatonGrant, clientAuthentication, authenticationCallback);
    }

    public Future<AuthenticationResult> acquireTokenByRefreshToken(String string, ClientCredential clientCredential, AuthenticationCallback authenticationCallback) {
        return this.acquireTokenByRefreshToken(string, clientCredential, (String)null, authenticationCallback);
    }

    public Future<AuthenticationResult> acquireTokenByRefreshToken(String string, ClientCredential clientCredential, String string2, AuthenticationCallback authenticationCallback) {
        ClientSecretPost clientSecretPost = new ClientSecretPost(new ClientID(clientCredential.getClientId()), new Secret(clientCredential.getClientSecret()));
        AdalAuthorizatonGrant adalAuthorizatonGrant = new AdalAuthorizatonGrant((AuthorizationGrant)new RefreshTokenGrant(new RefreshToken(string)), string2);
        return this.acquireToken(adalAuthorizatonGrant, (ClientAuthentication)clientSecretPost, authenticationCallback);
    }

    public Future<AuthenticationResult> acquireTokenByRefreshToken(String string, AsymmetricKeyCredential asymmetricKeyCredential, AuthenticationCallback authenticationCallback) throws AuthenticationException {
        return this.acquireTokenByRefreshToken(string, asymmetricKeyCredential, (String)null, authenticationCallback);
    }

    public Future<AuthenticationResult> acquireTokenByRefreshToken(String string, AsymmetricKeyCredential asymmetricKeyCredential, String string2, AuthenticationCallback authenticationCallback) throws AuthenticationException {
        return this.acquireTokenByRefreshToken(string, asymmetricKeyCredential.getClientId(), JwtHelper.buildJwt((AsymmetricKeyCredential)asymmetricKeyCredential, (String)this.authenticationAuthority.getSelfSignedJwtAudience()), (String)null, authenticationCallback);
    }

    public Future<AuthenticationResult> acquireTokenByRefreshToken(String string, String string2, AuthenticationCallback authenticationCallback) {
        return this.acquireTokenByRefreshToken(string, string2, (String)null, authenticationCallback);
    }

    public Future<AuthenticationResult> acquireTokenByRefreshToken(String string, String string2, String string3, AuthenticationCallback authenticationCallback) {
        ClientAuthenticationPost clientAuthenticationPost = new ClientAuthenticationPost(ClientAuthenticationMethod.NONE, new ClientID(string2));
        AdalAuthorizatonGrant adalAuthorizatonGrant = new AdalAuthorizatonGrant((AuthorizationGrant)new RefreshTokenGrant(new RefreshToken(string)), string3);
        return this.acquireToken(adalAuthorizatonGrant, (ClientAuthentication)clientAuthenticationPost, authenticationCallback);
    }

    private void validateRefreshTokenRequestInput(String string, String string2, Object object) {
        if (StringHelper.isBlank((String)string)) {
            throw new IllegalArgumentException("refreshToken is null or empty");
        }
        if (StringHelper.isBlank((String)string2)) {
            throw new IllegalArgumentException("clientId is null or empty");
        }
        this.validateInput(null, object, false);
    }

    private AuthenticationResult acquireTokenCommon(AdalAuthorizatonGrant adalAuthorizatonGrant, ClientAuthentication clientAuthentication, ClientDataHttpHeaders clientDataHttpHeaders) throws Exception {
        this.log.debug(LogHelper.createMessage((String)String.format("Using Client Http Headers: %s", clientDataHttpHeaders), (String)clientDataHttpHeaders.getHeaderCorrelationIdValue()));
        this.authenticationAuthority.doInstanceDiscovery(clientDataHttpHeaders.getReadonlyHeaderMap(), this.proxy, this.sslSocketFactory);
        URL uRL = new URL(this.authenticationAuthority.getTokenUri());
        AdalTokenRequest adalTokenRequest = new AdalTokenRequest(uRL, clientAuthentication, adalAuthorizatonGrant, clientDataHttpHeaders.getReadonlyHeaderMap(), this.proxy, this.sslSocketFactory);
        AuthenticationResult authenticationResult = adalTokenRequest.executeOAuthRequestAndProcessResponse();
        return authenticationResult;
    }

    private AdalAuthorizatonGrant processPasswordGrant(AdalAuthorizatonGrant adalAuthorizatonGrant) throws Exception {
        if (!(adalAuthorizatonGrant.getAuthorizationGrant() instanceof ResourceOwnerPasswordCredentialsGrant)) {
            return adalAuthorizatonGrant;
        }
        ResourceOwnerPasswordCredentialsGrant resourceOwnerPasswordCredentialsGrant = (ResourceOwnerPasswordCredentialsGrant)adalAuthorizatonGrant.getAuthorizationGrant();
        UserDiscoveryResponse userDiscoveryResponse = UserDiscoveryRequest.execute((String)this.authenticationAuthority.getUserRealmEndpoint(resourceOwnerPasswordCredentialsGrant.getUsername()), (Proxy)this.proxy, (SSLSocketFactory)this.sslSocketFactory);
        if (userDiscoveryResponse.isAccountFederated()) {
            WSTrustResponse wSTrustResponse = WSTrustRequest.execute((String)userDiscoveryResponse.getFederationMetadataUrl(), (String)resourceOwnerPasswordCredentialsGrant.getUsername(), (String)resourceOwnerPasswordCredentialsGrant.getPassword().getValue(), (String)userDiscoveryResponse.getCloudAudienceUrn(), (Proxy)this.proxy, (SSLSocketFactory)this.sslSocketFactory);
            Object object = null;
            object = wSTrustResponse.isTokenSaml2() ? new SAML2BearerGrant(new Base64URL(Base64.encodeBase64String((byte[])wSTrustResponse.getToken().getBytes("UTF-8")))) : new SAML11BearerGrant(new Base64URL(Base64.encodeBase64String((byte[])wSTrustResponse.getToken().getBytes())));
            adalAuthorizatonGrant = new AdalAuthorizatonGrant((AuthorizationGrant)object, adalAuthorizatonGrant.getCustomParameters());
        }
        return adalAuthorizatonGrant;
    }

    private void logResult(AuthenticationResult authenticationResult, ClientDataHttpHeaders clientDataHttpHeaders) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        if (!StringHelper.isBlank((String)authenticationResult.getAccessToken())) {
            String string = "";
            String string2 = this.computeSha256Hash(authenticationResult.getAccessToken());
            if (!StringHelper.isBlank((String)authenticationResult.getRefreshToken())) {
                String string3 = this.computeSha256Hash(authenticationResult.getRefreshToken());
                string = String.format("Access Token with hash '%s' and Refresh Token with hash '%s' returned", string2, string3);
            } else {
                string = String.format("Access Token with hash '%s' returned", string2);
            }
            this.log.debug(LogHelper.createMessage((String)string, (String)clientDataHttpHeaders.getHeaderCorrelationIdValue()));
        }
    }

    private String computeSha256Hash(String string) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
        messageDigest.update(string.getBytes("UTF-8"));
        byte[] byArray = messageDigest.digest();
        return Base64.encodeBase64URLSafeString((byte[])byArray);
    }

    private ClientAuthentication createClientAuthFromClientAssertion(ClientAssertion clientAssertion) {
        try {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("client_assertion_type", clientAssertion.getAssertionType());
            hashMap.put("client_assertion", clientAssertion.getAssertion());
            return PrivateKeyJWT.parse(hashMap);
        }
        catch (ParseException parseException) {
            throw new AuthenticationException((Throwable)parseException);
        }
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public void setCorrelationId(String string) {
        this.correlationId = string;
    }

    public boolean shouldValidateAuthority() {
        return this.validateAuthority;
    }

    public String getAuthority() {
        return this.authority;
    }

    private void validateAuthCodeRequestInput(String string, URI uRI, Object object, String string2) {
        if (StringHelper.isBlank((String)string)) {
            throw new IllegalArgumentException("authorization code is null or empty");
        }
        if (uRI == null) {
            throw new IllegalArgumentException("redirect uri is null");
        }
        this.validateInput(string2, object, false);
    }

    static /* synthetic */ AdalAuthorizatonGrant access$000(AuthenticationContext authenticationContext, AdalAuthorizatonGrant adalAuthorizatonGrant) throws Exception {
        return authenticationContext.processPasswordGrant(adalAuthorizatonGrant);
    }

    static /* synthetic */ AuthenticationResult access$100(AuthenticationContext authenticationContext, AdalAuthorizatonGrant adalAuthorizatonGrant, ClientAuthentication clientAuthentication, ClientDataHttpHeaders clientDataHttpHeaders) throws Exception {
        return authenticationContext.acquireTokenCommon(adalAuthorizatonGrant, clientAuthentication, clientDataHttpHeaders);
    }

    static /* synthetic */ void access$200(AuthenticationContext authenticationContext, AuthenticationResult authenticationResult, ClientDataHttpHeaders clientDataHttpHeaders) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        authenticationContext.logResult(authenticationResult, clientDataHttpHeaders);
    }

    static /* synthetic */ Logger access$300(AuthenticationContext authenticationContext) {
        return authenticationContext.log;
    }
}

