/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.microsoft.aad_1_3_0.adal4j;

import java.net.Proxy;
import java.net.URL;
import java.util.Arrays;
import java.util.Map;
import javax.net.ssl.SSLSocketFactory;
import macromedia.externals.com.microsoft.aad_1_3_0.adal4j.AuthenticationException;
import macromedia.externals.com.microsoft.aad_1_3_0.adal4j.AuthorityType;
import macromedia.externals.com.microsoft.aad_1_3_0.adal4j.HttpHelper;
import macromedia.externals.com.microsoft.aad_1_3_0.adal4j.InstanceDiscoveryResponse;
import macromedia.externals.com.microsoft.aad_1_3_0.adal4j.JsonHelper;
import macromedia.externals.com.microsoft.aad_1_3_0.adal4j.LogHelper;
import macromedia.externals.com.microsoft.aad_1_3_0.adal4j.StringHelper;
import macromedia.externals.org.slf4j_1_7_5.Logger;
import macromedia.externals.org.slf4j_1_7_5.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
class AuthenticationAuthority {
    private final Logger log = LoggerFactory.getLogger(AuthenticationAuthority.class);
    private static final String[] TRUSTED_HOST_LIST = new String[]{"login.windows.net", "login.chinacloudapi.cn", "login-us.microsoftonline.com", "login.microsoftonline.de", "login.microsoftonline.com", "login.microsoftonline.us"};
    private static final String TENANTLESS_TENANT_NAME = "common";
    private static final String AUTHORIZE_ENDPOINT_TEMPLATE = "https://{host}/{tenant}/oauth2/authorize";
    private static final String DISCOVERY_ENDPOINT = "common/discovery/instance";
    private static final String TOKEN_ENDPOINT = "/oauth2/token";
    private static final String USER_REALM_ENDPOINT = "common/userrealm";
    private String host;
    private String issuer;
    private final String instanceDiscoveryEndpointFormat = "https://%s/common/discovery/instance";
    private final String userRealmEndpointFormat = "https://%s/common/userrealm/%s?api-version=1.0";
    private final String tokenEndpointFormat = "https://%s/{tenant}/oauth2/token";
    private String authority = "https://%s/%s/";
    private String instanceDiscoveryEndpoint;
    private String tokenEndpoint;
    private final AuthorityType authorityType;
    private boolean isTenantless;
    private String tokenUri;
    private String selfSignedJwtAudience;
    private boolean instanceDiscoveryCompleted;
    private final URL authorityUrl;
    private final boolean validateAuthority;

    AuthenticationAuthority(URL uRL, boolean bl2) {
        this.authorityUrl = uRL;
        this.authorityType = this.detectAuthorityType();
        this.validateAuthority = bl2;
        this.validateAuthorityUrl();
        this.setupAuthorityProperties();
    }

    String getHost() {
        return this.host;
    }

    String getIssuer() {
        return this.issuer;
    }

    String getAuthority() {
        return this.authority;
    }

    String getTokenEndpoint() {
        return this.tokenEndpoint;
    }

    String getUserRealmEndpoint(String string) {
        return String.format("https://%s/common/userrealm/%s?api-version=1.0", this.host, string);
    }

    AuthorityType getAuthorityType() {
        return this.authorityType;
    }

    boolean isTenantless() {
        return this.isTenantless;
    }

    String getTokenUri() {
        return this.tokenUri;
    }

    String getSelfSignedJwtAudience() {
        return this.selfSignedJwtAudience;
    }

    void setSelfSignedJwtAudience(String string) {
        this.selfSignedJwtAudience = string;
    }

    void doInstanceDiscovery(Map<String, String> map, Proxy proxy, SSLSocketFactory sSLSocketFactory) throws Exception {
        if (!this.instanceDiscoveryCompleted) {
            if (!this.doStaticInstanceDiscovery() && this.validateAuthority && !this.doDynamicInstanceDiscovery(map, proxy, sSLSocketFactory)) {
                throw new AuthenticationException("'authority' is not in the list of valid addresses");
            }
            this.log.info(LogHelper.createMessage((String)"Instance discovery was successful", (String)map.get("client-request-id")));
            this.instanceDiscoveryCompleted = true;
        }
    }

    boolean doDynamicInstanceDiscovery(Map<String, String> map, Proxy proxy, SSLSocketFactory sSLSocketFactory) throws Exception {
        String string = HttpHelper.executeHttpGet((Logger)this.log, (String)this.instanceDiscoveryEndpoint, map, (Proxy)proxy, (SSLSocketFactory)sSLSocketFactory);
        InstanceDiscoveryResponse instanceDiscoveryResponse = (InstanceDiscoveryResponse)JsonHelper.convertJsonToObject((String)string, InstanceDiscoveryResponse.class);
        return !StringHelper.isBlank((String)instanceDiscoveryResponse.getTenantDiscoveryEndpoint());
    }

    boolean doStaticInstanceDiscovery() {
        if (this.validateAuthority) {
            return Arrays.asList(TRUSTED_HOST_LIST).contains(this.host);
        }
        return true;
    }

    void setupAuthorityProperties() {
        String string = this.authorityUrl.getAuthority().toLowerCase();
        String string2 = this.authorityUrl.getPath().substring(1).toLowerCase();
        String string3 = string2.substring(0, string2.indexOf("/")).toLowerCase();
        this.host = string;
        this.authority = String.format(this.authority, string, string3);
        this.getClass();
        this.instanceDiscoveryEndpoint = String.format("https://%s/common/discovery/instance", string);
        this.getClass();
        this.tokenEndpoint = String.format("https://%s/{tenant}/oauth2/token", string);
        this.issuer = this.tokenUri = (this.tokenEndpoint = this.tokenEndpoint.replace("{tenant}", string3));
        this.isTenantless = "common".equalsIgnoreCase(string3);
        this.setSelfSignedJwtAudience(this.getIssuer());
        this.createInstanceDiscoveryEndpoint(string3);
    }

    AuthorityType detectAuthorityType() {
        if (this.authorityUrl == null) {
            throw new NullPointerException("authority");
        }
        String string = this.authorityUrl.getPath().substring(1);
        if (StringHelper.isBlank((String)string)) {
            throw new IllegalArgumentException("'authority' Uri should have at least one segment in the path (i.e. https://<host>/<path>/...)");
        }
        String string2 = string.substring(0, string.indexOf("/"));
        AuthorityType authorityType = AuthenticationAuthority.isAdfsAuthority((String)string2) ? AuthorityType.ADFS : AuthorityType.AAD;
        return authorityType;
    }

    void validateAuthorityUrl() {
        if (this.authorityType != AuthorityType.AAD && this.validateAuthority) {
            throw new IllegalArgumentException("Authority validation is not supported for this type of authority");
        }
        if (!this.authorityUrl.getProtocol().equalsIgnoreCase("https")) {
            throw new IllegalArgumentException("'authority' should use the 'https' scheme");
        }
        if (this.authorityUrl.toString().contains("#")) {
            throw new IllegalArgumentException("authority is invalid format (contains fragment)");
        }
        if (!StringHelper.isBlank((String)this.authorityUrl.getQuery())) {
            throw new IllegalArgumentException("authority cannot contain query parameters");
        }
    }

    void createInstanceDiscoveryEndpoint(String string) {
        this.instanceDiscoveryEndpoint = this.instanceDiscoveryEndpoint + "?api-version=1.0&authorization_endpoint=https://{host}/{tenant}/oauth2/authorize";
        this.instanceDiscoveryEndpoint = this.instanceDiscoveryEndpoint.replace("{host}", this.host);
        this.instanceDiscoveryEndpoint = this.instanceDiscoveryEndpoint.replace("{tenant}", string);
    }

    static boolean isAdfsAuthority(String string) {
        return string.compareToIgnoreCase("adfs") == 0;
    }
}

