/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.microsoft.aad_1_3_0.adal4j;

import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.util.Enumeration;
import macromedia.externals.com.microsoft.aad_1_3_0.adal4j.StringHelper;
import macromedia.externals.org.apache.commons_1_10.codec.binary.Base64;
import sun.security.util.Length;

/*
 * Exception performing whole class analysis ignored.
 */
public final class AsymmetricKeyCredential {
    public static final int MIN_KEYSIZE_IN_BITS = 2048;
    private final String clientId;
    private final PrivateKey key;
    private final X509Certificate publicCertificate;

    private AsymmetricKeyCredential(String string, PrivateKey privateKey, X509Certificate x509Certificate) {
        if (StringHelper.isBlank((String)string)) {
            throw new IllegalArgumentException("clientId is null or empty");
        }
        if (privateKey == null) {
            throw new NullPointerException("PrivateKey is null or empty");
        }
        this.clientId = string;
        this.key = privateKey;
        if (privateKey instanceof RSAPrivateKey) {
            if (((RSAPrivateKey)privateKey).getModulus().bitLength() < 2048) {
                throw new IllegalArgumentException("certificate key size must be at least 2048");
            }
        } else if ("sun.security.mscapi.RSAPrivateKey".equals(privateKey.getClass().getName())) {
            if (((Length)((Object)privateKey)).length() < 2048) {
                throw new IllegalArgumentException("certificate key size must be at least 2048");
            }
        } else {
            throw new IllegalArgumentException("certificate key must be an instance of java.security.interfaces.RSAPrivateKey or sun.security.mscapi.RSAPrivateKey");
        }
        this.publicCertificate = x509Certificate;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getPublicCertificateHash() throws CertificateEncodingException, NoSuchAlgorithmException {
        return Base64.encodeBase64String((byte[])AsymmetricKeyCredential.getHash((byte[])this.publicCertificate.getEncoded()));
    }

    public String getPublicCertificate() throws CertificateEncodingException, NoSuchAlgorithmException {
        return Base64.encodeBase64String((byte[])this.publicCertificate.getEncoded());
    }

    public PrivateKey getKey() {
        return this.key;
    }

    public static AsymmetricKeyCredential create(String string, InputStream inputStream, String string2) throws KeyStoreException, NoSuchProviderException, NoSuchAlgorithmException, CertificateException, IOException, UnrecoverableKeyException {
        KeyStore keyStore = KeyStore.getInstance("PKCS12", "SunJSSE");
        keyStore.load(inputStream, string2.toCharArray());
        Enumeration<String> enumeration = keyStore.aliases();
        String string3 = enumeration.nextElement();
        PrivateKey privateKey = (PrivateKey)keyStore.getKey(string3, string2.toCharArray());
        X509Certificate x509Certificate = (X509Certificate)keyStore.getCertificate(string3);
        return AsymmetricKeyCredential.create((String)string, (PrivateKey)privateKey, (X509Certificate)x509Certificate);
    }

    public static AsymmetricKeyCredential create(String string, PrivateKey privateKey, X509Certificate x509Certificate) {
        return new AsymmetricKeyCredential(string, privateKey, x509Certificate);
    }

    private static byte[] getHash(byte[] byArray) throws NoSuchAlgorithmException, CertificateEncodingException {
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
        messageDigest.update(byArray);
        return messageDigest.digest();
    }
}

