/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.google.gson_2_2_4;

import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import java.util.NoSuchElementException;
import macromedia.externals.com.google.gson_2_2_4.JsonElement;
import macromedia.externals.com.google.gson_2_2_4.JsonIOException;
import macromedia.externals.com.google.gson_2_2_4.JsonParseException;
import macromedia.externals.com.google.gson_2_2_4.JsonSyntaxException;
import macromedia.externals.com.google.gson_2_2_4.internal.Streams;
import macromedia.externals.com.google.gson_2_2_4.stream.JsonReader;
import macromedia.externals.com.google.gson_2_2_4.stream.JsonToken;
import macromedia.externals.com.google.gson_2_2_4.stream.MalformedJsonException;

public final class JsonStreamParser
implements Iterator<JsonElement> {
    private final JsonReader parser;
    private final Object lock;

    public JsonStreamParser(String string) {
        this((Reader)new StringReader(string));
    }

    public JsonStreamParser(Reader reader) {
        this.parser = new JsonReader(reader);
        this.parser.setLenient(true);
        this.lock = new Object();
    }

    @Override
    public JsonElement next() throws JsonParseException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        try {
            return Streams.parse((JsonReader)this.parser);
        }
        catch (StackOverflowError stackOverflowError) {
            throw new JsonParseException("Failed parsing JSON source to Json", (Throwable)stackOverflowError);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throw new JsonParseException("Failed parsing JSON source to Json", (Throwable)outOfMemoryError);
        }
        catch (JsonParseException jsonParseException) {
            throw jsonParseException.getCause() instanceof EOFException ? new NoSuchElementException() : jsonParseException;
        }
    }

    @Override
    public boolean hasNext() {
        Object object = this.lock;
        synchronized (object) {
            try {
                return this.parser.peek() != JsonToken.END_DOCUMENT;
            }
            catch (MalformedJsonException malformedJsonException) {
                throw new JsonSyntaxException((Throwable)malformedJsonException);
            }
            catch (IOException iOException) {
                throw new JsonIOException((Throwable)iOException);
            }
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

