/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.google.gson_2_2_4;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import macromedia.externals.com.google.gson_2_2_4.JsonElement;
import macromedia.externals.com.google.gson_2_2_4.JsonIOException;
import macromedia.externals.com.google.gson_2_2_4.JsonParseException;
import macromedia.externals.com.google.gson_2_2_4.JsonSyntaxException;
import macromedia.externals.com.google.gson_2_2_4.internal.Streams;
import macromedia.externals.com.google.gson_2_2_4.stream.JsonReader;
import macromedia.externals.com.google.gson_2_2_4.stream.JsonToken;
import macromedia.externals.com.google.gson_2_2_4.stream.MalformedJsonException;

public final class JsonParser {
    public JsonElement parse(String string) throws JsonSyntaxException {
        return this.parse((Reader)new StringReader(string));
    }

    public JsonElement parse(Reader reader) throws JsonIOException, JsonSyntaxException {
        try {
            JsonReader jsonReader = new JsonReader(reader);
            JsonElement jsonElement = this.parse(jsonReader);
            if (!jsonElement.isJsonNull() && jsonReader.peek() != JsonToken.END_DOCUMENT) {
                throw new JsonSyntaxException("Did not consume the entire document.");
            }
            return jsonElement;
        }
        catch (MalformedJsonException malformedJsonException) {
            throw new JsonSyntaxException((Throwable)malformedJsonException);
        }
        catch (IOException iOException) {
            throw new JsonIOException((Throwable)iOException);
        }
        catch (NumberFormatException numberFormatException) {
            throw new JsonSyntaxException((Throwable)numberFormatException);
        }
    }

    public JsonElement parse(JsonReader jsonReader) throws JsonIOException, JsonSyntaxException {
        boolean bl2 = jsonReader.isLenient();
        jsonReader.setLenient(true);
        try {
            JsonElement jsonElement = Streams.parse((JsonReader)jsonReader);
            return jsonElement;
        }
        catch (StackOverflowError stackOverflowError) {
            throw new JsonParseException("Failed parsing JSON source: " + jsonReader + " to Json", (Throwable)stackOverflowError);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throw new JsonParseException("Failed parsing JSON source: " + jsonReader + " to Json", (Throwable)outOfMemoryError);
        }
        finally {
            jsonReader.setLenient(bl2);
        }
    }
}

