/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.google.gson_2_2_4;

import java.lang.reflect.Type;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import macromedia.externals.com.google.gson_2_2_4.DefaultDateTypeAdapter;
import macromedia.externals.com.google.gson_2_2_4.ExclusionStrategy;
import macromedia.externals.com.google.gson_2_2_4.FieldNamingPolicy;
import macromedia.externals.com.google.gson_2_2_4.FieldNamingStrategy;
import macromedia.externals.com.google.gson_2_2_4.Gson;
import macromedia.externals.com.google.gson_2_2_4.InstanceCreator;
import macromedia.externals.com.google.gson_2_2_4.JsonDeserializer;
import macromedia.externals.com.google.gson_2_2_4.JsonSerializer;
import macromedia.externals.com.google.gson_2_2_4.LongSerializationPolicy;
import macromedia.externals.com.google.gson_2_2_4.TreeTypeAdapter;
import macromedia.externals.com.google.gson_2_2_4.TypeAdapter;
import macromedia.externals.com.google.gson_2_2_4.TypeAdapterFactory;
import macromedia.externals.com.google.gson_2_2_4.internal.;
import macromedia.externals.com.google.gson_2_2_4.internal.Excluder;
import macromedia.externals.com.google.gson_2_2_4.internal.bind.TypeAdapters;
import macromedia.externals.com.google.gson_2_2_4.reflect.TypeToken;

public final class GsonBuilder {
    private Excluder excluder = Excluder.DEFAULT;
    private LongSerializationPolicy longSerializationPolicy = LongSerializationPolicy.DEFAULT;
    private FieldNamingStrategy fieldNamingPolicy = FieldNamingPolicy.IDENTITY;
    private final Map<Type, InstanceCreator<?>> instanceCreators = new HashMap();
    private final List<TypeAdapterFactory> factories = new ArrayList();
    private final List<TypeAdapterFactory> hierarchyFactories = new ArrayList();
    private boolean serializeNulls;
    private String datePattern;
    private int dateStyle = 2;
    private int timeStyle = 2;
    private boolean complexMapKeySerialization;
    private boolean serializeSpecialFloatingPointValues;
    private boolean escapeHtmlChars = true;
    private boolean prettyPrinting;
    private boolean generateNonExecutableJson;

    public GsonBuilder setVersion(double d2) {
        this.excluder = this.excluder.withVersion(d2);
        return this;
    }

    public GsonBuilder excludeFieldsWithModifiers(int ... nArray) {
        this.excluder = this.excluder.withModifiers(nArray);
        return this;
    }

    public GsonBuilder generateNonExecutableJson() {
        this.generateNonExecutableJson = true;
        return this;
    }

    public GsonBuilder excludeFieldsWithoutExposeAnnotation() {
        this.excluder = this.excluder.excludeFieldsWithoutExposeAnnotation();
        return this;
    }

    public GsonBuilder serializeNulls() {
        this.serializeNulls = true;
        return this;
    }

    public GsonBuilder enableComplexMapKeySerialization() {
        this.complexMapKeySerialization = true;
        return this;
    }

    public GsonBuilder disableInnerClassSerialization() {
        this.excluder = this.excluder.disableInnerClassSerialization();
        return this;
    }

    public GsonBuilder setLongSerializationPolicy(LongSerializationPolicy longSerializationPolicy) {
        this.longSerializationPolicy = longSerializationPolicy;
        return this;
    }

    public GsonBuilder setFieldNamingPolicy(FieldNamingPolicy fieldNamingPolicy) {
        this.fieldNamingPolicy = fieldNamingPolicy;
        return this;
    }

    public GsonBuilder setFieldNamingStrategy(FieldNamingStrategy fieldNamingStrategy) {
        this.fieldNamingPolicy = fieldNamingStrategy;
        return this;
    }

    public GsonBuilder setExclusionStrategies(ExclusionStrategy ... exclusionStrategyArray) {
        for (ExclusionStrategy exclusionStrategy : exclusionStrategyArray) {
            this.excluder = this.excluder.withExclusionStrategy(exclusionStrategy, true, true);
        }
        return this;
    }

    public GsonBuilder addSerializationExclusionStrategy(ExclusionStrategy exclusionStrategy) {
        this.excluder = this.excluder.withExclusionStrategy(exclusionStrategy, true, false);
        return this;
    }

    public GsonBuilder addDeserializationExclusionStrategy(ExclusionStrategy exclusionStrategy) {
        this.excluder = this.excluder.withExclusionStrategy(exclusionStrategy, false, true);
        return this;
    }

    public GsonBuilder setPrettyPrinting() {
        this.prettyPrinting = true;
        return this;
    }

    public GsonBuilder disableHtmlEscaping() {
        this.escapeHtmlChars = false;
        return this;
    }

    public GsonBuilder setDateFormat(String string) {
        this.datePattern = string;
        return this;
    }

    public GsonBuilder setDateFormat(int n2) {
        this.dateStyle = n2;
        this.datePattern = null;
        return this;
    }

    public GsonBuilder setDateFormat(int n2, int n3) {
        this.dateStyle = n2;
        this.timeStyle = n3;
        this.datePattern = null;
        return this;
    }

    public GsonBuilder registerTypeAdapter(Type type, Object object) {
        .Gson.Preconditions.checkArgument((object instanceof JsonSerializer || object instanceof JsonDeserializer || object instanceof InstanceCreator || object instanceof TypeAdapter ? (byte)1 : 0) != 0);
        if (object instanceof InstanceCreator) {
            this.instanceCreators.put(type, (InstanceCreator)object);
        }
        if (object instanceof JsonSerializer || object instanceof JsonDeserializer) {
            TypeToken typeToken = TypeToken.get((Type)type);
            this.factories.add(TreeTypeAdapter.newFactoryWithMatchRawType((TypeToken)typeToken, (Object)object));
        }
        if (object instanceof TypeAdapter) {
            this.factories.add(TypeAdapters.newFactory((TypeToken)TypeToken.get((Type)type), (TypeAdapter)((TypeAdapter)object)));
        }
        return this;
    }

    public GsonBuilder registerTypeAdapterFactory(TypeAdapterFactory typeAdapterFactory) {
        this.factories.add(typeAdapterFactory);
        return this;
    }

    public GsonBuilder registerTypeHierarchyAdapter(Class<?> clazz, Object object) {
        .Gson.Preconditions.checkArgument((object instanceof JsonSerializer || object instanceof JsonDeserializer || object instanceof TypeAdapter ? (byte)1 : 0) != 0);
        if (object instanceof JsonDeserializer || object instanceof JsonSerializer) {
            this.hierarchyFactories.add(0, TreeTypeAdapter.newTypeHierarchyFactory(clazz, (Object)object));
        }
        if (object instanceof TypeAdapter) {
            this.factories.add(TypeAdapters.newTypeHierarchyFactory(clazz, (TypeAdapter)((TypeAdapter)object)));
        }
        return this;
    }

    public GsonBuilder serializeSpecialFloatingPointValues() {
        this.serializeSpecialFloatingPointValues = true;
        return this;
    }

    public Gson create() {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.factories);
        Collections.reverse(arrayList);
        arrayList.addAll(this.hierarchyFactories);
        this.addTypeAdaptersForDate(this.datePattern, this.dateStyle, this.timeStyle, arrayList);
        return new Gson(this.excluder, this.fieldNamingPolicy, this.instanceCreators, this.serializeNulls, this.complexMapKeySerialization, this.generateNonExecutableJson, this.escapeHtmlChars, this.prettyPrinting, this.serializeSpecialFloatingPointValues, this.longSerializationPolicy, arrayList);
    }

    private void addTypeAdaptersForDate(String string, int n2, int n3, List<TypeAdapterFactory> list) {
        DefaultDateTypeAdapter defaultDateTypeAdapter;
        if (string != null && !"".equals(string.trim())) {
            defaultDateTypeAdapter = new DefaultDateTypeAdapter(string);
        } else if (n2 != 2 && n3 != 2) {
            defaultDateTypeAdapter = new DefaultDateTypeAdapter(n2, n3);
        } else {
            return;
        }
        list.add(TreeTypeAdapter.newFactory((TypeToken)TypeToken.get(java.util.Date.class), (Object)defaultDateTypeAdapter));
        list.add(TreeTypeAdapter.newFactory((TypeToken)TypeToken.get(Timestamp.class), (Object)defaultDateTypeAdapter));
        list.add(TreeTypeAdapter.newFactory((TypeToken)TypeToken.get(Date.class), (Object)defaultDateTypeAdapter));
    }
}

