/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.google.gson_2_2_4;

import java.lang.reflect.Type;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import macromedia.externals.com.google.gson_2_2_4.JsonDeserializationContext;
import macromedia.externals.com.google.gson_2_2_4.JsonDeserializer;
import macromedia.externals.com.google.gson_2_2_4.JsonElement;
import macromedia.externals.com.google.gson_2_2_4.JsonParseException;
import macromedia.externals.com.google.gson_2_2_4.JsonPrimitive;
import macromedia.externals.com.google.gson_2_2_4.JsonSerializationContext;
import macromedia.externals.com.google.gson_2_2_4.JsonSerializer;
import macromedia.externals.com.google.gson_2_2_4.JsonSyntaxException;

final class DefaultDateTypeAdapter
implements JsonDeserializer<Date>,
JsonSerializer<Date> {
    private final DateFormat enUsFormat;
    private final DateFormat localFormat;
    private final DateFormat iso8601Format;

    DefaultDateTypeAdapter() {
        this(DateFormat.getDateTimeInstance(2, 2, Locale.US), DateFormat.getDateTimeInstance(2, 2));
    }

    DefaultDateTypeAdapter(String string) {
        this((DateFormat)new SimpleDateFormat(string, Locale.US), (DateFormat)new SimpleDateFormat(string));
    }

    DefaultDateTypeAdapter(int n2) {
        this(DateFormat.getDateInstance(n2, Locale.US), DateFormat.getDateInstance(n2));
    }

    public DefaultDateTypeAdapter(int n2, int n3) {
        this(DateFormat.getDateTimeInstance(n2, n3, Locale.US), DateFormat.getDateTimeInstance(n2, n3));
    }

    DefaultDateTypeAdapter(DateFormat dateFormat, DateFormat dateFormat2) {
        this.enUsFormat = dateFormat;
        this.localFormat = dateFormat2;
        this.iso8601Format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.US);
        this.iso8601Format.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonElement serialize(Date date, Type type, JsonSerializationContext jsonSerializationContext) {
        DateFormat dateFormat = this.localFormat;
        synchronized (dateFormat) {
            String string = this.enUsFormat.format(date);
            return new JsonPrimitive(string);
        }
    }

    public Date deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        if (!(jsonElement instanceof JsonPrimitive)) {
            throw new JsonParseException("The date should be a string value");
        }
        Date date = this.deserializeToDate(jsonElement);
        if (type == Date.class) {
            return date;
        }
        if (type == Timestamp.class) {
            return new Timestamp(date.getTime());
        }
        if (type == java.sql.Date.class) {
            return new java.sql.Date(date.getTime());
        }
        throw new IllegalArgumentException(this.getClass() + " cannot deserialize to " + type);
    }

    private Date deserializeToDate(JsonElement jsonElement) {
        DateFormat dateFormat = this.localFormat;
        synchronized (dateFormat) {
            try {
                return this.localFormat.parse(jsonElement.getAsString());
            }
            catch (ParseException parseException) {
                try {
                    return this.enUsFormat.parse(jsonElement.getAsString());
                }
                catch (ParseException parseException2) {
                    try {
                        return this.iso8601Format.parse(jsonElement.getAsString());
                    }
                    catch (ParseException parseException3) {
                        throw new JsonSyntaxException(jsonElement.getAsString(), (Throwable)parseException3);
                    }
                }
            }
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(DefaultDateTypeAdapter.class.getSimpleName());
        stringBuilder.append('(').append(this.localFormat.getClass().getSimpleName()).append(')');
        return stringBuilder.toString();
    }
}

