/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.scheduling;

import coldfusion.cfc.CFCProxy;
import coldfusion.log.CFLogs;
import coldfusion.osgi.to.ScheduleTagTO;
import coldfusion.runtime.Struct;
import coldfusion.scheduling.CronServiceImpl;
import coldfusion.scheduling.CronUtil;
import coldfusion.scheduling.ScheduleTagData;
import coldfusion.scheduling.SchedulerValidator;
import coldfusion.server.ServiceFactory;
import coldfusion.tagext.net.HttpTag;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobKey;
import org.quartz.SchedulerException;

public class CronTask
implements Job {
    public void execute(JobExecutionContext ctx) throws JobExecutionException {
        String path;
        ScheduleTagData metadata = (ScheduleTagData)((Object)ctx.getMergedJobDataMap().get((Object)"metadata"));
        CFLogs.SCHEDULER_LOG.info((Object)("Task " + metadata.getGroup() + "." + metadata.getTask() + " triggered."));
        String taskPath = metadata.getPath();
        String taskFile = metadata.getFile();
        String string = path = taskPath == null || taskFile == null ? null : taskPath + taskFile;
        if (metadata.isPublish() && !SchedulerValidator.isValidSchedulePath(path)) {
            CFLogs.SCHEDULER_LOG.error((Object)("Task " + metadata.getGroup() + "." + metadata.getTask() + " suspended due to invalid publish path: " + metadata.getPath() + metadata.getFile() + " (task data preserved - will resume if path validation is fixed)"));
            return;
        }
        metadata.setValidPublishPath(true);
        if (metadata.isChained() || metadata.getInterval() != null && metadata.getInterval().equalsIgnoreCase("once")) {
            metadata.setLastfire(ctx.getFireTime());
            try {
                ((CronServiceImpl)ServiceFactory.getCronService()).updateAndStore(metadata);
            }
            catch (Throwable ex) {
                CFLogs.SCHEDULER_LOG.error(ex);
            }
        }
        try (PrintWriter out = null;){
            HttpTag http = metadata.getHttpTag();
            if (null != http) {
                if (metadata.isPublish()) {
                    File file;
                    String filename = metadata.getFile();
                    boolean overwrite = metadata.getOverwrite();
                    if (!overwrite) {
                        filename = CronUtil.getOverwriteFilename(filename);
                    }
                    if (!(file = new File(metadata.getPath() + "/" + filename)).exists()) {
                        file.createNewFile();
                    }
                    out = new PrintWriter(new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file))));
                    out.println(http.runCall().getFilecontent());
                    out.close();
                } else {
                    http.setThrowonerror(true);
                    http.runCall().getFilecontent();
                }
            } else {
                this.invokeHandler(ctx, null, "execute");
            }
            this.onCompleteTask(metadata, ctx);
        }
    }

    private void onCompleteTask(ScheduleTagData metadata, JobExecutionContext ctx) {
        try {
            this.invokeHandler(ctx, null, "ontaskend");
        }
        catch (Throwable e) {
            CFLogs.SCHEDULER_LOG.error(e);
        }
        String tasks = metadata.getChianedtasks();
        if (CronUtil.stringNullCheck(tasks)) {
            return;
        }
        for (String task2 : tasks.split(",")) {
            String[] split = task2.split(":");
            String taskname = split[0].trim();
            String group = "";
            String mode = "";
            group = split.length >= 2 ? split[1].trim() : "DEFAULT";
            mode = split.length == 3 ? split[2].trim() : "server";
            try {
                ScheduleTagTO chainedtaskdata = null;
                chainedtaskdata = mode.equals("server") ? ServiceFactory.getCronService().findTask(taskname, group, mode) : ServiceFactory.getCronService().findTask(taskname, group, mode, metadata.getAppname());
                CronServiceImpl.getSchedulerInstance(chainedtaskdata.isClustered()).triggerJob(JobKey.jobKey((String)CronUtil.getJobname(taskname), (String)CronUtil.getFullGroupName(chainedtaskdata.getGroup(), chainedtaskdata.getMode())));
            }
            catch (SchedulerException ex) {
                CFLogs.SCHEDULER_LOG.error((Throwable)ex);
            }
            catch (Throwable ex) {
                CFLogs.SCHEDULER_LOG.error((Throwable)new Exception("Task " + taskname + " could not be chained"));
            }
        }
    }

    private JobExecutionException handleException(JobExecutionContext ctx, Throwable e) {
        JobExecutionException jee = new JobExecutionException(e);
        ScheduleTagData metadata = (ScheduleTagData)((Object)ctx.getMergedJobDataMap().get((Object)"metadata"));
        String onexception = metadata.getOnexception();
        if ("refire".equalsIgnoreCase(onexception)) {
            int retrycount = ctx.getRefireCount();
            if (retrycount != Integer.parseInt(metadata.getRetrycount())) {
                jee.setRefireImmediately(true);
            }
        } else if ("unscheduleall".equalsIgnoreCase(onexception)) {
            jee.setUnscheduleAllTriggers(true);
        } else if ("pause".equalsIgnoreCase(onexception)) {
            this.pauseTask(ctx);
        } else if ("invokehandler".equalsIgnoreCase(onexception)) {
            try {
                this.invokeHandler(ctx, e, "onerror");
            }
            catch (Throwable e1) {
                CFLogs.SCHEDULER_LOG.error(e1);
            }
        }
        return jee;
    }

    private Object invokeMethod(String cfclistener, Struct struct, String method, JobExecutionContext ctx) throws Throwable {
        if (CronUtil.stringNullCheck(cfclistener)) {
            return null;
        }
        Object result = null;
        CFCProxy proxy = this.getCFCProxy(cfclistener, ctx);
        if (null != proxy) {
            proxy.setSchedulerEvent(true);
            result = proxy.invoke(method, new Object[]{struct});
        }
        return result;
    }

    private CFCProxy getCFCProxy(String cfclistener, JobExecutionContext ctx) {
        ScheduleTagData metadata = (ScheduleTagData)((Object)ctx.getMergedJobDataMap().get((Object)"metadata"));
        CFCProxy proxy = metadata.getCfcProxy();
        try {
            proxy = new CFCProxy(cfclistener, false);
        }
        catch (Throwable ex) {
            CFLogs.SCHEDULER_LOG.error(ex);
        }
        return proxy;
    }

    private void invokeHandler(JobExecutionContext ctx, Throwable e, String methodname) throws Throwable {
        ScheduleTagData metadata = (ScheduleTagData)((Object)ctx.getMergedJobDataMap().get((Object)"metadata"));
        String cfclistener = metadata.getEventhandler();
        Struct struct = new Struct();
        struct.put((Object)"task", (Object)metadata.getTask());
        struct.put((Object)"group", (Object)metadata.getGroupName());
        struct.put((Object)"mode", (Object)metadata.getMode());
        struct.put((Object)"fireinstanceid", (Object)ctx.getFireInstanceId());
        if (null != e) {
            struct.put((Object)"exceptionmessage", (Object)e.getLocalizedMessage());
        }
        this.invokeMethod(cfclistener, struct, methodname, ctx);
    }

    private void pauseTask(JobExecutionContext ctx) {
        try {
            ScheduleTagData metadata = (ScheduleTagData)((Object)ctx.getMergedJobDataMap().get((Object)"metadata"));
            ServiceFactory.getCronService().pauseTask(metadata.getTask(), metadata.getGroup(), metadata.getMode());
        }
        catch (Exception ex) {
            CFLogs.SCHEDULER_LOG.error((Throwable)ex);
        }
    }
}

