/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.InputStream;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.view.JRDesignViewer;

public class JasperDesignViewer
extends JFrame {
    private JPanel pnlMain;

    public JasperDesignViewer(String sourceFile, boolean isXML) throws JRException {
        this.initComponents();
        JRDesignViewer viewer = new JRDesignViewer(sourceFile, isXML);
        this.pnlMain.add((Component)viewer, "Center");
    }

    public JasperDesignViewer(InputStream is, boolean isXML) throws JRException {
        this.initComponents();
        JRDesignViewer viewer = new JRDesignViewer(is, isXML);
        this.pnlMain.add((Component)viewer, "Center");
    }

    public JasperDesignViewer(JRReport report) throws JRException {
        this.initComponents();
        JRDesignViewer viewer = new JRDesignViewer(report);
        this.pnlMain.add((Component)viewer, "Center");
    }

    private void initComponents() {
        int width;
        this.pnlMain = new JPanel();
        this.setTitle("JasperDesignViewer");
        this.setIconImage(new ImageIcon(this.getClass().getResource("/net/sf/jasperreports/view/images/jricon.GIF")).getImage());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                JasperDesignViewer.this.exitForm();
            }
        });
        this.pnlMain.setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.pnlMain, "Center");
        this.pack();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension screenSize = toolkit.getScreenSize();
        int screenResolution = toolkit.getScreenResolution();
        float zoom = (float)screenResolution / 72.0f;
        int height = (int)(550.0f * zoom);
        if ((double)height > screenSize.getHeight()) {
            height = (int)screenSize.getHeight();
        }
        if ((double)(width = (int)(750.0f * zoom)) > screenSize.getWidth()) {
            width = (int)screenSize.getWidth();
        }
        Dimension dimension = new Dimension(width, height);
        this.setSize(dimension);
        this.setLocation((screenSize.width - width) / 2, (screenSize.height - height) / 2);
    }

    void exitForm() {
        System.exit(0);
    }

    public static void main(String[] args) {
        String fileName = null;
        boolean isXMLFile = false;
        if (args.length == 0) {
            JasperDesignViewer.usage();
            return;
        }
        for (int k = 0; args.length > k; ++k) {
            if (args[k].startsWith("-F")) {
                fileName = args[k].substring(2);
            }
            if (!args[k].startsWith("-XML")) continue;
            isXMLFile = true;
        }
        try {
            JasperDesignViewer.viewReportDesign(fileName, isXMLFile);
        }
        catch (JRException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private static void usage() {
        System.out.println("JasperDesignViewer usage:");
        System.out.println("\tjava JasperDesignViewer -XML -Ffile");
    }

    public static void viewReportDesign(String sourceFile, boolean isXML) throws JRException {
        JasperDesignViewer jasperDesignViewer = new JasperDesignViewer(sourceFile, isXML);
        jasperDesignViewer.setVisible(true);
    }

    public static void viewReportDesign(InputStream is, boolean isXML) throws JRException {
        JasperDesignViewer jasperDesignViewer = new JasperDesignViewer(is, isXML);
        jasperDesignViewer.setVisible(true);
    }

    public static void viewReportDesign(JRReport report) throws JRException {
        JasperDesignViewer jasperDesignViewer = new JasperDesignViewer(report);
        jasperDesignViewer.setVisible(true);
    }
}

