/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime.report;

import coldfusion.filter.FusionContext;
import coldfusion.jsp.JspWriterIncludeResponse;
import coldfusion.runtime.AbortException;
import coldfusion.runtime.CFOutput;
import coldfusion.runtime.Cast;
import coldfusion.runtime.CfJspPage;
import coldfusion.runtime.MalformedReportException;
import coldfusion.runtime.NeoException;
import coldfusion.runtime.NeoPageContext;
import coldfusion.runtime.NotSupportedFormatException;
import coldfusion.runtime.TemplateProxy;
import coldfusion.runtime.TemplateProxyFactory;
import coldfusion.runtime.report.CFCsvExporter;
import coldfusion.runtime.report.CFExportProgressMonitor;
import coldfusion.runtime.report.CFHtmlExporter;
import coldfusion.runtime.report.CFHtmlExporterParameter;
import coldfusion.runtime.report.CFPdfExporter;
import coldfusion.runtime.report.CFRtfExporter;
import coldfusion.server.LicenseService;
import coldfusion.server.ServiceFactory;
import coldfusion.tagext.OutputException;
import coldfusion.tagext.net.ContentTag;
import coldfusion.util.BOMReader;
import coldfusion.util.CFFileServlet;
import coldfusion.util.IOUtils;
import coldfusion.util.RuntimeWrapper;
import coldfusion.util.SoftCache;
import coldfusion.util.UUIDUtils;
import coldfusion.util.Utils;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRSubreport;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.export.JRHtmlExporterParameter;
import net.sf.jasperreports.engine.export.JRXlsExporter;
import net.sf.jasperreports.engine.export.JRXmlExporter;
import net.sf.jasperreports.engine.fill.JRFileVirtualizer;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.xml.JRXmlLoader;

public class Report {
    private Map ExportParams = null;
    private static final Object Lock = new Object();
    private static int NumInUseThreads = 0;
    private static int MAXINUSETHREADS_ENTERPRISE = ServiceFactory.getRuntimeService().getNumberSimultaneousReports();
    private static int maxthreadcount = ServiceFactory.getLicenseService().isStandard() ? 1 : MAXINUSETHREADS_ENTERPRISE;
    public static boolean isDebug = false;
    private JRFileVirtualizer virtualizer = null;
    private static final int MAX_REPORT_PAGES_IN_CACHE = 25;
    private static final int DEFAULT_RESOURCE_TIMEOUT_IN_SEC = 300;
    private static final String RESOURCE_CACHE_DIR = "CFFileServlet/_cfreport";
    private static File resourceCacheDir;
    private static final String DATA_QUERIES = "QUERIES";
    private static final String DATA_STYLES = "STYLES";
    private Map subreportData = new HashMap();
    private String styleAttr = null;
    private NeoPageContext pageContext;
    private TemplateProxy reportCFC;
    private JasperPrint jasperPrint;
    static final SoftCache jasperReportsCache;
    private static int waitingThreads;

    public Report(String Template, NeoPageContext pageContext) {
        File reportTemplate = new File(Template);
        if (!reportTemplate.exists()) {
            throw new ReportTemplateNonExistantException(Template);
        }
        try {
            this.reportCFC = TemplateProxyFactory.resolveFile((NeoPageContext)pageContext, (File)reportTemplate);
            this.pageContext = pageContext;
        }
        catch (Throwable t) {
            throw new MalformedReportException(Template, t);
        }
    }

    public Report(String Template, NeoPageContext pageContext, String style) {
        this(Template, pageContext);
        this.styleAttr = style;
    }

    public Report(TemplateProxy reportCFC, NeoPageContext pageContext) {
        this.pageContext = pageContext;
        this.reportCFC = reportCFC;
    }

    public JasperReport compileReport(final ResultSet rs) {
        if (System.getSecurityManager() == null) {
            return this._compileReport(rs);
        }
        return (JasperReport)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Report.this._compileReport(rs);
            }
        });
    }

    public static boolean watermarkExcel() {
        LicenseService license_service = ServiceFactory.getLicenseService();
        return license_service.isDeveloper();
    }

    public Map getSubreportQueries() {
        return (Map)this.subreportData.get(DATA_QUERIES);
    }

    public void setSubreportQueries(Map subreportQueries) {
        this.subreportData.put(DATA_QUERIES, subreportQueries);
    }

    public Map getSubreportStyles() {
        return (Map)this.subreportData.get(DATA_STYLES);
    }

    public void setSubreportStyles(Map subreportStyles) {
        this.subreportData.put(DATA_STYLES, subreportStyles);
    }

    private JasperReport _compileReport(ResultSet rs) {
        JasperReport report;
        try {
            LicenseService license_service;
            boolean isEnterprise;
            System.setProperty("jasper.reports.compiler.class", "coldfusion.runtime.report.CFRptCompiler");
            String reportXML = (String)this.reportCFC.invoke("GetReportXML", new Object[]{rs}, (PageContext)this.pageContext);
            String cssStyle = null;
            if (this.styleAttr != null) {
                String stylePath = JRLoader.resolveSubReportPath(this.styleAttr, this.pageContext);
                try {
                    BOMReader in = new BOMReader(new BufferedInputStream(new FileInputStream(stylePath)), "UTF-8", true);
                    cssStyle = IOUtils.toString((Reader)in);
                }
                catch (IOException e1) {
                    cssStyle = this.styleAttr;
                }
            }
            if (isEnterprise = (license_service = ServiceFactory.getLicenseService()).isEnterprise()) {
                String key = cssStyle != null ? cssStyle + reportXML : reportXML;
                JasperReport orig = (JasperReport)jasperReportsCache.get((Object)key);
                report = new JasperReport(orig, orig.getCompilerClass(), orig.getCompileData(), null);
            } else {
                report = Report.compileXml(reportXML, cssStyle);
            }
        }
        catch (JRException e) {
            throw new ReportCompilationException(e);
        }
        catch (Throwable t) {
            throw new RuntimeWrapper(t);
        }
        return report;
    }

    /*
     * Exception decompiling
     */
    public void runReport(ResultSet query, Map params) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.IndexOutOfBoundsException: Index 0 out of bounds for length 0
         *     at java.base/jdk.internal.util.Preconditions.outOfBounds(Preconditions.java:100)
         *     at java.base/jdk.internal.util.Preconditions.outOfBoundsCheckIndex(Preconditions.java:106)
         *     at java.base/jdk.internal.util.Preconditions.checkIndex(Preconditions.java:302)
         *     at java.base/java.util.Objects.checkIndex(Objects.java:385)
         *     at java.base/java.util.ArrayList.get(ArrayList.java:427)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ClassifyGotos.classifyTryCatchLeaveGoto(ClassifyGotos.java:144)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ClassifyGotos.classifyTryLeaveGoto(ClassifyGotos.java:76)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ClassifyGotos.classifyGotos(ClassifyGotos.java:66)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.classifyGotos(Op03Rewriters.java:105)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:752)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void setupSubreportData(JasperReport jrReport) {
        Map subreportStyles;
        Map subreportQueries = this.getSubreportQueries();
        if (subreportQueries != null) {
            Iterator elementNames = subreportQueries.keySet().iterator();
            this.setupSubreportHelper(jrReport, elementNames, true);
        }
        if ((subreportStyles = this.getSubreportStyles()) != null) {
            Iterator elementNames = subreportStyles.keySet().iterator();
            this.setupSubreportHelper(jrReport, elementNames, false);
        }
    }

    public void setupSubreportHelper(JasperReport jrReport, Iterator elementNames, boolean isQuery) {
        while (elementNames.hasNext()) {
            String name = (String)elementNames.next();
            this.checkBand(jrReport.getTitle(), name, isQuery);
            this.checkBand(jrReport.getSummary(), name, isQuery);
            this.checkBand(jrReport.getPageHeader(), name, isQuery);
            this.checkBand(jrReport.getPageFooter(), name, isQuery);
            this.checkBand(jrReport.getColumnHeader(), name, isQuery);
            this.checkBand(jrReport.getColumnFooter(), name, isQuery);
            this.checkBand(jrReport.getDetail(), name, isQuery);
            this.checkBand(jrReport.getBackground(), name, isQuery);
            JRGroup[] groups = jrReport.getGroups();
            for (int i = 0; groups != null && i < groups.length; ++i) {
                JRGroup group = groups[i];
                this.checkBand(group.getGroupHeader(), name, isQuery);
                this.checkBand(group.getGroupFooter(), name, isQuery);
            }
        }
    }

    private void checkBand(JRBand band, String key, boolean isQuery) {
        if (band == null) {
            return;
        }
        JRElement[] elements = band.getElements();
        if (elements == null || elements.length == 0) {
            return;
        }
        for (int i = 0; i < elements.length; ++i) {
            JRElement element = elements[i];
            if (!(element instanceof JRSubreport) || !element.getKey().equalsIgnoreCase(key)) continue;
            JRSubreport sr = (JRSubreport)element;
            if (isQuery) {
                sr.setSubreportQueries(this.getSubreportQueries());
                continue;
            }
            sr.setSubreportStyles(this.getSubreportStyles());
        }
    }

    public NeoPageContext setupScopesForSubReport(NeoPageContext npc, FusionContext fctxt) {
        CfJspPage temp = this.reportCFC.setupScopesForReport(npc, fctxt, true);
        this.pageContext = temp.pageContext;
        return this.pageContext;
    }

    public final void exportReport(final OutputStream os, final String f) throws JRException {
        if (System.getSecurityManager() == null) {
            this._exportReport(os, f);
        } else {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws JRException {
                        Report.this._exportReport(os, f);
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException e) {
                throw (JRException)e.getException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _exportReport(OutputStream os, String f) throws JRException {
        Report.CheckOut();
        try {
            String format = f;
            if (format == null) {
                format = this.getDefaultFormat();
            }
            if (!(format.equalsIgnoreCase("pdf") || format.equalsIgnoreCase("flashpaper") || format.equalsIgnoreCase("html") || format.equalsIgnoreCase("xml") || format.equalsIgnoreCase("excel") || format.equalsIgnoreCase("rtf") || format.equalsIgnoreCase("csv"))) {
                throw new ReportUnSupportedFormatException(format);
            }
            JRAbstractExporter exporter = null;
            if (this.ExportParams == null) {
                this.ExportParams = new HashMap();
            }
            if (format.equalsIgnoreCase("pdf")) {
                exporter = new CFPdfExporter();
            } else if (format.equalsIgnoreCase("xml")) {
                exporter = new JRXmlExporter();
            } else {
                if (format.equalsIgnoreCase("flashpaper")) {
                    throw new NotSupportedFormatException(format);
                }
                if (format.equalsIgnoreCase("html")) {
                    exporter = new CFHtmlExporter();
                    this.setupForHtmlExport();
                } else if (format.equalsIgnoreCase("rtf")) {
                    exporter = new CFRtfExporter();
                } else if (format.equalsIgnoreCase("excel")) {
                    exporter = new JRXlsExporter();
                } else if (format.equalsIgnoreCase("csv")) {
                    exporter = new CFCsvExporter();
                }
            }
            if (exporter != null) {
                this.ExportParams.put(JRExporterParameter.JASPER_PRINT, this.jasperPrint);
                this.ExportParams.put(JRExporterParameter.OUTPUT_STREAM, os);
                if (isDebug) {
                    CFExportProgressMonitor monitor = new CFExportProgressMonitor(this.jasperPrint);
                    this.ExportParams.put(JRExporterParameter.PROGRESS_MONITOR, monitor);
                }
                exporter.setParameters(this.ExportParams);
                exporter.exportReport();
            }
            if (this.virtualizer != null) {
                this.virtualizer.cleanup();
            }
        }
        finally {
            Report.CheckIn();
        }
    }

    private static JasperReport compileXml(String xml, String newStyle) {
        try {
            ByteArrayInputStream is;
            try {
                is = new ByteArrayInputStream(xml.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException ue) {
                is = new ByteArrayInputStream(xml.getBytes());
            }
            JasperDesign jasperDesign = JRXmlLoader.load(is);
            jasperDesign.setCSSStyles(newStyle);
            return JasperCompileManager.compileReport(jasperDesign);
        }
        catch (JRException e) {
            if (e.getMessage().contains("cannot be cast")) {
                throw new ReportClassCastException();
            }
            throw new ReportCompilationException(e);
        }
    }

    public void exportReportToStream() {
        String sFormat = this.getDefaultFormat();
        this.exportReportToStream(sFormat);
    }

    private String getDefaultFormat() {
        String sFormat = "pdf";
        try {
            sFormat = Cast._String((Object)this.reportCFC.invoke("getDefaultReportFormat", new Object[0], (PageContext)this.pageContext));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return sFormat;
    }

    protected String getFileNameForFormat(String format) {
        String ext = ".swf";
        if (format.equalsIgnoreCase("pdf")) {
            ext = ".pdf";
        } else if (format.equalsIgnoreCase("excel")) {
            ext = ".xls";
        } else if (format.equalsIgnoreCase("xml")) {
            ext = ".xml";
        } else if (format.equalsIgnoreCase("html")) {
            ext = ".html";
        } else if (format.equalsIgnoreCase("rtf")) {
            ext = ".rtf";
        } else if (format.equalsIgnoreCase("csv")) {
            ext = ".csv";
        }
        String fileName = this.reportCFC.getName();
        fileName = fileName.substring(0, fileName.lastIndexOf(46));
        int i = fileName.indexOf(46);
        if (i > -1) {
            fileName = fileName.substring(i + 1);
        }
        return fileName + ext;
    }

    public static void setContentType(String Format, ServletResponse resp) {
        if (Format.equalsIgnoreCase("PDF")) {
            resp.setContentType("application/pdf");
        } else if (Format.equalsIgnoreCase("excel")) {
            resp.setContentType("application/vnd.ms-excel");
        } else if (Format.equalsIgnoreCase("xml")) {
            resp.setContentType("text/xml");
        } else if (Format.equalsIgnoreCase("html")) {
            resp.setContentType("text/html");
        } else if (Format.equalsIgnoreCase("rtf")) {
            resp.setContentType("application/msword");
        } else if (Format.equalsIgnoreCase("csv")) {
            resp.setContentType("text/plain");
        } else {
            resp.setContentType("application/x-shockwave-flash");
        }
    }

    public void doAgentHeaderCheck() {
        String conttype;
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        ServletResponse resp = this.pageContext.getResponse();
        while (resp instanceof JspWriterIncludeResponse) {
            resp = ((JspWriterIncludeResponse)resp).getResponse();
        }
        JspWriter out = this.pageContext.getOut();
        if (out instanceof CFOutput) {
            ((CFOutput)out).clearAll();
        }
        if ((conttype = request.getHeader("User-Agent")) != null && conttype.equalsIgnoreCase("contype")) {
            String Format = this.getDefaultFormat();
            Report.setContentType(Format, resp);
            if (this.pageContext != null) {
                this.pageContext.setFlushOutput(false);
            }
            throw new AbortException();
        }
    }

    public void exportReportToStream(String Format) {
        if (Format == null) {
            Format = this.getDefaultFormat();
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream(204800);
        try {
            this.exportReport(baos, Format);
        }
        catch (JRException je) {
            throw new ReportFormatException(je);
        }
        HttpServletResponse res = (HttpServletResponse)this.pageContext.getResponse();
        res.setHeader("Content-disposition", "inline;filename=\"" + this.getFileNameForFormat(Format) + "\"");
        res.setHeader("Expires", "0");
        res.setHeader("Cache-Control", "must-revalidate, post-check=0, pre-check=0");
        res.setHeader("Pragma", "public");
        ServletOutputStream os = null;
        HttpServletResponse resp = res;
        while (resp instanceof JspWriterIncludeResponse) {
            resp = ((JspWriterIncludeResponse)resp).getResponse();
        }
        JspWriter out = this.pageContext.getOut();
        if (out instanceof CFOutput) {
            ((CFOutput)out).clearAll();
        }
        if (this.pageContext instanceof NeoPageContext) {
            this.pageContext.setFlushOutput(false);
        }
        try {
            os = resp.getOutputStream();
            byte[] bytearray = baos.toByteArray();
            Report.setContentType(Format, (ServletResponse)res);
            resp.setContentLength(bytearray.length);
            os.write(bytearray);
            os.flush();
            this.runFinalize();
            throw new AbortException();
        }
        catch (IllegalStateException ex) {
            throw new ContentTag.ContentAfterFlushException();
        }
        catch (IOException ex) {
            throw new OutputException((Throwable)ex);
        }
    }

    public void runFinalize() {
        try {
            this.reportCFC.invoke("FinalizeReport", new Object[0], (PageContext)this.pageContext);
        }
        catch (TemplateProxy.InvalidMethodNameException invalidMethodNameException) {
        }
        catch (NeoException nex) {
            throw nex;
        }
        catch (Throwable t) {
            throw new ReportDataBindingException(new JRException(t));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void CheckOut() {
        ++waitingThreads;
        try {
            Object object = Lock;
            synchronized (object) {
                if (NumInUseThreads < maxthreadcount) {
                    ++NumInUseThreads;
                } else {
                    try {
                        do {
                            Lock.wait();
                        } while (NumInUseThreads >= maxthreadcount);
                        ++NumInUseThreads;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
        finally {
            --waitingThreads;
        }
    }

    private static long calcWaitTime(long reportTime) {
        long delay = 20L;
        int threads = waitingThreads;
        if (reportTime >= 100L) {
            delay = (long)((double)reportTime * 0.6);
        }
        return (long)threads * delay;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void CheckIn() {
        Object object = Lock;
        synchronized (object) {
            if (--NumInUseThreads < 0) {
                NumInUseThreads = 0;
            }
            Lock.notify();
        }
    }

    public void setExportParams(Map exportParams) {
        this.ExportParams = exportParams;
    }

    public TemplateProxy getReportCFC() {
        return this.reportCFC;
    }

    public NeoPageContext getPageContext() {
        return this.pageContext;
    }

    private void setupForHtmlExport() {
        String imageURI = "";
        File imageDir = (File)this.ExportParams.get(CFHtmlExporterParameter.IMAGES_DIR);
        if (imageDir != null) {
            imageURI = imageDir.getName() + "/";
        } else {
            while ((imageDir = new File(resourceCacheDir, "_report" + UUIDUtils.createUUID((boolean)false))).exists()) {
            }
            HttpServletRequest req = (HttpServletRequest)this.pageContext.getRequest();
            imageURI = imageURI + Utils.getContextPath((HttpServletRequest)req);
            imageURI = imageURI + "/CFFileServlet/_cfreport/" + imageDir.getName() + "/";
            Integer timespan = (Integer)this.ExportParams.get(CFHtmlExporterParameter.RESOURCE_TIMESPAN);
            if (timespan == null) {
                timespan = new Integer(300);
                this.ExportParams.put(CFHtmlExporterParameter.RESOURCE_TIMESPAN, timespan);
            }
            this.ExportParams.put(JRHtmlExporterParameter.IMAGES_DIR, imageDir);
        }
        this.ExportParams.put(JRHtmlExporterParameter.IS_USING_IMAGES_TO_ALIGN, Boolean.FALSE);
        this.ExportParams.put(JRHtmlExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_ROWS, Boolean.TRUE);
        this.ExportParams.put(JRHtmlExporterParameter.IS_OUTPUT_IMAGES_TO_DIR, Boolean.TRUE);
        this.ExportParams.put(JRHtmlExporterParameter.IMAGES_URI, imageURI);
    }

    private JasperPrint fillReport(JasperReport report, Map params, JRDataSource ds) throws JRException {
        JasperPrint jprint;
        final JasperReport rep = report;
        final Map paramMap = params;
        final JRDataSource jrds = ds;
        try {
            jprint = (JasperPrint)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return JasperFillManager.fillReport(rep, paramMap, jrds);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw (JRException)pae.getException();
        }
        return jprint;
    }

    private static void clearTempCache() {
        resourceCacheDir = new File(ServiceFactory.getRuntimeService().getTempCacheDirectory(), RESOURCE_CACHE_DIR);
        if (resourceCacheDir.exists()) {
            CFFileServlet.cleanupTempCache((File)resourceCacheDir, (int)0);
        } else {
            resourceCacheDir.mkdirs();
        }
    }

    static {
        jasperReportsCache = new SoftCache(){

            protected Object fetch(Object reportXML) {
                String key = (String)reportXML;
                String style = null;
                int xmlIndex = key.indexOf("<?xml version");
                if (xmlIndex != 0) {
                    style = key.substring(0, xmlIndex);
                }
                String xml = key.substring(xmlIndex);
                return Report.compileXml(xml, style);
            }

            public String toString() {
                return "Report Cache";
            }
        };
        waitingThreads = 0;
        if (System.getSecurityManager() == null) {
            Report.clearTempCache();
        } else {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Report.clearTempCache();
                    return null;
                }
            });
        }
    }

    public static class ReportDataBindingException
    extends NeoException {
        public String msg;
        private Throwable rootException;

        public ReportDataBindingException(JRException e) {
            this.msg = e.getMessage();
            this.rootException = e.getCause();
        }

        public String getRootErrorMsg() {
            String ret = null;
            if (this.rootException != null) {
                ret = this.rootException.getMessage();
                if (this.rootException instanceof NeoException) {
                    ret = ret + ((NeoException)this.rootException).getDetail();
                }
            }
            return ret;
        }
    }

    public static class ExecutingSubReportQueryException
    extends NeoException {
        public String subReportName;

        public ExecutingSubReportQueryException(String subReportName, Throwable t) {
            super(t);
            this.subReportName = subReportName;
        }
    }

    public static class ExecutingReportQueryException
    extends NeoException {
        public ExecutingReportQueryException(Throwable t) {
            super(t);
        }
    }

    public static class ReportClassCastException
    extends NeoException {
    }

    public static class ReportCompilationException
    extends NeoException {
        public String msg;

        public ReportCompilationException(JRException e) {
            this.msg = e.getMessage();
        }
    }

    public static class ReportTemplateNonExistantException
    extends NeoException {
        public String template;

        public ReportTemplateNonExistantException(String temp) {
            this.template = temp;
        }
    }

    public static class ReportUnSupportedFormatException
    extends NeoException {
        public String msg;

        public ReportUnSupportedFormatException(String format) {
            this.msg = format;
        }
    }

    public static class ReportFormatException
    extends NeoException {
        public String msg;

        public ReportFormatException(Exception e) {
            this.msg = e.getMessage();
        }
    }
}

