/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import java.io.IOException;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.util.IOUtils;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.util.StrUtils;
import org.noggit.JSONParser;
import org.noggit.ObjectBuilder;

public class CommandOperation {
    public final String name;
    private Object commandData;
    private List<String> errors = new ArrayList<String>();
    static final String REQD = "''{0}'' is a required field";
    public static final String ERR_MSGS = "errorMessages";
    public static final String ROOT_OBJ = "";

    CommandOperation(String operationName, Object metaData) {
        this.commandData = metaData;
        this.name = operationName;
    }

    public String getStr(String key, String def) {
        if (ROOT_OBJ.equals(key)) {
            Object obj = this.getRootPrimitive();
            return obj == def ? null : String.valueOf(obj);
        }
        Object o = this.getMapVal(key);
        return o == null ? def : String.valueOf(o);
    }

    public Map<String, Object> getDataMap() {
        if (this.commandData instanceof Map) {
            return (Map)this.commandData;
        }
        this.addError(StrUtils.formatString((String)"The command ''{0}'' should have the values as a json object {key:val} format", (Object[])new Object[]{this.name}));
        return Collections.emptyMap();
    }

    private Object getRootPrimitive() {
        if (this.commandData instanceof Map) {
            this.errors.add(StrUtils.formatString((String)"The value has to be a string for command : ''{0}'' ", (Object[])new Object[]{this.name}));
            return null;
        }
        return this.commandData;
    }

    public Object getVal(String key) {
        return this.getMapVal(key);
    }

    private Object getMapVal(String key) {
        if (this.commandData instanceof Map) {
            Map metaData = (Map)this.commandData;
            return metaData.get(key);
        }
        String msg = " value has to be an object for operation :" + this.name;
        if (!this.errors.contains(msg)) {
            this.errors.add(msg);
        }
        return null;
    }

    public List<String> getStrs(String key) {
        List<String> val = this.getStrs(key, null);
        if (val == null) {
            this.errors.add(StrUtils.formatString((String)REQD, (Object[])new Object[]{key}));
        }
        return val;
    }

    public List<String> getStrs(String key, List<String> def) {
        Object v = null;
        v = ROOT_OBJ.equals(key) ? this.getRootPrimitive() : this.getMapVal(key);
        if (v == null) {
            return def;
        }
        if (v instanceof List) {
            ArrayList<String> l = new ArrayList<String>();
            for (Object o : (List)v) {
                l.add(String.valueOf(o));
            }
            if (l.isEmpty()) {
                return def;
            }
            return l;
        }
        return Collections.singletonList(String.valueOf(v));
    }

    public String getStr(String key) {
        if (ROOT_OBJ.equals(key)) {
            Object obj = this.getRootPrimitive();
            if (obj == null) {
                this.errors.add(StrUtils.formatString((String)REQD, (Object[])new Object[]{this.name}));
            }
            return obj == null ? null : String.valueOf(obj);
        }
        String s = this.getStr(key, null);
        if (s == null) {
            this.errors.add(StrUtils.formatString((String)REQD, (Object[])new Object[]{key}));
        }
        return s;
    }

    private Map errorDetails() {
        return ZkNodeProps.makeMap((Object[])new Object[]{this.name, this.commandData, ERR_MSGS, this.errors});
    }

    public boolean hasError() {
        return !this.errors.isEmpty();
    }

    public void addError(String s) {
        if (this.errors.contains(s)) {
            return;
        }
        this.errors.add(s);
    }

    public Map<String, Object> getValuesExcluding(String ... keys) {
        this.getMapVal(null);
        if (this.hasError()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Object> cp = new LinkedHashMap<String, Object>((Map)this.commandData);
        if (keys == null) {
            return cp;
        }
        for (String key : keys) {
            cp.remove(key);
        }
        return cp;
    }

    public List<String> getErrors() {
        return this.errors;
    }

    public static List<Map> captureErrors(List<CommandOperation> ops) {
        ArrayList<Map> errors = new ArrayList<Map>();
        for (CommandOperation op : ops) {
            if (!op.hasError()) continue;
            errors.add(op.errorDetails());
        }
        return errors;
    }

    public static List<CommandOperation> parse(Reader rdr) throws IOException {
        JSONParser parser = new JSONParser(rdr);
        ObjectBuilder ob = new ObjectBuilder(parser);
        if (parser.lastEvent() != 7) {
            throw new RuntimeException("The JSON must be an Object of the form {\"command\": {...},...");
        }
        ArrayList<CommandOperation> operations = new ArrayList<CommandOperation>();
        int ev;
        block0: while ((ev = parser.nextEvent()) != 8) {
            Object key = ob.getKey();
            ev = parser.nextEvent();
            Object val = ob.getVal();
            if (val instanceof List) {
                List list = (List)val;
                Iterator iterator = list.iterator();
                while (true) {
                    if (!iterator.hasNext()) continue block0;
                    Object o = iterator.next();
                    operations.add(new CommandOperation(String.valueOf(key), o));
                }
            }
            operations.add(new CommandOperation(String.valueOf(key), val));
        }
        return operations;
    }

    public CommandOperation getCopy() {
        return new CommandOperation(this.name, this.commandData);
    }

    public Map getMap(String key, Map def) {
        Object o = this.getMapVal(key);
        if (o == null) {
            return def;
        }
        if (!(o instanceof Map)) {
            this.addError(StrUtils.formatString((String)"''{0}'' must be a map", (Object[])new Object[]{key}));
            return def;
        }
        return (Map)o;
    }

    public String toString() {
        try {
            return new String(ZkStateReader.toJSON(Collections.singletonMap(this.name, this.commandData)), IOUtils.UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            return ROOT_OBJ;
        }
    }
}

