/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update.processor;

import java.io.IOException;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.update.CommitUpdateCommand;
import org.apache.solr.update.processor.IgnoreCommitOptimizeUpdateProcessorFactory;
import org.apache.solr.update.processor.UpdateRequestProcessor;

class IgnoreCommitOptimizeUpdateProcessor
extends UpdateRequestProcessor {
    private final SolrQueryResponse rsp;
    private final SolrException.ErrorCode errorCode;
    private final String responseMsg;
    private final boolean ignoreOptimizeOnly;

    IgnoreCommitOptimizeUpdateProcessor(SolrQueryResponse rsp, IgnoreCommitOptimizeUpdateProcessorFactory factory, UpdateRequestProcessor next) {
        super(next);
        this.rsp = rsp;
        this.errorCode = factory.errorCode;
        this.responseMsg = factory.responseMsg;
        this.ignoreOptimizeOnly = factory.ignoreOptimizeOnly;
    }

    @Override
    public void processCommit(CommitUpdateCommand cmd) throws IOException {
        String cmdType;
        if (this.ignoreOptimizeOnly && !cmd.optimize) {
            if (this.next != null) {
                this.next.processCommit(cmd);
            }
            return;
        }
        if (cmd.getReq().getParams().getBool("commit_end_point", false)) {
            if (this.next != null) {
                this.next.processCommit(cmd);
            }
            return;
        }
        String string = cmdType = cmd.optimize ? "optimize" : "commit";
        if (this.errorCode != null) {
            IgnoreCommitOptimizeUpdateProcessorFactory.log.info("{} from client application ignored with error code: {}", (Object)cmdType, (Object)this.errorCode.code);
            this.rsp.setException((Exception)((Object)new SolrException(this.errorCode, this.responseMsg)));
        } else {
            IgnoreCommitOptimizeUpdateProcessorFactory.log.info("{} from client application ignored with status code: 200", (Object)cmdType);
            if (this.responseMsg != null) {
                SimpleOrderedMap responseHeader = this.rsp.getResponseHeader();
                if (responseHeader != null) {
                    responseHeader.add("msg", (Object)this.responseMsg);
                } else {
                    responseHeader = new SimpleOrderedMap();
                    responseHeader.add("msg", (Object)this.responseMsg);
                    this.rsp.add("responseHeader", responseHeader);
                }
            }
        }
    }
}

