/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.store.hdfs;

import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.LockReleaseFailedException;
import org.apache.solr.common.util.IOUtils;
import org.apache.solr.store.hdfs.HdfsDirectory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HdfsLockFactory
extends LockFactory {
    public static Logger log = LoggerFactory.getLogger(HdfsLockFactory.class);
    public static final HdfsLockFactory INSTANCE = new HdfsLockFactory();

    private HdfsLockFactory() {
    }

    public Lock makeLock(Directory dir, String lockName) {
        if (!(dir instanceof HdfsDirectory)) {
            throw new UnsupportedOperationException("HdfsLockFactory can only be used with HdfsDirectory subclasses, got: " + dir);
        }
        HdfsDirectory hdfsDir = (HdfsDirectory)dir;
        return new HdfsLock(hdfsDir.getHdfsDirPath(), lockName, hdfsDir.getConfiguration());
    }

    static class HdfsLock
    extends Lock {
        private final Path lockPath;
        private final String lockName;
        private final Configuration conf;
        private boolean obtained;

        public HdfsLock(Path lockPath, String lockName, Configuration conf) {
            this.lockPath = lockPath;
            this.lockName = lockName;
            this.conf = conf;
        }

        /*
         * Exception decompiling
         */
        public boolean obtain() throws IOException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public void close() throws IOException {
            if (this.obtained) {
                FileSystem fs = FileSystem.get((URI)this.lockPath.toUri(), (Configuration)this.conf);
                try {
                    if (fs.exists(new Path(this.lockPath, this.lockName)) && !fs.delete(new Path(this.lockPath, this.lockName), false)) {
                        throw new LockReleaseFailedException("failed to delete " + new Path(this.lockPath, this.lockName));
                    }
                }
                finally {
                    this.obtained = false;
                    IOUtils.closeQuietly((Closeable)fs);
                }
            }
        }

        public boolean isLocked() throws IOException {
            boolean isLocked = false;
            FileSystem fs = FileSystem.get((URI)this.lockPath.toUri(), (Configuration)this.conf);
            try {
                isLocked = fs.exists(new Path(this.lockPath, this.lockName));
            }
            finally {
                IOUtils.closeQuietly((Closeable)fs);
            }
            return isLocked;
        }
    }
}

