/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.request;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.Semaphore;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.MultiPostingsEnum;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.FilterCollector;
import org.apache.lucene.search.FilteredQuery;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.grouping.AbstractAllGroupHeadsCollector;
import org.apache.lucene.search.grouping.AbstractGroupFacetCollector;
import org.apache.lucene.search.grouping.term.TermAllGroupsCollector;
import org.apache.lucene.search.grouping.term.TermGroupFacetCollector;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CharsRefBuilder;
import org.apache.lucene.util.StringHelper;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.FacetParams;
import org.apache.solr.common.params.RequiredSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.SpatialHeatmapFacets;
import org.apache.solr.request.DocValuesFacets;
import org.apache.solr.request.IntervalFacets;
import org.apache.solr.request.NumericFacets;
import org.apache.solr.request.PerSegmentSingleValuedFaceting;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.schema.BoolField;
import org.apache.solr.schema.DateRangeField;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.schema.TrieDateField;
import org.apache.solr.schema.TrieField;
import org.apache.solr.search.BitDocSet;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.Grouping;
import org.apache.solr.search.HashDocSet;
import org.apache.solr.search.Insanity;
import org.apache.solr.search.QParser;
import org.apache.solr.search.QueryParsing;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.SortedIntDocSet;
import org.apache.solr.search.SyntaxError;
import org.apache.solr.search.grouping.GroupingSpecification;
import org.apache.solr.util.BoundedTreeSet;
import org.apache.solr.util.DateMathParser;
import org.apache.solr.util.DefaultSolrThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleFacets {
    private static final Logger log = LoggerFactory.getLogger(SimpleFacets.class);
    protected DocSet docsOrig;
    protected final SolrParams orig;
    protected final SolrIndexSearcher searcher;
    protected final SolrQueryRequest req;
    protected final ResponseBuilder rb;
    protected SimpleOrderedMap<Object> facetResponse;
    protected SolrParams localParams;
    protected SolrParams params;
    protected SolrParams required;
    protected String facetValue;
    protected DocSet docs;
    protected String key;
    protected int threads;
    static final Executor directExecutor = new Executor(){

        @Override
        public void execute(Runnable r) {
            r.run();
        }
    };
    static final Executor facetExecutor = new ExecutorUtil.MDCAwareThreadPoolExecutor(0, Integer.MAX_VALUE, 10L, TimeUnit.SECONDS, new SynchronousQueue(), (ThreadFactory)new DefaultSolrThreadFactory("facetExecutor"));

    public SimpleFacets(SolrQueryRequest req, DocSet docs, SolrParams params) {
        this(req, docs, params, null);
    }

    public SimpleFacets(SolrQueryRequest req, DocSet docs, SolrParams params, ResponseBuilder rb) {
        this.req = req;
        this.searcher = req.getSearcher();
        this.docs = this.docsOrig = docs;
        this.params = this.orig = params;
        this.required = new RequiredSolrParams(params);
        this.rb = rb;
    }

    public static boolean contains(String ref, String substring, boolean ignoreCase) {
        if (ignoreCase) {
            return StringUtils.containsIgnoreCase((String)ref, (String)substring);
        }
        return StringUtils.contains((String)ref, (String)substring);
    }

    protected void parseParams(String type, String param) throws SyntaxError, IOException {
        String excludeStr;
        this.localParams = QueryParsing.getLocalParams(param, this.req.getParams());
        this.docs = this.docsOrig;
        this.facetValue = param;
        this.key = param;
        this.threads = -1;
        if (this.localParams == null) {
            this.params = this.orig;
            this.required = new RequiredSolrParams(this.params);
            return;
        }
        this.params = SolrParams.wrapDefaults((SolrParams)this.localParams, (SolrParams)this.orig);
        this.required = new RequiredSolrParams(this.params);
        if (type != "facet.query") {
            this.facetValue = this.localParams.get("v");
        }
        this.key = this.facetValue;
        this.key = this.localParams.get("key", this.key);
        String threadStr = this.localParams.get("threads");
        if (threadStr != null) {
            this.threads = Integer.parseInt(threadStr);
        }
        if ((excludeStr = this.localParams.get("ex")) == null) {
            return;
        }
        Map tagMap = (Map)this.req.getContext().get("tags");
        if (tagMap != null && this.rb != null) {
            List excludeTagList = StrUtils.splitSmart((String)excludeStr, (char)',');
            IdentityHashMap<Query, Boolean> excludeSet = new IdentityHashMap<Query, Boolean>();
            for (Object excludeTag : excludeTagList) {
                Object olst = tagMap.get(excludeTag);
                if (!(olst instanceof Collection)) continue;
                for (Object o : (Collection)olst) {
                    if (!(o instanceof QParser)) continue;
                    QParser qp = (QParser)o;
                    excludeSet.put(qp.getQuery(), Boolean.TRUE);
                }
            }
            if (excludeSet.size() == 0) {
                return;
            }
            ArrayList<Query> qlist = new ArrayList<Query>();
            if (!excludeSet.containsKey(this.rb.getQuery())) {
                qlist.add(this.rb.getQuery());
            }
            if (this.rb.getFilters() != null) {
                for (Query q : this.rb.getFilters()) {
                    if (excludeSet.containsKey(q)) continue;
                    qlist.add(q);
                }
            }
            DocSet base = this.searcher.getDocSet(qlist);
            if (this.rb.grouping() && this.rb.getGroupingSpec().isTruncateGroups()) {
                Grouping grouping = new Grouping(this.searcher, null, this.rb.getQueryCommand(), false, 0, false);
                grouping.setGroupSort(this.rb.getGroupingSpec().getSortWithinGroup());
                if (this.rb.getGroupingSpec().getFields().length > 0) {
                    grouping.addFieldCommand(this.rb.getGroupingSpec().getFields()[0], this.req);
                } else if (this.rb.getGroupingSpec().getFunctions().length > 0) {
                    grouping.addFunctionCommand(this.rb.getGroupingSpec().getFunctions()[0], this.req);
                } else {
                    this.docs = base;
                    return;
                }
                AbstractAllGroupHeadsCollector<?> allGroupHeadsCollector = grouping.getCommands().get(0).createAllGroupCollector();
                this.searcher.search((Query)new FilteredQuery((Query)new MatchAllDocsQuery(), base.getTopFilter()), (Collector)allGroupHeadsCollector);
                this.docs = new BitDocSet(allGroupHeadsCollector.retrieveGroupHeads(this.searcher.maxDoc()));
            } else {
                this.docs = base;
            }
        }
    }

    public NamedList<Object> getFacetCounts() {
        if (!this.params.getBool("facet", true)) {
            return null;
        }
        this.facetResponse = new SimpleOrderedMap();
        try {
            this.facetResponse.add("facet_queries", this.getFacetQueryCounts());
            this.facetResponse.add("facet_fields", this.getFacetFieldCounts());
            this.facetResponse.add("facet_dates", this.getFacetDateCounts());
            this.facetResponse.add("facet_ranges", this.getFacetRangeCounts());
            this.facetResponse.add("facet_intervals", this.getFacetIntervalCounts());
            this.facetResponse.add("facet_heatmaps", (Object)this.getHeatmapCounts());
        }
        catch (IOException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
        catch (SyntaxError e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)e);
        }
        return this.facetResponse;
    }

    public NamedList<Integer> getFacetQueryCounts() throws IOException, SyntaxError {
        SimpleOrderedMap res = new SimpleOrderedMap();
        String[] facetQs = this.params.getParams("facet.query");
        if (null != facetQs && 0 != facetQs.length) {
            for (String q : facetQs) {
                this.parseParams("facet.query", q);
                Query qobj = QParser.getParser(q, null, this.req).getQuery();
                if (qobj == null) {
                    res.add(this.key, (Object)0);
                    continue;
                }
                if (this.params.getBool("group.facet", false)) {
                    res.add(this.key, (Object)this.getGroupedFacetQueryCount(qobj));
                    continue;
                }
                res.add(this.key, (Object)this.searcher.numDocs(qobj, this.docs));
            }
        }
        return res;
    }

    public int getGroupedFacetQueryCount(Query facetQuery) throws IOException {
        String groupField = this.params.get("group.field");
        if (groupField == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Specify the group.field as parameter or local parameter");
        }
        TermAllGroupsCollector collector = new TermAllGroupsCollector(groupField);
        Filter mainQueryFilter = this.docs.getTopFilter();
        this.searcher.search((Query)new FilteredQuery(facetQuery, mainQueryFilter), (Collector)collector);
        return collector.getGroupCount();
    }

    public NamedList<Integer> getTermCountsForPivots(String field, DocSet docs) throws IOException {
        Integer mincount = this.params.getFieldInt(field, "facet.pivot.mincount", 1);
        return this.getTermCounts(field, mincount, docs);
    }

    public NamedList<Integer> getTermCounts(String field) throws IOException {
        return this.getTermCounts(field, this.docs);
    }

    public NamedList<Integer> getTermCounts(String field, DocSet base) throws IOException {
        Integer mincount = this.params.getFieldInt(field, "facet.mincount");
        return this.getTermCounts(field, mincount, base);
    }

    private NamedList<Integer> getTermCounts(String field, Integer mincount, DocSet base) throws IOException {
        NamedList<Integer> counts;
        boolean multiToken;
        int offset = this.params.getFieldInt(field, "facet.offset", 0);
        int limit = this.params.getFieldInt(field, "facet.limit", 100);
        if (limit == 0) {
            return new NamedList();
        }
        if (mincount == null) {
            Boolean zeros = this.params.getFieldBool(field, "facet.zeros");
            mincount = zeros != null && zeros == false ? 1 : 0;
        }
        boolean missing = this.params.getFieldBool(field, "facet.missing", false);
        String sort = this.params.getFieldParam(field, "facet.sort", limit > 0 ? "count" : "index");
        String prefix = this.params.getFieldParam(field, "facet.prefix");
        String contains = this.params.getFieldParam(field, "facet.contains");
        boolean ignoreCase = this.params.getFieldBool(field, "facet.contains.ignoreCase", false);
        SchemaField sf = this.searcher.getSchema().getField(field);
        FieldType ft = sf.getType();
        String methodStr = this.params.getFieldParam(field, "facet.method");
        FacetMethod method = null;
        if ("enum".equals(methodStr)) {
            method = FacetMethod.ENUM;
        } else if ("fcs".equals(methodStr)) {
            method = FacetMethod.FCS;
        } else if ("fc".equals(methodStr)) {
            method = FacetMethod.FC;
        }
        if (method == FacetMethod.ENUM && TrieField.getMainValuePrefix(ft) != null) {
            FacetMethod facetMethod = method = sf.multiValued() ? FacetMethod.FC : FacetMethod.FCS;
        }
        if (method == null && ft instanceof BoolField) {
            method = FacetMethod.ENUM;
        }
        boolean bl = multiToken = sf.multiValued() || ft.multiValuedFieldCache();
        if (ft.getNumericType() != null && !sf.multiValued()) {
            method = FacetMethod.FCS;
        }
        if (method == null) {
            method = FacetMethod.FC;
        }
        if (method == FacetMethod.FCS && multiToken) {
            method = FacetMethod.FC;
        }
        if (method == FacetMethod.ENUM && sf.hasDocValues()) {
            method = FacetMethod.FC;
        }
        if (this.params.getFieldBool(field, "group.facet", false)) {
            counts = this.getGroupedCounts(this.searcher, base, field, multiToken, offset, limit, mincount, missing, sort, prefix, contains, ignoreCase);
        } else {
            assert (method != null);
            switch (method) {
                case ENUM: {
                    assert (TrieField.getMainValuePrefix(ft) == null);
                    counts = this.getFacetTermEnumCounts(this.searcher, base, field, offset, limit, mincount, missing, sort, prefix, contains, ignoreCase);
                    break;
                }
                case FCS: {
                    assert (!multiToken);
                    if (ft.getNumericType() != null && !sf.multiValued()) {
                        if (prefix != null && !prefix.isEmpty()) {
                            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "facet.prefix is not supported on numeric types");
                        }
                        if (contains != null && !contains.isEmpty()) {
                            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "facet.contains is not supported on numeric types");
                        }
                        counts = NumericFacets.getCounts(this.searcher, base, field, offset, limit, mincount, missing, sort);
                        break;
                    }
                    PerSegmentSingleValuedFaceting ps = new PerSegmentSingleValuedFaceting(this.searcher, base, field, offset, limit, mincount, missing, sort, prefix, contains, ignoreCase);
                    Executor executor = this.threads == 0 ? directExecutor : facetExecutor;
                    ps.setNumThreads(this.threads);
                    counts = ps.getFacetCounts(executor);
                    break;
                }
                case FC: {
                    counts = DocValuesFacets.getCounts(this.searcher, base, field, offset, limit, mincount, missing, sort, prefix, contains, ignoreCase);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
        return counts;
    }

    public NamedList<Integer> getGroupedCounts(SolrIndexSearcher searcher, DocSet base, String field, boolean multiToken, int offset, int limit, int mincount, boolean missing, String sort, String prefix, String contains, boolean ignoreCase) throws IOException {
        String groupField;
        GroupingSpecification groupingSpecification = this.rb.getGroupingSpec();
        String string = groupField = groupingSpecification != null ? groupingSpecification.getFields()[0] : null;
        if (groupField == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Specify the group.field as parameter or local parameter");
        }
        BytesRef prefixBytesRef = prefix != null ? new BytesRef((CharSequence)prefix) : null;
        TermGroupFacetCollector collector = TermGroupFacetCollector.createTermGroupFacetCollector((String)groupField, (String)field, (boolean)multiToken, (BytesRef)prefixBytesRef, (int)128);
        SchemaField sf = searcher.getSchema().getFieldOrNull(groupField);
        if (sf != null && !sf.hasDocValues() && !sf.multiValued() && sf.getType().getNumericType() != null) {
            searcher.search((Query)new FilteredQuery((Query)new MatchAllDocsQuery(), base.getTopFilter()), (Collector)new FilterCollector((Collector)collector){

                public LeafCollector getLeafCollector(LeafReaderContext context) throws IOException {
                    LeafReader insane = Insanity.wrapInsanity(context.reader(), groupField);
                    return this.in.getLeafCollector(insane.getContext());
                }
            });
        } else {
            searcher.search((Query)new FilteredQuery((Query)new MatchAllDocsQuery(), base.getTopFilter()), (Collector)collector);
        }
        boolean orderByCount = sort.equals("count") || sort.equals("true");
        AbstractGroupFacetCollector.GroupedFacetResult result = collector.mergeSegmentResults(limit < 0 ? Integer.MAX_VALUE : offset + limit, mincount, orderByCount);
        CharsRefBuilder charsRef = new CharsRefBuilder();
        FieldType facetFieldType = searcher.getSchema().getFieldType(field);
        NamedList facetCounts = new NamedList();
        List scopedEntries = result.getFacetEntries(offset, limit < 0 ? Integer.MAX_VALUE : limit);
        for (AbstractGroupFacetCollector.FacetEntry facetEntry : scopedEntries) {
            if (contains != null && !SimpleFacets.contains(facetEntry.getValue().utf8ToString(), contains, ignoreCase)) continue;
            facetFieldType.indexedToReadable(facetEntry.getValue(), charsRef);
            facetCounts.add(charsRef.toString(), (Object)facetEntry.getCount());
        }
        if (missing) {
            facetCounts.add(null, (Object)result.getTotalMissingCount());
        }
        return facetCounts;
    }

    public NamedList<Object> getFacetFieldCounts() throws IOException, SyntaxError {
        SimpleOrderedMap res = new SimpleOrderedMap();
        String[] facetFs = this.params.getParams("facet.field");
        if (null == facetFs) {
            return res;
        }
        int maxThreads = this.req.getParams().getInt("facet.threads", 0);
        Executor executor = maxThreads == 0 ? directExecutor : facetExecutor;
        final Semaphore semaphore = new Semaphore(maxThreads <= 0 ? Integer.MAX_VALUE : maxThreads);
        ArrayList<FutureTask<NamedList>> futures = new ArrayList<FutureTask<NamedList>>(facetFs.length);
        try {
            for (String f : facetFs) {
                this.parseParams("facet.field", f);
                final String termList = this.localParams == null ? null : this.localParams.get("terms");
                final String workerKey = this.key;
                final String workerFacetValue = this.facetValue;
                final DocSet workerBase = this.docs;
                Callable<NamedList> callable = new Callable<NamedList>(){

                    @Override
                    public NamedList call() throws Exception {
                        try {
                            SimpleOrderedMap result = new SimpleOrderedMap();
                            if (termList != null) {
                                List terms = StrUtils.splitSmart((String)termList, (String)",", (boolean)true);
                                result.add(workerKey, SimpleFacets.this.getListedTermCounts(workerFacetValue, workerBase, terms));
                            } else {
                                result.add(workerKey, SimpleFacets.this.getTermCounts(workerFacetValue, workerBase));
                            }
                            SimpleOrderedMap simpleOrderedMap = result;
                            return simpleOrderedMap;
                        }
                        catch (SolrException se) {
                            throw se;
                        }
                        catch (Exception e) {
                            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Exception during facet.field: " + workerFacetValue, (Throwable)e);
                        }
                        finally {
                            semaphore.release();
                        }
                    }
                };
                FutureTask<NamedList> runnableFuture = new FutureTask<NamedList>(callable);
                semaphore.acquire();
                executor.execute(runnableFuture);
                futures.add(runnableFuture);
            }
            for (Future future : futures) {
                res.addAll((NamedList)future.get());
            }
            assert (semaphore.availablePermits() >= maxThreads);
        }
        catch (InterruptedException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error while processing facet fields: InterruptedException", (Throwable)e);
        }
        catch (ExecutionException ee) {
            Throwable throwable = ee.getCause();
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error while processing facet fields: " + throwable.toString(), throwable);
        }
        return res;
    }

    private NamedList<Integer> getListedTermCounts(String field, String termList) throws IOException {
        List terms = StrUtils.splitSmart((String)termList, (String)",", (boolean)true);
        return this.getListedTermCounts(field, this.docs, terms);
    }

    protected NamedList<Integer> getListedTermCounts(String field, DocSet base, List<String> terms) throws IOException {
        FieldType ft = this.searcher.getSchema().getFieldType(field);
        NamedList res = new NamedList();
        for (String term : terms) {
            String internal = ft.toInternal(term);
            int count = this.searcher.numDocs((Query)new TermQuery(new Term(field, internal)), base);
            res.add(term, (Object)count);
        }
        return res;
    }

    public static int getFieldMissingCount(SolrIndexSearcher searcher, DocSet docs, String fieldName) throws IOException {
        SchemaField sf = searcher.getSchema().getField(fieldName);
        DocSet hasVal = searcher.getDocSet(sf.getType().getRangeQuery(null, sf, null, null, false, false));
        return docs.andNotSize(hasVal);
    }

    public NamedList<Integer> getFacetTermEnumCounts(SolrIndexSearcher searcher, DocSet docs, String field, int offset, int limit, int mincount, boolean missing, String sort, String prefix, String contains, boolean ignoreCase) throws IOException {
        Fields fields;
        int minDfFilterCache = this.params.getFieldInt(field, "facet.enum.cache.minDf", 0);
        DocSet fastForRandomSet = docs;
        if (minDfFilterCache > 0 && docs instanceof SortedIntDocSet) {
            SortedIntDocSet sset = (SortedIntDocSet)docs;
            fastForRandomSet = new HashDocSet(sset.getDocs(), 0, sset.size());
        }
        IndexSchema schema = searcher.getSchema();
        LeafReader r = searcher.getLeafReader();
        FieldType ft = schema.getFieldType(field);
        boolean sortByCount = sort.equals("count") || sort.equals("true");
        int maxsize = limit >= 0 ? offset + limit : 0x7FFFFFFE;
        BoundedTreeSet<CountPair<BytesRef, Integer>> queue = sortByCount ? new BoundedTreeSet<CountPair<BytesRef, Integer>>(maxsize) : null;
        NamedList res = new NamedList();
        int min = mincount - 1;
        int off = offset;
        int lim = limit >= 0 ? limit : Integer.MAX_VALUE;
        BytesRef prefixTermBytes = null;
        if (prefix != null) {
            String indexedPrefix = ft.toInternal(prefix);
            prefixTermBytes = new BytesRef((CharSequence)indexedPrefix);
        }
        Terms terms = (fields = r.fields()) == null ? null : fields.terms(field);
        TermsEnum termsEnum = null;
        SolrIndexSearcher.DocsEnumState deState = null;
        BytesRef term = null;
        if (terms != null) {
            termsEnum = terms.iterator();
            if (prefixTermBytes != null) {
                if (termsEnum.seekCeil(prefixTermBytes) == TermsEnum.SeekStatus.END) {
                    termsEnum = null;
                } else {
                    term = termsEnum.term();
                }
            } else {
                term = termsEnum.next();
            }
        }
        PostingsEnum postingsEnum = null;
        CharsRefBuilder charsRef = new CharsRefBuilder();
        if (docs.size() >= mincount) {
            while (term != null && (prefixTermBytes == null || StringHelper.startsWith((BytesRef)term, (BytesRef)prefixTermBytes))) {
                int df;
                if ((contains == null || SimpleFacets.contains(term.utf8ToString(), contains, ignoreCase)) && (df = termsEnum.docFreq()) > 0 && df > min) {
                    int n;
                    if (df >= minDfFilterCache) {
                        if (deState == null) {
                            deState = new SolrIndexSearcher.DocsEnumState();
                            deState.fieldName = field;
                            deState.liveDocs = r.getLiveDocs();
                            deState.termsEnum = termsEnum;
                            deState.postingsEnum = postingsEnum;
                        }
                        n = searcher.numDocs(docs, deState);
                        postingsEnum = deState.postingsEnum;
                    } else {
                        postingsEnum = termsEnum.postings(null, postingsEnum, 0);
                        n = 0;
                        if (postingsEnum instanceof MultiPostingsEnum) {
                            MultiPostingsEnum.EnumWithSlice[] subs = ((MultiPostingsEnum)postingsEnum).getSubs();
                            int numSubs = ((MultiPostingsEnum)postingsEnum).getNumSubs();
                            for (int subindex = 0; subindex < numSubs; ++subindex) {
                                int docid;
                                MultiPostingsEnum.EnumWithSlice sub = subs[subindex];
                                if (sub.postingsEnum == null) continue;
                                int base = sub.slice.start;
                                while ((docid = sub.postingsEnum.nextDoc()) != Integer.MAX_VALUE) {
                                    if (!fastForRandomSet.exists(docid + base)) continue;
                                    ++n;
                                }
                            }
                        } else {
                            int docid;
                            while ((docid = postingsEnum.nextDoc()) != Integer.MAX_VALUE) {
                                if (!fastForRandomSet.exists(docid)) continue;
                                ++n;
                            }
                        }
                    }
                    if (sortByCount) {
                        if (n > min) {
                            BytesRef termCopy = BytesRef.deepCopyOf((BytesRef)term);
                            queue.add(new CountPair<BytesRef, Integer>(termCopy, n));
                            if (queue.size() >= maxsize) {
                                min = (Integer)((CountPair)queue.last()).val;
                            }
                        }
                    } else if (n >= mincount && --off < 0) {
                        if (--lim < 0) break;
                        ft.indexedToReadable(term, charsRef);
                        res.add(charsRef.toString(), (Object)n);
                    }
                }
                term = termsEnum.next();
            }
        }
        if (sortByCount) {
            for (CountPair countPair : queue) {
                if (--off >= 0) continue;
                if (--lim < 0) break;
                ft.indexedToReadable((BytesRef)countPair.key, charsRef);
                res.add(charsRef.toString(), countPair.val);
            }
        }
        if (missing) {
            res.add(null, (Object)SimpleFacets.getFieldMissingCount(searcher, docs, field));
        }
        return res;
    }

    @Deprecated
    public NamedList<Object> getFacetDateCounts() throws IOException, SyntaxError {
        SimpleOrderedMap resOuter = new SimpleOrderedMap();
        String[] fields = this.params.getParams("facet.date");
        if (null == fields || 0 == fields.length) {
            return resOuter;
        }
        for (String f : fields) {
            this.getFacetDateCounts(f, (NamedList<Object>)resOuter);
        }
        return resOuter;
    }

    @Deprecated
    public void getFacetDateCounts(String dateFacet, NamedList<Object> resOuter) throws IOException, SyntaxError {
        Date end;
        String[] start;
        IndexSchema schema = this.searcher.getSchema();
        this.parseParams("facet.date", dateFacet);
        String f = this.facetValue;
        SimpleOrderedMap resInner = new SimpleOrderedMap();
        resOuter.add(this.key, (Object)resInner);
        SchemaField sf = schema.getField(f);
        if (!(sf.getType() instanceof TrieDateField)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Can not date facet on a field which is not a TrieDateField: " + f);
        }
        TrieDateField ft = (TrieDateField)sf.getType();
        String startS = this.required.getFieldParam(f, "facet.date.start");
        try {
            start = ft.parseMath(null, startS);
        }
        catch (SolrException e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "date facet 'start' is not a valid Date string: " + startS, (Throwable)e);
        }
        String endS = this.required.getFieldParam(f, "facet.date.end");
        try {
            end = ft.parseMath(null, endS);
        }
        catch (SolrException e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "date facet 'end' is not a valid Date string: " + endS, (Throwable)e);
        }
        if (end.before((Date)start)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "date facet 'end' comes before 'start': " + endS + " < " + startS);
        }
        String gap = this.required.getFieldParam(f, "facet.date.gap");
        DateMathParser dmp = new DateMathParser();
        int minCount = this.params.getFieldInt(f, "facet.mincount", 0);
        String[] iStrs = this.params.getFieldParams(f, "facet.date.include");
        EnumSet include = null == iStrs || 0 == iStrs.length ? EnumSet.of(FacetParams.FacetRangeInclude.LOWER, FacetParams.FacetRangeInclude.UPPER, FacetParams.FacetRangeInclude.EDGE) : FacetParams.FacetRangeInclude.parseParam((String[])iStrs);
        try {
            String[] low = start;
            while (low.before(end)) {
                boolean includeUpper;
                dmp.setNow((Date)low);
                String label = ft.toExternal((Date)low);
                String[] high = dmp.parseMath(gap);
                if (end.before((Date)high)) {
                    if (this.params.getFieldBool(f, "facet.date.hardend", false)) {
                        high = end;
                    } else {
                        end = high;
                    }
                }
                if (high.before((Date)low)) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "date facet infinite loop (is gap negative?)");
                }
                if (high.equals(low)) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "date facet infinite loop: gap is effectively zero");
                }
                boolean includeLower = include.contains(FacetParams.FacetRangeInclude.LOWER) || include.contains(FacetParams.FacetRangeInclude.EDGE) && low.equals(start);
                int count = this.rangeCount(sf, (Date)low, (Date)high, includeLower, includeUpper = include.contains(FacetParams.FacetRangeInclude.UPPER) || include.contains(FacetParams.FacetRangeInclude.EDGE) && high.equals(end));
                if (count >= minCount) {
                    resInner.add(label, (Object)count);
                }
                low = high;
            }
        }
        catch (ParseException e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "date facet 'gap' is not a valid Date Math string: " + gap, (Throwable)e);
        }
        resInner.add("gap", (Object)gap);
        resInner.add("start", (Object)start);
        resInner.add("end", (Object)end);
        String[] othersP = this.params.getFieldParams(f, "facet.date.other");
        if (null != othersP && 0 < othersP.length) {
            EnumSet<FacetParams.FacetRangeOther> others = EnumSet.noneOf(FacetParams.FacetRangeOther.class);
            for (String o : othersP) {
                others.add(FacetParams.FacetRangeOther.get((String)o));
            }
            if (!others.contains(FacetParams.FacetRangeOther.NONE)) {
                boolean all = others.contains(FacetParams.FacetRangeOther.ALL);
                if (all || others.contains(FacetParams.FacetRangeOther.BEFORE)) {
                    resInner.add(FacetParams.FacetRangeOther.BEFORE.toString(), (Object)this.rangeCount(sf, null, (Date)start, false, include.contains(FacetParams.FacetRangeInclude.OUTER) || !include.contains(FacetParams.FacetRangeInclude.LOWER) && !include.contains(FacetParams.FacetRangeInclude.EDGE)));
                }
                if (all || others.contains(FacetParams.FacetRangeOther.AFTER)) {
                    resInner.add(FacetParams.FacetRangeOther.AFTER.toString(), (Object)this.rangeCount(sf, end, null, include.contains(FacetParams.FacetRangeInclude.OUTER) || !include.contains(FacetParams.FacetRangeInclude.UPPER) && !include.contains(FacetParams.FacetRangeInclude.EDGE), false));
                }
                if (all || others.contains(FacetParams.FacetRangeOther.BETWEEN)) {
                    resInner.add(FacetParams.FacetRangeOther.BETWEEN.toString(), (Object)this.rangeCount(sf, (Date)start, end, include.contains(FacetParams.FacetRangeInclude.LOWER) || include.contains(FacetParams.FacetRangeInclude.EDGE), include.contains(FacetParams.FacetRangeInclude.UPPER) || include.contains(FacetParams.FacetRangeInclude.EDGE)));
                }
            }
        }
    }

    public NamedList<Object> getFacetRangeCounts() throws IOException, SyntaxError {
        SimpleOrderedMap resOuter = new SimpleOrderedMap();
        String[] fields = this.params.getParams("facet.range");
        if (null == fields || 0 == fields.length) {
            return resOuter;
        }
        for (String f : fields) {
            this.getFacetRangeCounts(f, (NamedList<Object>)resOuter);
        }
        return resOuter;
    }

    void getFacetRangeCounts(String facetRange, NamedList<Object> resOuter) throws IOException, SyntaxError {
        IndexSchema schema = this.searcher.getSchema();
        this.parseParams("facet.range", facetRange);
        String f = this.facetValue;
        String methodStr = this.params.get("facet.range.method");
        FacetParams.FacetRangeMethod method = methodStr == null ? FacetParams.FacetRangeMethod.getDefault() : FacetParams.FacetRangeMethod.get((String)methodStr);
        boolean groupFacet = this.params.getBool("group.facet", false);
        if (groupFacet && method.equals((Object)FacetParams.FacetRangeMethod.DV)) {
            log.warn("Range facet method '" + FacetParams.FacetRangeMethod.DV + "' is not supported together with '" + "group.facet" + "'. Will use method '" + FacetParams.FacetRangeMethod.FILTER + "' instead");
            method = FacetParams.FacetRangeMethod.FILTER;
        }
        SchemaField sf = schema.getField(f);
        FieldType ft = sf.getType();
        RangeEndpointCalculator calc = null;
        if (ft instanceof TrieField) {
            TrieField trie = (TrieField)ft;
            switch (trie.getType()) {
                case FLOAT: {
                    calc = new FloatRangeEndpointCalculator(sf);
                    break;
                }
                case DOUBLE: {
                    calc = new DoubleRangeEndpointCalculator(sf);
                    break;
                }
                case INTEGER: {
                    calc = new IntegerRangeEndpointCalculator(sf);
                    break;
                }
                case LONG: {
                    calc = new LongRangeEndpointCalculator(sf);
                    break;
                }
                case DATE: {
                    calc = new DateRangeEndpointCalculator(sf, null);
                    break;
                }
                default: {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unable to range facet on tried field of unexpected type:" + f);
                }
            }
        } else if (ft instanceof DateRangeField) {
            calc = new DateRangeFieldEndpointCalculator(sf, null);
            if (method.equals((Object)FacetParams.FacetRangeMethod.DV)) {
                log.warn("Range facet method '" + FacetParams.FacetRangeMethod.DV + "' is not supported together with field type '" + DateRangeField.class + "'. Will use method '" + FacetParams.FacetRangeMethod.FILTER + "' instead");
                method = FacetParams.FacetRangeMethod.FILTER;
            }
        } else {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unable to range facet on field:" + sf);
        }
        if (method.equals((Object)FacetParams.FacetRangeMethod.DV)) {
            assert (ft instanceof TrieField);
            resOuter.add(this.key, this.getFacetRangeCountsDocValues(sf, calc));
        } else {
            resOuter.add(this.key, this.getFacetRangeCounts(sf, calc));
        }
    }

    private <T extends Comparable<T>> NamedList<Object> getFacetRangeCounts(SchemaField sf, RangeEndpointCalculator<T> calc) throws IOException {
        String f = sf.getName();
        SimpleOrderedMap res = new SimpleOrderedMap();
        NamedList counts = new NamedList();
        res.add("counts", (Object)counts);
        T start = calc.getValue(this.required.getFieldParam(f, "facet.range.start"));
        T end = calc.getValue(this.required.getFieldParam(f, "facet.range.end"));
        if (end.compareTo(start) < 0) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "range facet 'end' comes before 'start': " + end + " < " + start);
        }
        String gap = this.required.getFieldParam(f, "facet.range.gap");
        res.add("gap", calc.getGap(gap));
        int minCount = this.params.getFieldInt(f, "facet.mincount", 0);
        EnumSet include = FacetParams.FacetRangeInclude.parseParam((String[])this.params.getFieldParams(f, "facet.range.include"));
        T low = start;
        while (low.compareTo(end) < 0) {
            String highS;
            T high = calc.addGap(low, gap);
            if (end.compareTo(high) < 0) {
                if (this.params.getFieldBool(f, "facet.range.hardend", false)) {
                    high = end;
                } else {
                    end = high;
                }
            }
            if (high.compareTo(low) < 0) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "range facet infinite loop (is gap negative? did the math overflow?)");
            }
            if (high.compareTo(low) == 0) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "range facet infinite loop: gap is either zero, or too small relative start/end and caused underflow: " + low + " + " + gap + " = " + high);
            }
            boolean includeLower = include.contains(FacetParams.FacetRangeInclude.LOWER) || include.contains(FacetParams.FacetRangeInclude.EDGE) && 0 == low.compareTo(start);
            boolean includeUpper = include.contains(FacetParams.FacetRangeInclude.UPPER) || include.contains(FacetParams.FacetRangeInclude.EDGE) && 0 == high.compareTo(end);
            String lowS = calc.formatValue(low);
            int count = this.rangeCount(sf, lowS, highS = calc.formatValue(high), includeLower, includeUpper);
            if (count >= minCount) {
                counts.add(lowS, (Object)count);
            }
            low = high;
        }
        res.add("start", start);
        res.add("end", end);
        String[] othersP = this.params.getFieldParams(f, "facet.range.other");
        if (null != othersP && 0 < othersP.length) {
            EnumSet<FacetParams.FacetRangeOther> others = EnumSet.noneOf(FacetParams.FacetRangeOther.class);
            for (String o : othersP) {
                others.add(FacetParams.FacetRangeOther.get((String)o));
            }
            if (!others.contains(FacetParams.FacetRangeOther.NONE)) {
                boolean all = others.contains(FacetParams.FacetRangeOther.ALL);
                String startS = calc.formatValue(start);
                String endS = calc.formatValue(end);
                if (all || others.contains(FacetParams.FacetRangeOther.BEFORE)) {
                    res.add(FacetParams.FacetRangeOther.BEFORE.toString(), (Object)this.rangeCount(sf, null, startS, false, include.contains(FacetParams.FacetRangeInclude.OUTER) || !include.contains(FacetParams.FacetRangeInclude.LOWER) && !include.contains(FacetParams.FacetRangeInclude.EDGE)));
                }
                if (all || others.contains(FacetParams.FacetRangeOther.AFTER)) {
                    res.add(FacetParams.FacetRangeOther.AFTER.toString(), (Object)this.rangeCount(sf, endS, null, include.contains(FacetParams.FacetRangeInclude.OUTER) || !include.contains(FacetParams.FacetRangeInclude.UPPER) && !include.contains(FacetParams.FacetRangeInclude.EDGE), false));
                }
                if (all || others.contains(FacetParams.FacetRangeOther.BETWEEN)) {
                    res.add(FacetParams.FacetRangeOther.BETWEEN.toString(), (Object)this.rangeCount(sf, startS, endS, include.contains(FacetParams.FacetRangeInclude.LOWER) || include.contains(FacetParams.FacetRangeInclude.EDGE), include.contains(FacetParams.FacetRangeInclude.UPPER) || include.contains(FacetParams.FacetRangeInclude.EDGE)));
                }
            }
        }
        return res;
    }

    private <T extends Comparable<T>> NamedList<Object> getFacetRangeCountsDocValues(SchemaField sf, RangeEndpointCalculator<T> calc) throws IOException {
        String f = sf.getName();
        SimpleOrderedMap res = new SimpleOrderedMap();
        NamedList counts = new NamedList();
        res.add("counts", (Object)counts);
        String globalStartS = this.required.getFieldParam(f, "facet.range.start");
        String globalEndS = this.required.getFieldParam(f, "facet.range.end");
        T start = calc.getValue(globalStartS);
        T end = calc.getValue(globalEndS);
        if (end.compareTo(start) < 0) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "range facet 'end' comes before 'start': " + end + " < " + start);
        }
        String gap = this.required.getFieldParam(f, "facet.range.gap");
        res.add("gap", calc.getGap(gap));
        int minCount = this.params.getFieldInt(f, "facet.mincount", 0);
        EnumSet include = FacetParams.FacetRangeInclude.parseParam((String[])this.params.getFieldParams(f, "facet.range.include"));
        ArrayList<IntervalFacets.FacetInterval> intervals = new ArrayList<IntervalFacets.FacetInterval>();
        String[] othersP = this.params.getFieldParams(f, "facet.range.other");
        boolean includeBefore = false;
        boolean includeBetween = false;
        boolean includeAfter = false;
        if (othersP != null && othersP.length > 0) {
            EnumSet<FacetParams.FacetRangeOther> others = EnumSet.noneOf(FacetParams.FacetRangeOther.class);
            for (String o : othersP) {
                others.add(FacetParams.FacetRangeOther.get((String)o));
            }
            if (!others.contains(FacetParams.FacetRangeOther.NONE)) {
                if (others.contains(FacetParams.FacetRangeOther.ALL) || others.contains(FacetParams.FacetRangeOther.BEFORE)) {
                    intervals.add(null);
                    includeBefore = true;
                }
                if (others.contains(FacetParams.FacetRangeOther.ALL) || others.contains(FacetParams.FacetRangeOther.BETWEEN)) {
                    intervals.add(null);
                    includeBetween = true;
                }
                if (others.contains(FacetParams.FacetRangeOther.ALL) || others.contains(FacetParams.FacetRangeOther.AFTER)) {
                    includeAfter = true;
                }
            }
        }
        T low = start;
        while (low.compareTo(end) < 0) {
            T high = calc.addGap(low, gap);
            if (end.compareTo(high) < 0) {
                if (this.params.getFieldBool(f, "facet.range.hardend", false)) {
                    high = end;
                } else {
                    end = high;
                }
            }
            if (high.compareTo(low) < 0) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "range facet infinite loop (is gap negative? did the math overflow?)");
            }
            if (high.compareTo(low) == 0) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "range facet infinite loop: gap is either zero, or too small relative start/end and caused underflow: " + low + " + " + gap + " = " + high);
            }
            boolean includeLower = include.contains(FacetParams.FacetRangeInclude.LOWER) || include.contains(FacetParams.FacetRangeInclude.EDGE) && 0 == low.compareTo(start);
            boolean includeUpper = include.contains(FacetParams.FacetRangeInclude.UPPER) || include.contains(FacetParams.FacetRangeInclude.EDGE) && 0 == high.compareTo(end);
            String lowS = calc.formatValue(low);
            String highS = calc.formatValue(high);
            intervals.add(new IntervalFacets.FacetInterval(sf, lowS, highS, includeLower, includeUpper, lowS));
            low = high;
        }
        if (includeBefore) {
            intervals.set(0, new IntervalFacets.FacetInterval(sf, "*", globalStartS, true, include.contains(FacetParams.FacetRangeInclude.OUTER) || !include.contains(FacetParams.FacetRangeInclude.LOWER) && !include.contains(FacetParams.FacetRangeInclude.EDGE), FacetParams.FacetRangeOther.BEFORE.toString()));
        }
        if (includeBetween) {
            int intervalIndex = includeBefore ? 1 : 0;
            intervals.set(intervalIndex, new IntervalFacets.FacetInterval(sf, globalStartS, calc.formatValue(end), include.contains(FacetParams.FacetRangeInclude.LOWER) || include.contains(FacetParams.FacetRangeInclude.EDGE), include.contains(FacetParams.FacetRangeInclude.UPPER) || include.contains(FacetParams.FacetRangeInclude.EDGE), FacetParams.FacetRangeOther.BETWEEN.toString()));
        }
        if (includeAfter) {
            intervals.add(new IntervalFacets.FacetInterval(sf, calc.formatValue(end), "*", include.contains(FacetParams.FacetRangeInclude.OUTER) || !include.contains(FacetParams.FacetRangeInclude.UPPER) && !include.contains(FacetParams.FacetRangeInclude.EDGE), false, FacetParams.FacetRangeOther.AFTER.toString()));
        }
        IntervalFacets.FacetInterval[] intervalsArray = intervals.toArray(new IntervalFacets.FacetInterval[intervals.size()]);
        intervals = null;
        new IntervalFacets(sf, this.searcher, this.docs, intervalsArray);
        int intervalIndex = 0;
        int lastIntervalIndex = intervalsArray.length - 1;
        if (includeBefore) {
            res.add(intervalsArray[intervalIndex].getKey(), (Object)intervalsArray[intervalIndex].getCount());
            ++intervalIndex;
        }
        if (includeBetween) {
            res.add(intervalsArray[intervalIndex].getKey(), (Object)intervalsArray[intervalIndex].getCount());
            ++intervalIndex;
        }
        if (includeAfter) {
            res.add(intervalsArray[lastIntervalIndex].getKey(), (Object)intervalsArray[lastIntervalIndex].getCount());
            --lastIntervalIndex;
        }
        while (intervalIndex <= lastIntervalIndex) {
            IntervalFacets.FacetInterval interval = intervalsArray[intervalIndex];
            if (interval.getCount() >= minCount) {
                counts.add(interval.getKey(), (Object)interval.getCount());
            }
            ++intervalIndex;
        }
        res.add("start", start);
        res.add("end", end);
        return res;
    }

    protected int rangeCount(SchemaField sf, String low, String high, boolean iLow, boolean iHigh) throws IOException {
        Query rangeQ = sf.getType().getRangeQuery(null, sf, low, high, iLow, iHigh);
        if (this.params.getBool("group.facet", false)) {
            return this.getGroupedFacetQueryCount(rangeQ);
        }
        return this.searcher.numDocs(rangeQ, this.docs);
    }

    @Deprecated
    protected int rangeCount(SchemaField sf, Date low, Date high, boolean iLow, boolean iHigh) throws IOException {
        Query rangeQ = ((TrieDateField)sf.getType()).getRangeQuery(null, sf, low, high, iLow, iHigh);
        return this.searcher.numDocs(rangeQ, this.docs);
    }

    public NamedList<Object> getFacetIntervalCounts() throws IOException, SyntaxError {
        SimpleOrderedMap res = new SimpleOrderedMap();
        String[] fields = this.params.getParams("facet.interval");
        if (fields == null || fields.length == 0) {
            return res;
        }
        for (String field : fields) {
            this.parseParams("facet.interval", field);
            String[] intervalStrs = this.required.getFieldParams(this.facetValue, "facet.interval.set");
            SchemaField schemaField = this.searcher.getCore().getLatestSchema().getField(this.facetValue);
            if (this.params.getBool("group.facet", false)) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Interval Faceting can't be used with group.facet");
            }
            SimpleOrderedMap fieldResults = new SimpleOrderedMap();
            res.add(this.key, (Object)fieldResults);
            IntervalFacets intervalFacets = new IntervalFacets(schemaField, this.searcher, this.docs, intervalStrs, this.params);
            for (IntervalFacets.FacetInterval interval : intervalFacets) {
                fieldResults.add(interval.getKey(), (Object)interval.getCount());
            }
        }
        return res;
    }

    private NamedList getHeatmapCounts() throws IOException, SyntaxError {
        SimpleOrderedMap resOuter = new SimpleOrderedMap();
        String[] unparsedFields = this.rb.req.getParams().getParams("facet.heatmap");
        if (unparsedFields == null || unparsedFields.length == 0) {
            return resOuter;
        }
        if (this.params.getBool("group.facet", false)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Heatmaps can't be used with group.facet");
        }
        for (String unparsedField : unparsedFields) {
            this.parseParams("facet.heatmap", unparsedField);
            resOuter.add(this.key, SpatialHeatmapFacets.getHeatmapForField(this.key, this.facetValue, this.rb, this.params, this.docs));
        }
        return resOuter;
    }

    private static class DateRangeFieldEndpointCalculator
    extends RangeEndpointCalculator<Date> {
        private final Date now;

        public DateRangeFieldEndpointCalculator(SchemaField f, Date now) {
            super(f);
            this.now = now;
            if (!(this.field.getType() instanceof DateRangeField)) {
                throw new IllegalArgumentException("SchemaField must use field type extending TrieDateField or DateRangeField");
            }
        }

        @Override
        public String formatValue(Date val) {
            return TrieDateField.formatExternal(val);
        }

        @Override
        protected Date parseVal(String rawval) {
            return ((DateRangeField)this.field.getType()).parseMath(this.now, rawval);
        }

        @Override
        protected Object parseGap(String rawval) {
            return rawval;
        }

        @Override
        public Date parseAndAddGap(Date value, String gap) throws ParseException {
            DateMathParser dmp = new DateMathParser();
            dmp.setNow(value);
            return dmp.parseMath(gap);
        }
    }

    private static class DateRangeEndpointCalculator
    extends RangeEndpointCalculator<Date> {
        private static final String TYPE_ERR_MSG = "SchemaField must use field type extending TrieDateField or DateRangeField";
        private final Date now;

        public DateRangeEndpointCalculator(SchemaField f, Date now) {
            super(f);
            this.now = now;
            if (!(this.field.getType() instanceof TrieDateField)) {
                throw new IllegalArgumentException(TYPE_ERR_MSG);
            }
        }

        @Override
        public String formatValue(Date val) {
            return ((TrieDateField)this.field.getType()).toExternal(val);
        }

        @Override
        protected Date parseVal(String rawval) {
            return ((TrieDateField)this.field.getType()).parseMath(this.now, rawval);
        }

        @Override
        protected Object parseGap(String rawval) {
            return rawval;
        }

        @Override
        public Date parseAndAddGap(Date value, String gap) throws ParseException {
            DateMathParser dmp = new DateMathParser();
            dmp.setNow(value);
            return dmp.parseMath(gap);
        }
    }

    private static class LongRangeEndpointCalculator
    extends RangeEndpointCalculator<Long> {
        public LongRangeEndpointCalculator(SchemaField f) {
            super(f);
        }

        @Override
        protected Long parseVal(String rawval) {
            return Long.valueOf(rawval);
        }

        @Override
        public Long parseAndAddGap(Long value, String gap) {
            return new Long(value + Long.valueOf(gap));
        }
    }

    private static class IntegerRangeEndpointCalculator
    extends RangeEndpointCalculator<Integer> {
        public IntegerRangeEndpointCalculator(SchemaField f) {
            super(f);
        }

        @Override
        protected Integer parseVal(String rawval) {
            return Integer.valueOf(rawval);
        }

        @Override
        public Integer parseAndAddGap(Integer value, String gap) {
            return new Integer(value + Integer.valueOf(gap));
        }
    }

    private static class DoubleRangeEndpointCalculator
    extends RangeEndpointCalculator<Double> {
        public DoubleRangeEndpointCalculator(SchemaField f) {
            super(f);
        }

        @Override
        protected Double parseVal(String rawval) {
            return Double.valueOf(rawval);
        }

        @Override
        public Double parseAndAddGap(Double value, String gap) {
            return new Double(value + Double.valueOf(gap));
        }
    }

    private static class FloatRangeEndpointCalculator
    extends RangeEndpointCalculator<Float> {
        public FloatRangeEndpointCalculator(SchemaField f) {
            super(f);
        }

        @Override
        protected Float parseVal(String rawval) {
            return Float.valueOf(rawval);
        }

        @Override
        public Float parseAndAddGap(Float value, String gap) {
            return new Float(value.floatValue() + Float.valueOf(gap).floatValue());
        }
    }

    private static abstract class RangeEndpointCalculator<T extends Comparable<T>> {
        protected final SchemaField field;

        public RangeEndpointCalculator(SchemaField field) {
            this.field = field;
        }

        public String formatValue(T val) {
            return val.toString();
        }

        public final T getValue(String rawval) {
            try {
                return this.parseVal(rawval);
            }
            catch (Exception e) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Can't parse value " + rawval + " for field: " + this.field.getName(), (Throwable)e);
            }
        }

        protected abstract T parseVal(String var1) throws ParseException;

        public final Object getGap(String gap) {
            try {
                return this.parseGap(gap);
            }
            catch (Exception e) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Can't parse gap " + gap + " for field: " + this.field.getName(), (Throwable)e);
            }
        }

        protected Object parseGap(String rawval) throws ParseException {
            return this.parseVal(rawval);
        }

        public final T addGap(T value, String gap) {
            try {
                return this.parseAndAddGap(value, gap);
            }
            catch (Exception e) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Can't add gap " + gap + " to value " + value + " for field: " + this.field.getName(), (Throwable)e);
            }
        }

        protected abstract T parseAndAddGap(T var1, String var2) throws ParseException;
    }

    public static class CountPair<K extends Comparable<? super K>, V extends Comparable<? super V>>
    implements Comparable<CountPair<K, V>> {
        public K key;
        public V val;

        public CountPair(K k, V v) {
            this.key = k;
            this.val = v;
        }

        public int hashCode() {
            return this.key.hashCode() ^ this.val.hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof CountPair)) {
                return false;
            }
            CountPair that = (CountPair)o;
            return this.key.equals(that.key) && this.val.equals(that.val);
        }

        @Override
        public int compareTo(CountPair<K, V> o) {
            int vc = o.val.compareTo(this.val);
            return 0 != vc ? vc : this.key.compareTo(o.key);
        }
    }

    static enum FacetMethod {
        ENUM,
        FC,
        FCS;

    }
}

