/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.solr.cloud.ZkSolrResourceLoader;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.handler.SolrConfigHandler;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrRequestHandler;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.ManagedIndexSchema;
import org.apache.solr.schema.SchemaManager;
import org.apache.solr.schema.ZkIndexSchemaReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaHandler
extends RequestHandlerBase {
    private static final Logger log = LoggerFactory.getLogger(SchemaHandler.class);
    private static Set<String> subPaths = new HashSet<String>(Arrays.asList("/version", "/uniquekey", "/name", "/similarity", "/defaultsearchfield", "/solrqueryparser", "/zkversion", "/solrqueryparser/defaultoperator"));

    @Override
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        SolrConfigHandler.setWt(req, "json");
        String httpMethod = (String)req.getContext().get("httpMethod");
        if ("POST".equals(httpMethod)) {
            if (req.getContentStreams() == null) {
                rsp.add("errors", "no stream");
                return;
            }
            Iterator<ContentStream> iterator = req.getContentStreams().iterator();
            if (iterator.hasNext()) {
                ContentStream stream = iterator.next();
                try {
                    List errs = new SchemaManager(req).performOperations(stream.getReader());
                    if (!errs.isEmpty()) {
                        rsp.add("errors", errs);
                    }
                }
                catch (IOException e) {
                    rsp.add("errors", Collections.singletonList("Error reading input String " + e.getMessage()));
                    rsp.setException(e);
                }
            }
        } else {
            this.handleGET(req, rsp);
        }
    }

    private void handleGET(SolrQueryRequest req, SolrQueryResponse rsp) {
        try {
            String path;
            switch (path = (String)req.getContext().get("path")) {
                case "/schema": {
                    rsp.add("schema", req.getSchema().getNamedPropertyValues());
                    break;
                }
                case "/schema/version": {
                    rsp.add("version", Float.valueOf(req.getSchema().getVersion()));
                    break;
                }
                case "/schema/uniquekey": {
                    rsp.add("uniqueKey", req.getSchema().getUniqueKeyField().getName());
                    break;
                }
                case "/schema/similarity": {
                    rsp.add("similarity", req.getSchema().getSimilarityFactory().getNamedPropertyValues());
                    break;
                }
                case "/schema/name": {
                    String schemaName = req.getSchema().getSchemaName();
                    if (null == schemaName) {
                        String message = "Schema has no name";
                        throw new SolrException(SolrException.ErrorCode.NOT_FOUND, message);
                    }
                    rsp.add("name", schemaName);
                    break;
                }
                case "/schema/defaultsearchfield": {
                    String defaultSearchFieldName = req.getSchema().getDefaultSearchFieldName();
                    if (null == defaultSearchFieldName) {
                        String message = "undefined defaultSearchField";
                        throw new SolrException(SolrException.ErrorCode.NOT_FOUND, "undefined defaultSearchField");
                    }
                    rsp.add("defaultSearchField", defaultSearchFieldName);
                    break;
                }
                case "/schema/solrqueryparser": {
                    SimpleOrderedMap props = new SimpleOrderedMap();
                    props.add("defaultOperator", (Object)req.getSchema().getQueryParserDefaultOperator());
                    rsp.add("solrQueryParser", props);
                    break;
                }
                case "/schema/zkversion": {
                    int refreshIfBelowVersion = -1;
                    String refreshParam = req.getParams().get("refreshIfBelowVersion");
                    if (refreshParam != null) {
                        refreshIfBelowVersion = refreshParam instanceof Number ? ((Number)((Object)refreshParam)).intValue() : Integer.parseInt(refreshParam.toString());
                    }
                    int zkVersion = -1;
                    IndexSchema schema = req.getSchema();
                    if (schema instanceof ManagedIndexSchema) {
                        ManagedIndexSchema managed = (ManagedIndexSchema)schema;
                        zkVersion = managed.getSchemaZkVersion();
                        if (refreshIfBelowVersion != -1 && zkVersion < refreshIfBelowVersion) {
                            log.info("REFRESHING SCHEMA (refreshIfBelowVersion=" + refreshIfBelowVersion + ", currentVersion=" + zkVersion + ") before returning version!");
                            ZkSolrResourceLoader zkSolrResourceLoader = (ZkSolrResourceLoader)req.getCore().getResourceLoader();
                            ZkIndexSchemaReader zkIndexSchemaReader = zkSolrResourceLoader.getZkIndexSchemaReader();
                            managed = zkIndexSchemaReader.refreshSchemaFromZk(refreshIfBelowVersion);
                            zkVersion = managed.getSchemaZkVersion();
                        }
                    }
                    rsp.add("zkversion", zkVersion);
                    break;
                }
                case "/schema/solrqueryparser/defaultoperator": {
                    rsp.add("defaultOperator", req.getSchema().getQueryParserDefaultOperator());
                    break;
                }
                default: {
                    throw new SolrException(SolrException.ErrorCode.NOT_FOUND, "No such path " + path);
                }
            }
        }
        catch (Exception e) {
            rsp.setException(e);
        }
    }

    @Override
    public SolrRequestHandler getSubHandler(String subPath) {
        if (subPaths.contains(subPath)) {
            return this;
        }
        return null;
    }

    @Override
    public String getDescription() {
        return "CRUD operations over the Solr schema";
    }
}

