/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import org.apache.lucene.util.IOUtils;
import org.apache.solr.client.solrj.impl.HttpClientConfigurer;
import org.apache.solr.client.solrj.impl.HttpClientUtil;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.core.CloserThread;
import org.apache.solr.core.ConfigSet;
import org.apache.solr.core.ConfigSetService;
import org.apache.solr.core.CoreDescriptor;
import org.apache.solr.core.CorePropertiesLocator;
import org.apache.solr.core.CoresLocator;
import org.apache.solr.core.JarRepository;
import org.apache.solr.core.NodeConfig;
import org.apache.solr.core.PluginBag;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrCores;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.core.SolrXmlConfig;
import org.apache.solr.core.ZkContainer;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.handler.admin.CollectionsHandler;
import org.apache.solr.handler.admin.CoreAdminHandler;
import org.apache.solr.handler.admin.InfoHandler;
import org.apache.solr.handler.component.HttpShardHandlerFactory;
import org.apache.solr.handler.component.ShardHandlerFactory;
import org.apache.solr.logging.LogWatcher;
import org.apache.solr.request.SolrRequestHandler;
import org.apache.solr.security.AuthenticationPlugin;
import org.apache.solr.security.AuthorizationPlugin;
import org.apache.solr.update.UpdateShardHandler;
import org.apache.solr.util.DefaultSolrThreadFactory;
import org.apache.solr.util.FileUtils;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoreContainer {
    protected static final Logger log = LoggerFactory.getLogger(CoreContainer.class);
    final SolrCores solrCores = new SolrCores(this);
    protected AuthorizationPlugin authorizationPlugin;
    protected AuthenticationPlugin authenticationPlugin;
    protected final Map<String, CoreLoadFailure> coreInitFailures = new ConcurrentHashMap<String, CoreLoadFailure>();
    protected CoreAdminHandler coreAdminHandler = null;
    protected CollectionsHandler collectionsHandler = null;
    private InfoHandler infoHandler;
    protected Properties containerProperties;
    private ConfigSetService coreConfigService;
    protected ZkContainer zkSys = new ZkContainer();
    protected ShardHandlerFactory shardHandlerFactory;
    private UpdateShardHandler updateShardHandler;
    protected LogWatcher logging = null;
    private CloserThread backgroundCloser = null;
    protected final NodeConfig cfg;
    protected final SolrResourceLoader loader;
    protected final String solrHome;
    protected final CoresLocator coresLocator;
    private String hostName;
    private final JarRepository jarRepository = new JarRepository(this);
    public static final String CORES_HANDLER_PATH = "/admin/cores";
    public static final String COLLECTIONS_HANDLER_PATH = "/admin/collections";
    public static final String INFO_HANDLER_PATH = "/admin/info";
    public static final String AUTHENTICATION_PLUGIN_PROP = "authenticationPlugin";
    private PluginBag<SolrRequestHandler> containerHandlers = new PluginBag<SolrRequestHandler>(SolrRequestHandler.class, null);
    private volatile boolean isShutDown;

    public ExecutorService getCoreZkRegisterExecutorService() {
        return this.zkSys.getCoreZkRegisterExecutorService();
    }

    public SolrRequestHandler getRequestHandler(String path) {
        return RequestHandlerBase.getRequestHandler(path, this.containerHandlers);
    }

    public PluginBag<SolrRequestHandler> getRequestHandlers() {
        return this.containerHandlers;
    }

    public CoreContainer() {
        this(new SolrResourceLoader(SolrResourceLoader.locateSolrHome()));
    }

    public CoreContainer(SolrResourceLoader loader) {
        this(SolrXmlConfig.fromSolrHome(loader, loader.getInstanceDir()));
    }

    public CoreContainer(String solrHome) {
        this(new SolrResourceLoader(solrHome));
    }

    public CoreContainer(NodeConfig config) {
        this(config, new Properties());
    }

    public CoreContainer(NodeConfig config, Properties properties) {
        this(config, properties, new CorePropertiesLocator(config.getCoreRootDirectory()));
    }

    public CoreContainer(NodeConfig config, Properties properties, CoresLocator locator) {
        log.info("New CoreContainer " + System.identityHashCode(this));
        this.isShutDown = false;
        this.loader = config.getSolrResourceLoader();
        this.solrHome = this.loader.getInstanceDir();
        this.cfg = (NodeConfig)Preconditions.checkNotNull((Object)config);
        this.coresLocator = locator;
        this.containerProperties = new Properties(properties);
    }

    private void intializeAuthorizationPlugin() {
        Map securityProps = this.getZkController().getZkStateReader().getSecurityProps();
        if (securityProps != null) {
            Map authorizationConf = (Map)securityProps.get("authorization");
            if (authorizationConf == null) {
                return;
            }
            String klas = (String)authorizationConf.get("class");
            if (klas == null) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "class is required for authorization plugin");
            }
            log.info("Initializing authorization plugin: " + klas);
            this.authorizationPlugin = this.getResourceLoader().newInstance(klas, AuthorizationPlugin.class);
            this.authorizationPlugin.init(authorizationConf);
        } else {
            log.info("Security conf doesn't exist. Skipping setup for authorization module.");
        }
    }

    private void initializeAuthenticationPlugin() {
        Map securityProps;
        String pluginClassName = null;
        Map authenticationConfig = null;
        if (this.isZooKeeperAware() && (securityProps = this.getZkController().getZkStateReader().getSecurityProps()) != null && (authenticationConfig = (Map)securityProps.get("authentication")) != null) {
            if (authenticationConfig.containsKey("class")) {
                pluginClassName = String.valueOf(authenticationConfig.get("class"));
            } else {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "No 'class' specified for authentication in ZK.");
            }
        }
        if (pluginClassName != null) {
            log.info("Authentication plugin class obtained from ZK: " + pluginClassName);
        } else if (System.getProperty(AUTHENTICATION_PLUGIN_PROP) != null) {
            pluginClassName = System.getProperty(AUTHENTICATION_PLUGIN_PROP);
            log.info("Authentication plugin class obtained from system property 'authenticationPlugin': " + pluginClassName);
        } else {
            log.info("No authentication plugin used.");
        }
        if (pluginClassName != null) {
            try {
                Class<?> cl = Class.forName(pluginClassName);
                this.authenticationPlugin = (AuthenticationPlugin)cl.newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
            }
        }
        if (this.authenticationPlugin != null) {
            this.authenticationPlugin.init(authenticationConfig);
            HttpClientConfigurer configurer = this.authenticationPlugin.getDefaultConfigurer();
            HttpClientUtil.setConfigurer((HttpClientConfigurer)configurer);
            log.info("Reconfiguring the shard handler factory and update shard handler.");
            if (this.getShardHandlerFactory() instanceof HttpShardHandlerFactory) {
                ((HttpShardHandlerFactory)this.getShardHandlerFactory()).reconfigureHttpClient(configurer);
            }
            this.getUpdateShardHandler().reconfigureHttpClient(configurer);
        }
    }

    protected CoreContainer(Object testConstructor) {
        log.info("New CoreContainer " + System.identityHashCode(this));
        this.isShutDown = false;
        this.solrHome = null;
        this.loader = null;
        this.coresLocator = null;
        this.cfg = null;
        this.containerProperties = null;
    }

    public static CoreContainer createAndLoad(String solrHome, File configFile) {
        SolrResourceLoader loader = new SolrResourceLoader(solrHome);
        CoreContainer cc = new CoreContainer(SolrXmlConfig.fromFile(loader, configFile));
        try {
            cc.load();
        }
        catch (Exception e) {
            cc.shutdown();
            throw e;
        }
        return cc;
    }

    public Properties getContainerProperties() {
        return this.containerProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        log.info("Loading cores into CoreContainer [instanceDir={}]", (Object)this.loader.getInstanceDir());
        String libDir = this.cfg.getSharedLibDirectory();
        if (libDir != null) {
            File f = FileUtils.resolvePath(new File(this.solrHome), libDir);
            log.info("loading shared library: " + f.getAbsolutePath());
            this.loader.addToClassLoader(libDir, null, false);
            this.loader.reloadLuceneSPI();
        }
        this.shardHandlerFactory = ShardHandlerFactory.newInstance(this.cfg.getShardHandlerFactoryPluginInfo(), this.loader);
        this.updateShardHandler = new UpdateShardHandler(this.cfg.getUpdateShardHandlerConfig());
        this.solrCores.allocateLazyCores(this.cfg.getTransientCacheSize(), this.loader);
        this.logging = LogWatcher.newRegisteredLogWatcher(this.cfg.getLogWatcherConfig(), this.loader);
        this.hostName = this.cfg.getNodeName();
        log.info("Node Name: " + this.hostName);
        this.zkSys.initZooKeeper(this, this.solrHome, this.cfg.getCloudConfig());
        this.initializeAuthenticationPlugin();
        if (this.isZooKeeperAware()) {
            this.intializeAuthorizationPlugin();
        }
        this.collectionsHandler = this.createHandler(this.cfg.getCollectionsHandlerClass(), CollectionsHandler.class);
        this.containerHandlers.put(COLLECTIONS_HANDLER_PATH, this.collectionsHandler);
        this.infoHandler = this.createHandler(this.cfg.getInfoHandlerClass(), InfoHandler.class);
        this.containerHandlers.put(INFO_HANDLER_PATH, this.infoHandler);
        this.coreAdminHandler = this.createHandler(this.cfg.getCoreAdminHandlerClass(), CoreAdminHandler.class);
        this.containerHandlers.put(CORES_HANDLER_PATH, this.coreAdminHandler);
        this.coreConfigService = ConfigSetService.createConfigSetService(this.cfg, this.loader, this.zkSys.zkController);
        this.containerProperties.putAll((Map<?, ?>)this.cfg.getSolrProperties());
        ExecutorService coreLoadExecutor = ExecutorUtil.newMDCAwareFixedThreadPool((int)(this.zkSys.getZkController() == null ? this.cfg.getCoreLoadThreadCount() : Integer.MAX_VALUE), (ThreadFactory)new DefaultSolrThreadFactory("coreLoadExecutor"));
        try {
            List<CoreDescriptor> cds = this.coresLocator.discover(this);
            CoreContainer.checkForDuplicateCoreNames(cds);
            ArrayList<1> creators = new ArrayList<1>();
            for (final CoreDescriptor cd : cds) {
                if (cd.isTransient() || !cd.isLoadOnStartup()) {
                    this.solrCores.putDynamicDescriptor(cd.getName(), cd);
                }
                if (!cd.isLoadOnStartup()) continue;
                creators.add(new Callable<SolrCore>(){

                    @Override
                    public SolrCore call() throws Exception {
                        if (CoreContainer.this.zkSys.getZkController() != null) {
                            CoreContainer.this.zkSys.getZkController().throwErrorIfReplicaReplaced(cd);
                        }
                        return CoreContainer.this.create(cd, false);
                    }
                });
            }
            try {
                coreLoadExecutor.invokeAll(creators);
            }
            catch (InterruptedException e) {
                throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "Interrupted while loading cores");
            }
            this.backgroundCloser = new CloserThread(this, this.solrCores, this.cfg);
            this.backgroundCloser.start();
        }
        finally {
            ExecutorUtil.shutdownNowAndAwaitTermination((ExecutorService)coreLoadExecutor);
        }
        if (this.isZooKeeperAware()) {
            Collection<SolrCore> cores = this.getCores();
            if (cores != null) {
                for (SolrCore core : cores) {
                    try {
                        this.zkSys.registerInZk(core, true);
                    }
                    catch (Throwable t) {
                        SolrException.log((Logger)log, (String)"Error registering SolrCore", (Throwable)t);
                    }
                }
            }
            this.zkSys.getZkController().checkOverseerDesignate();
        }
    }

    private static void checkForDuplicateCoreNames(List<CoreDescriptor> cds) {
        HashMap addedCores = Maps.newHashMap();
        for (CoreDescriptor cd : cds) {
            String name = cd.getName();
            if (addedCores.containsKey(name)) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, String.format(Locale.ROOT, "Found multiple cores with the name [%s], with instancedirs [%s] and [%s]", name, addedCores.get(name), cd.getInstanceDir()));
            }
            addedCores.put(name, cd.getInstanceDir());
        }
    }

    public boolean isShutDown() {
        return this.isShutDown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        log.info("Shutting down CoreContainer instance=" + System.identityHashCode(this));
        this.isShutDown = true;
        if (this.isZooKeeperAware()) {
            this.cancelCoreRecoveries();
            this.zkSys.publishCoresAsDown(this.solrCores.getCores());
        }
        try {
            if (this.coreAdminHandler != null) {
                this.coreAdminHandler.shutdown();
            }
        }
        catch (Exception e) {
            log.warn("Error shutting down CoreAdminHandler. Continuing to close CoreContainer.", (Throwable)e);
        }
        try {
            Object e;
            block38: {
                e = this.solrCores.getModifyLock();
                synchronized (e) {
                    this.solrCores.getModifyLock().notifyAll();
                }
                if (this.backgroundCloser != null) {
                    try {
                        this.backgroundCloser.join();
                    }
                    catch (InterruptedException e2) {
                        Thread.currentThread().interrupt();
                        if (!log.isDebugEnabled()) break block38;
                        log.debug("backgroundCloser thread was interrupted before finishing");
                    }
                }
            }
            this.solrCores.close();
            e = this.solrCores.getModifyLock();
            synchronized (e) {
                this.solrCores.getModifyLock().notifyAll();
            }
        }
        finally {
            try {
                if (this.shardHandlerFactory != null) {
                    this.shardHandlerFactory.close();
                }
            }
            finally {
                try {
                    if (this.updateShardHandler != null) {
                        this.updateShardHandler.close();
                    }
                }
                finally {
                    this.zkSys.close();
                }
            }
        }
        try {
            if (this.authorizationPlugin != null) {
                this.authorizationPlugin.close();
            }
        }
        catch (IOException e) {
            log.warn("Exception while closing authorization plugin.", (Throwable)e);
        }
        try {
            if (this.authenticationPlugin != null) {
                this.authenticationPlugin.close();
                this.authenticationPlugin = null;
            }
        }
        catch (Exception e) {
            log.warn("Exception while closing authentication plugin.", (Throwable)e);
        }
        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.loader});
    }

    public void cancelCoreRecoveries() {
        List<SolrCore> cores = this.solrCores.getCores();
        for (SolrCore core : cores) {
            try {
                core.getSolrCoreState().cancelRecovery();
            }
            catch (Exception e) {
                SolrException.log((Logger)log, (String)"Error canceling recovery for core", (Throwable)e);
            }
        }
    }

    protected void finalize() throws Throwable {
        try {
            if (!this.isShutDown) {
                log.error("CoreContainer was not close prior to finalize(), indicates a bug -- POSSIBLE RESOURCE LEAK!!!  instance=" + System.identityHashCode(this));
            }
        }
        finally {
            super.finalize();
        }
    }

    public CoresLocator getCoresLocator() {
        return this.coresLocator;
    }

    protected SolrCore registerCore(String name, SolrCore core, boolean registerInZk) {
        if (core == null) {
            throw new RuntimeException("Can not register a null core.");
        }
        if (name == null || name.indexOf(47) >= 0 || name.indexOf(92) >= 0) {
            throw new RuntimeException("Invalid core name: " + name);
        }
        CoreDescriptor cd = core.getCoreDescriptor();
        if ((cd.isTransient() || !cd.isLoadOnStartup()) && this.solrCores.getDynamicDescriptor(name) == null) {
            this.solrCores.putDynamicDescriptor(name, cd);
        }
        if (this.isShutDown) {
            core.close();
            throw new IllegalStateException("This CoreContainer has been close");
        }
        SolrCore old = cd.isTransient() ? this.solrCores.putTransientCore(this.cfg, name, core, this.loader) : this.solrCores.putCore(name, core);
        core.setName(name);
        this.coreInitFailures.remove(name);
        if (old == null || old == core) {
            log.info("registering core: " + name);
            if (registerInZk) {
                this.zkSys.registerInZk(core, false);
            }
            return null;
        }
        log.info("replacing core: " + name);
        old.close();
        if (registerInZk) {
            this.zkSys.registerInZk(core, false);
        }
        return old;
    }

    public SolrCore create(CoreDescriptor cd) {
        return this.create(cd, true);
    }

    public SolrCore create(CoreDescriptor dcore, boolean publishState) {
        if (this.isShutDown) {
            throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "Solr has close.");
        }
        SolrCore core = null;
        try {
            if (this.zkSys.getZkController() != null) {
                this.zkSys.getZkController().preRegister(dcore);
            }
            ConfigSet coreConfig = this.coreConfigService.getConfig(dcore);
            log.info("Creating SolrCore '{}' using configuration from {}", (Object)dcore.getName(), (Object)coreConfig.getName());
            core = new SolrCore(dcore, coreConfig);
            this.solrCores.addCreated(core);
            if (!this.isZooKeeperAware() && core.getUpdateHandler().getUpdateLog() != null) {
                core.getUpdateHandler().getUpdateLog().recoverFromLog();
            }
            this.registerCore(dcore.getName(), core, publishState);
            return core;
        }
        catch (Exception e) {
            this.coreInitFailures.put(dcore.getName(), new CoreLoadFailure(dcore, e));
            log.error("Error creating core [{}]: {}", new Object[]{dcore.getName(), e.getMessage(), e});
            SolrException solrException = new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to create core [" + dcore.getName() + "]", (Throwable)e);
            if (core != null && !core.isClosed()) {
                org.apache.solr.common.util.IOUtils.closeQuietly((Closeable)core);
            }
            throw solrException;
        }
        catch (Throwable t) {
            SolrException e = new SolrException(SolrException.ErrorCode.SERVER_ERROR, "JVM Error creating core [" + dcore.getName() + "]: " + t.getMessage(), t);
            log.error("Error creating core [{}]: {}", new Object[]{dcore.getName(), t.getMessage(), t});
            this.coreInitFailures.put(dcore.getName(), new CoreLoadFailure(dcore, (Exception)((Object)e)));
            if (core != null && !core.isClosed()) {
                org.apache.solr.common.util.IOUtils.closeQuietly((Closeable)core);
            }
            throw t;
        }
    }

    public Collection<SolrCore> getCores() {
        return this.solrCores.getCores();
    }

    public Collection<String> getCoreNames() {
        return this.solrCores.getCoreNames();
    }

    public Collection<String> getCoreNames(SolrCore core) {
        return this.solrCores.getCoreNames(core);
    }

    public Collection<String> getAllCoreNames() {
        return this.solrCores.getAllCoreNames();
    }

    public Map<String, CoreLoadFailure> getCoreInitFailures() {
        return ImmutableMap.copyOf(this.coreInitFailures);
    }

    public void reload(String name) {
        SolrCore core = this.solrCores.getCoreFromAnyList(name, false);
        if (core == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No such core: " + name);
        }
        CoreDescriptor cd = core.getCoreDescriptor();
        try {
            this.solrCores.waitAddPendingCoreOps(name);
            ConfigSet coreConfig = this.coreConfigService.getConfig(cd);
            log.info("Reloading SolrCore '{}' using configuration from {}", (Object)cd.getName(), (Object)coreConfig.getName());
            SolrCore newCore = core.reload(coreConfig);
            this.registerCore(name, newCore, false);
        }
        catch (Exception e) {
            this.coreInitFailures.put(cd.getName(), new CoreLoadFailure(cd, e));
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to reload core [" + cd.getName() + "]", (Throwable)e);
        }
        finally {
            this.solrCores.removeFromPendingOps(name);
        }
    }

    public void swap(String n0, String n1) {
        if (n0 == null || n1 == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Can not swap unnamed cores.");
        }
        this.solrCores.swap(n0, n1);
        this.coresLocator.swap(this, this.solrCores.getCoreDescriptor(n0), this.solrCores.getCoreDescriptor(n1));
        log.info("swapped: " + n0 + " with " + n1);
    }

    public void unload(String name) {
        this.unload(name, false, false, false);
    }

    public void unload(String name, boolean deleteIndexDir, boolean deleteDataDir, boolean deleteInstanceDir) {
        CoreLoadFailure loadFailure = this.coreInitFailures.remove(name);
        if (loadFailure != null) {
            SolrCore.deleteUnloadedCore(loadFailure.cd, deleteDataDir, deleteInstanceDir);
            return;
        }
        CoreDescriptor cd = this.solrCores.getCoreDescriptor(name);
        if (cd == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Cannot unload non-existent core [" + name + "]");
        }
        boolean close = this.solrCores.isLoadedNotPendingClose(name);
        SolrCore core = this.solrCores.remove(name);
        this.coresLocator.delete(this, cd);
        if (core == null) {
            SolrCore.deleteUnloadedCore(cd, deleteDataDir, deleteInstanceDir);
            return;
        }
        if (this.zkSys.getZkController() != null) {
            core.getSolrCoreState().cancelRecovery();
        }
        core.unloadOnClose(deleteIndexDir, deleteDataDir, deleteInstanceDir);
        if (close) {
            core.close();
        }
        if (this.zkSys.getZkController() != null) {
            try {
                this.zkSys.getZkController().unregister(name, cd);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Interrupted while unregistering core [" + name + "] from cloud state");
            }
            catch (KeeperException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error unregistering core [" + name + "] from cloud state", (Throwable)e);
            }
        }
    }

    public void rename(String name, String toName) {
        try (SolrCore core = this.getCore(name);){
            if (core != null) {
                this.registerCore(toName, core, true);
                SolrCore old = this.solrCores.remove(name);
                this.coresLocator.rename(this, old.getCoreDescriptor(), core.getCoreDescriptor());
            }
        }
    }

    public List<CoreDescriptor> getCoreDescriptors() {
        return this.solrCores.getCoreDescriptors();
    }

    public CoreDescriptor getCoreDescriptor(String coreName) {
        for (CoreDescriptor cd : this.getCoreDescriptors()) {
            if (!cd.getName().equals(coreName)) continue;
            return cd;
        }
        return null;
    }

    public String getCoreRootDirectory() {
        return this.cfg.getCoreRootDirectory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SolrCore getCore(String name) {
        SolrCore core = this.solrCores.getCoreFromAnyList(name, true);
        if (core != null) {
            return core;
        }
        CoreDescriptor desc = this.solrCores.getDynamicDescriptor(name);
        if (desc == null) {
            CoreLoadFailure loadFailure = this.getCoreInitFailures().get(name);
            if (null != loadFailure) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "SolrCore '" + name + "' is not available due to init failure: " + loadFailure.exception.getMessage(), (Throwable)loadFailure.exception);
            }
            return null;
        }
        core = this.solrCores.waitAddPendingCoreOps(name);
        if (this.isShutDown) {
            return null;
        }
        try {
            if (core == null) {
                if (this.zkSys.getZkController() != null) {
                    this.zkSys.getZkController().throwErrorIfReplicaReplaced(desc);
                }
                core = this.create(desc);
            }
            core.open();
        }
        finally {
            this.solrCores.removeFromPendingOps(name);
        }
        return core;
    }

    public JarRepository getJarRepository() {
        return this.jarRepository;
    }

    protected <T> T createHandler(String handlerClass, Class<T> clazz) {
        return this.loader.newInstance(handlerClass, clazz, null, new Class[]{CoreContainer.class}, new Object[]{this});
    }

    public CoreAdminHandler getMultiCoreHandler() {
        return this.coreAdminHandler;
    }

    public CollectionsHandler getCollectionsHandler() {
        return this.collectionsHandler;
    }

    public InfoHandler getInfoHandler() {
        return this.infoHandler;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getManagementPath() {
        return this.cfg.getManagementPath();
    }

    public LogWatcher getLogging() {
        return this.logging;
    }

    public boolean isLoaded(String name) {
        return this.solrCores.isLoaded(name);
    }

    public boolean isLoadedNotPendingClose(String name) {
        return this.solrCores.isLoadedNotPendingClose(name);
    }

    public CoreDescriptor getUnloadedCoreDescriptor(String cname) {
        return this.solrCores.getUnloadedCoreDescriptor(cname);
    }

    public String getSolrHome() {
        return this.solrHome;
    }

    public boolean isZooKeeperAware() {
        return this.zkSys.getZkController() != null;
    }

    public ZkController getZkController() {
        return this.zkSys.getZkController();
    }

    public NodeConfig getConfig() {
        return this.cfg;
    }

    public ShardHandlerFactory getShardHandlerFactory() {
        return this.shardHandlerFactory;
    }

    public UpdateShardHandler getUpdateShardHandler() {
        return this.updateShardHandler;
    }

    public SolrResourceLoader getResourceLoader() {
        return this.loader;
    }

    public AuthorizationPlugin getAuthorizationPlugin() {
        return this.authorizationPlugin;
    }

    public AuthenticationPlugin getAuthenticationPlugin() {
        return this.authenticationPlugin;
    }

    public static class CoreLoadFailure {
        public final CoreDescriptor cd;
        public final Exception exception;

        public CoreLoadFailure(CoreDescriptor cd, Exception loadFailure) {
            this.cd = cd;
            this.exception = loadFailure;
        }
    }
}

