/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.request.CoreAdminRequest;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.ClusterStateUtil;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.core.CloudConfig;
import org.apache.solr.update.UpdateShardHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class OverseerAutoReplicaFailoverThread
implements Runnable,
Closeable {
    private static Logger log = LoggerFactory.getLogger(OverseerAutoReplicaFailoverThread.class);
    private Integer lastClusterStateVersion;
    private final ExecutorService updateExecutor;
    private volatile boolean isClosed;
    private ZkStateReader zkStateReader;
    private final Cache<String, Long> baseUrlForBadNodes;
    private Set<String> liveNodes = Collections.EMPTY_SET;
    private final int workLoopDelay;
    private final int waitAfterExpiration;

    public OverseerAutoReplicaFailoverThread(CloudConfig config, ZkStateReader zkStateReader, UpdateShardHandler updateShardHandler) {
        this.zkStateReader = zkStateReader;
        this.workLoopDelay = config.getAutoReplicaFailoverWorkLoopDelay();
        this.waitAfterExpiration = config.getAutoReplicaFailoverWaitAfterExpiration();
        int badNodeExpiration = config.getAutoReplicaFailoverBadNodeExpiration();
        log.info("Starting " + this.getClass().getSimpleName() + " autoReplicaFailoverWorkLoopDelay={} autoReplicaFailoverWaitAfterExpiration={} autoReplicaFailoverBadNodeExpiration={}", new Object[]{this.workLoopDelay, this.waitAfterExpiration, badNodeExpiration});
        this.baseUrlForBadNodes = CacheBuilder.newBuilder().concurrencyLevel(1).expireAfterWrite((long)badNodeExpiration, TimeUnit.MILLISECONDS).build();
        this.updateExecutor = updateShardHandler.getUpdateExecutor();
    }

    @Override
    public void run() {
        while (!this.isClosed) {
            log.debug("do " + this.getClass().getSimpleName() + " work loop");
            try {
                this.doWork();
            }
            catch (Exception e) {
                SolrException.log((Logger)log, (String)(this.getClass().getSimpleName() + " had an error in its thread work loop."), (Throwable)e);
            }
            if (this.isClosed) continue;
            try {
                Thread.sleep(this.workLoopDelay);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private void doWork() {
        ClusterState clusterState = this.zkStateReader.getClusterState();
        String autoAddReplicas = (String)this.zkStateReader.getClusterProps().get("autoAddReplicas");
        if (autoAddReplicas != null && autoAddReplicas.equals("false")) {
            return;
        }
        if (clusterState != null) {
            if (clusterState.getZkClusterStateVersion() != null && clusterState.getZkClusterStateVersion().equals(this.lastClusterStateVersion) && this.baseUrlForBadNodes.size() == 0L && this.liveNodes.equals(clusterState.getLiveNodes())) {
                return;
            }
            this.liveNodes = clusterState.getLiveNodes();
            this.lastClusterStateVersion = clusterState.getZkClusterStateVersion();
            Set collections = clusterState.getCollections();
            for (String collection : collections) {
                log.debug("look at collection={}", (Object)collection);
                DocCollection docCollection = clusterState.getCollection(collection);
                if (!docCollection.getAutoAddReplicas()) {
                    log.debug("Collection {} is not setup to use autoAddReplicas, skipping..", (Object)docCollection.getName());
                    continue;
                }
                if (docCollection.getReplicationFactor() == null) {
                    log.debug("Skipping collection because it has no defined replicationFactor, name={}", (Object)docCollection.getName());
                    continue;
                }
                log.debug("Found collection, name={} replicationFactor={}", (Object)collection, (Object)docCollection.getReplicationFactor());
                Collection slices = docCollection.getSlices();
                for (Slice slice : slices) {
                    if (slice.getState() != Slice.State.ACTIVE) continue;
                    ArrayList<DownReplica> downReplicas = new ArrayList<DownReplica>();
                    int goodReplicas = OverseerAutoReplicaFailoverThread.findDownReplicasInSlice(clusterState, docCollection, slice, downReplicas);
                    log.debug("collection={} replicationFactor={} goodReplicaCount={}", new Object[]{docCollection.getName(), docCollection.getReplicationFactor(), goodReplicas});
                    if (downReplicas.size() > 0 && goodReplicas < docCollection.getReplicationFactor()) {
                        this.processBadReplicas(collection, downReplicas);
                        continue;
                    }
                    if (goodReplicas <= docCollection.getReplicationFactor()) continue;
                    log.debug("There are too many replicas");
                }
            }
        }
    }

    private void processBadReplicas(String collection, Collection<DownReplica> badReplicas) {
        for (DownReplica badReplica : badReplicas) {
            log.debug("process down replica={} from collection={}", (Object)badReplica.replica.getName(), (Object)collection);
            String baseUrl = badReplica.replica.getStr("base_url");
            Long wentBadAtNS = (Long)this.baseUrlForBadNodes.getIfPresent((Object)baseUrl);
            if (wentBadAtNS == null) {
                log.warn("Replica {} may need to failover.", (Object)badReplica.replica.getName());
                this.baseUrlForBadNodes.put((Object)baseUrl, (Object)System.nanoTime());
                continue;
            }
            long elasped = System.nanoTime() - wentBadAtNS;
            if (elasped < TimeUnit.NANOSECONDS.convert(this.waitAfterExpiration, TimeUnit.MILLISECONDS)) {
                log.debug("Looks troublesome...continue. Elapsed={}", (Object)(elasped + "ns"));
                continue;
            }
            log.debug("We need to add a replica. Elapsed={}", (Object)(elasped + "ns"));
            if (!this.addReplica(collection, badReplica)) continue;
            this.baseUrlForBadNodes.invalidate((Object)baseUrl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addReplica(final String collection, DownReplica badReplica) {
        final String createUrl = OverseerAutoReplicaFailoverThread.getBestCreateUrl(this.zkStateReader, badReplica);
        if (createUrl == null) {
            log.warn("Could not find a node to create new replica on.");
            return false;
        }
        final String dataDir = badReplica.replica.getStr("dataDir");
        final String ulogDir = badReplica.replica.getStr("ulogDir");
        final String coreNodeName = badReplica.replica.getName();
        if (dataDir != null) {
            final String coreName = badReplica.replica.getStr("core");
            log.debug("submit call to {}", (Object)createUrl);
            MDC.put((String)"OverseerAutoReplicaFailoverThread.createUrl", (String)createUrl);
            try {
                this.updateExecutor.submit(new Callable<Boolean>(){

                    @Override
                    public Boolean call() {
                        return OverseerAutoReplicaFailoverThread.this.createSolrCore(collection, createUrl, dataDir, ulogDir, coreNodeName, coreName);
                    }
                });
            }
            finally {
                MDC.remove((String)"OverseerAutoReplicaFailoverThread.createUrl");
            }
            boolean success = ClusterStateUtil.waitToSeeLiveReplica((ZkStateReader)this.zkStateReader, (String)collection, (String)coreNodeName, (String)createUrl, (int)30000);
            if (!success) {
                log.error("Creating new replica appears to have failed, timed out waiting to see created SolrCore register in the clusterstate.");
                return false;
            }
            return true;
        }
        log.warn("Could not find dataDir or ulogDir in cluster state.");
        return false;
    }

    private static int findDownReplicasInSlice(ClusterState clusterState, DocCollection collection, Slice slice, Collection<DownReplica> badReplicas) {
        int goodReplicas = 0;
        Collection replicas = slice.getReplicas();
        if (replicas != null) {
            for (Replica replica : replicas) {
                boolean live = clusterState.liveNodesContain(replica.getNodeName());
                Replica.State state = replica.getState();
                boolean okayState = state == Replica.State.DOWN || state == Replica.State.RECOVERING || state == Replica.State.ACTIVE;
                log.debug("Process replica name={} live={} state={}", new Object[]{replica.getName(), live, state.toString()});
                if (live && okayState) {
                    ++goodReplicas;
                    continue;
                }
                DownReplica badReplica = new DownReplica();
                badReplica.replica = replica;
                badReplica.slice = slice;
                badReplica.collection = collection;
                badReplicas.add(badReplica);
            }
        }
        log.debug("bad replicas for slice {}", badReplicas);
        return goodReplicas;
    }

    static String getBestCreateUrl(ZkStateReader zkStateReader, DownReplica badReplica) {
        assert (badReplica != null);
        assert (badReplica.collection != null);
        assert (badReplica.slice != null);
        log.debug("getBestCreateUrl for " + badReplica.replica);
        HashMap<String, Counts> counts = new HashMap<String, Counts>();
        HashSet<String> unsuitableHosts = new HashSet<String>();
        HashSet liveNodes = new HashSet(zkStateReader.getClusterState().getLiveNodes());
        ClusterState clusterState = zkStateReader.getClusterState();
        if (clusterState != null) {
            Set collections = clusterState.getCollections();
            Iterator iterator = collections.iterator();
            while (iterator.hasNext()) {
                String collection = (String)iterator.next();
                log.debug("look at collection {} as possible create candidate", (Object)collection);
                DocCollection docCollection = clusterState.getCollection(collection);
                Collection slices = docCollection.getSlices();
                for (Slice slice : slices) {
                    if (slice.getState() != Slice.State.ACTIVE) continue;
                    log.debug("look at slice {} for collection {} as possible create candidate", (Object)slice.getName(), (Object)collection);
                    Collection replicas = slice.getReplicas();
                    for (Replica replica : replicas) {
                        Slice s;
                        Integer maxShardsPerNode;
                        liveNodes.remove(replica.getNodeName());
                        String baseUrl = replica.getStr("base_url");
                        if (baseUrl.equals(badReplica.replica.getStr("base_url"))) continue;
                        log.debug("collection={} nodename={} livenodes={}", new Object[]{collection, replica.getNodeName(), clusterState.getLiveNodes()});
                        boolean live = clusterState.liveNodesContain(replica.getNodeName());
                        log.debug("collection={} look at replica {} as possible create candidate, live={}", new Object[]{collection, replica.getName(), live});
                        if (!live) continue;
                        Counts cnt = (Counts)counts.get(baseUrl);
                        if (cnt == null) {
                            cnt = new Counts();
                        }
                        if (badReplica.collection.getName().equals(collection)) {
                            cnt.negRankingWeight += 3;
                            ++cnt.collectionShardsOnNode;
                        } else {
                            ++cnt.negRankingWeight;
                        }
                        if (badReplica.collection.getName().equals(collection) && badReplica.slice.getName().equals(slice.getName())) {
                            ++cnt.ourReplicas;
                        }
                        if ((maxShardsPerNode = Integer.valueOf(badReplica.collection.getMaxShardsPerNode())) == null) {
                            log.warn("maxShardsPerNode is not defined for collection, name=" + badReplica.collection.getName());
                            maxShardsPerNode = Integer.MAX_VALUE;
                        }
                        log.debug("collection={} node={} max shards per node={} potential hosts={}", new Object[]{collection, baseUrl, maxShardsPerNode, cnt});
                        Collection badSliceReplicas = null;
                        DocCollection c = clusterState.getCollection(badReplica.collection.getName());
                        if (c != null && (s = c.getSlice(badReplica.slice.getName())) != null) {
                            badSliceReplicas = s.getReplicas();
                        }
                        boolean alreadyExistsOnNode = OverseerAutoReplicaFailoverThread.replicaAlreadyExistsOnNode(zkStateReader.getClusterState(), badSliceReplicas, badReplica, baseUrl);
                        if (unsuitableHosts.contains(baseUrl) || alreadyExistsOnNode || cnt.collectionShardsOnNode >= maxShardsPerNode) {
                            counts.remove(baseUrl);
                            unsuitableHosts.add(baseUrl);
                            log.debug("not a candidate node, collection={} node={} max shards per node={} good replicas={}", new Object[]{collection, baseUrl, maxShardsPerNode, cnt});
                            continue;
                        }
                        counts.put(baseUrl, cnt);
                        log.debug("is a candidate node, collection={} node={} max shards per node={} good replicas={}", new Object[]{collection, baseUrl, maxShardsPerNode, cnt});
                    }
                }
            }
        }
        for (String node : liveNodes) {
            counts.put(zkStateReader.getBaseUrlForNodeName(node), new Counts(0, 0));
        }
        if (counts.size() == 0) {
            log.debug("no suitable hosts found for getBestCreateUrl for collection={}", (Object)badReplica.collection.getName());
            return null;
        }
        ValueComparator vc = new ValueComparator(counts);
        TreeMap<String, Counts> sortedCounts = new TreeMap<String, Counts>(vc);
        sortedCounts.putAll(counts);
        log.debug("empty nodes={} for collection={}", liveNodes, (Object)badReplica.collection.getName());
        log.debug("sorted hosts={} for collection={}", sortedCounts, (Object)badReplica.collection.getName());
        log.debug("unsuitable hosts={} for collection={}", unsuitableHosts, (Object)badReplica.collection.getName());
        return (String)sortedCounts.keySet().iterator().next();
    }

    private static boolean replicaAlreadyExistsOnNode(ClusterState clusterState, Collection<Replica> replicas, DownReplica badReplica, String baseUrl) {
        if (replicas != null) {
            log.debug("collection={} check if replica already exists on node using replicas {}", (Object)badReplica.collection.getName(), OverseerAutoReplicaFailoverThread.getNames(replicas));
            for (Replica replica : replicas) {
                Replica.State state = replica.getState();
                if (replica.getName().equals(badReplica.replica.getName()) || !replica.getStr("base_url").equals(baseUrl) || !clusterState.liveNodesContain(replica.getNodeName()) || state != Replica.State.ACTIVE && state != Replica.State.DOWN && state != Replica.State.RECOVERING) continue;
                log.debug("collection={} replica already exists on node, bad replica={}, existing replica={}, node name={}", new Object[]{badReplica.collection.getName(), badReplica.replica.getName(), replica.getName(), replica.getNodeName()});
                return true;
            }
        }
        log.debug("collection={} replica does not yet exist on node: {}", (Object)badReplica.collection.getName(), (Object)baseUrl);
        return false;
    }

    private static Object getNames(Collection<Replica> replicas) {
        HashSet<String> names = new HashSet<String>(replicas.size());
        for (Replica replica : replicas) {
            names.add(replica.getName());
        }
        return names;
    }

    private boolean createSolrCore(String collection, String createUrl, String dataDir, String ulogDir, String coreNodeName, String coreName) {
        try (HttpSolrClient client = new HttpSolrClient(createUrl);){
            log.debug("create url={}", (Object)createUrl);
            client.setConnectionTimeout(30000);
            client.setSoTimeout(60000);
            CoreAdminRequest.Create createCmd = new CoreAdminRequest.Create();
            createCmd.setCollection(collection);
            createCmd.setCoreNodeName(coreNodeName);
            createCmd.setCoreName(coreName);
            createCmd.setDataDir(dataDir);
            createCmd.setUlogDir(ulogDir);
            client.request((SolrRequest)createCmd);
        }
        catch (Exception e) {
            SolrException.log((Logger)log, (String)("Exception trying to create new replica on " + createUrl), (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    public void close() {
        this.isClosed = true;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    static class DownReplica {
        Replica replica;
        Slice slice;
        DocCollection collection;

        DownReplica() {
        }

        public String toString() {
            return "DownReplica [replica=" + this.replica.getName() + ", slice=" + this.slice.getName() + ", collection=" + this.collection.getName() + "]";
        }
    }

    private static class Counts {
        int collectionShardsOnNode = 0;
        int negRankingWeight = 0;
        int ourReplicas = 0;

        private Counts() {
        }

        private Counts(int totalReplicas, int ourReplicas) {
            this.negRankingWeight = totalReplicas;
            this.ourReplicas = ourReplicas;
        }

        public String toString() {
            return "Counts [negRankingWeight=" + this.negRankingWeight + ", sameSliceCount=" + this.ourReplicas + ", collectionShardsOnNode=" + this.collectionShardsOnNode + "]";
        }
    }

    private static class ValueComparator
    implements Comparator<String> {
        Map<String, Counts> map;

        public ValueComparator(Map<String, Counts> map) {
            this.map = map;
        }

        @Override
        public int compare(String a, String b) {
            if (this.map.get((Object)a).negRankingWeight >= this.map.get((Object)b).negRankingWeight) {
                return 1;
            }
            return -1;
        }
    }
}

