/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.document;

import coldfusion.document.spi.DocumentProperties;
import coldfusion.document.spi.DocumentSectionProperties;
import coldfusion.document.spi.Exporter;
import coldfusion.document.spi.HeaderFooterContentProvider;
import coldfusion.document.spi.PageNoCallbackHandler;
import ice.ri.common.print.PrintUtilities;
import ice.storm.StormBase;
import ice.storm.Viewport;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;

class DocumentFrame
extends JPanel
implements PropertyChangeListener {
    private JPanel contentPanel;
    private StormBase stormBase;
    private Viewport viewport;
    private HeaderFooterContentProvider headerContentProvider;
    private HeaderFooterContentProvider footerContentProvider;
    private PageNoCallbackHandler pageNoCbh;
    private DocumentProperties docProps;
    private DocumentSectionProperties docSectionProps;
    private URL baseurl;

    DocumentFrame(StormBase stormBase, Viewport viewport) {
        this.stormBase = stormBase;
        this.viewport = viewport;
        String viewportId = this.viewport.getId();
        this.stormBase.addPropertyChangeListener((PropertyChangeListener)this, viewportId);
        this.contentPanel = new JPanel();
        this.add((Component)this.contentPanel, "Center");
        this.setSize(800, 600);
    }

    JPanel getPanel() {
        return this.contentPanel;
    }

    private List getViewports(Viewport viewport) {
        ArrayList<Viewport> viewports = new ArrayList<Viewport>();
        if (viewport != null && viewport.getPilot() != null) {
            viewports.add(viewport);
            if (PrintUtilities.isFrameset((Viewport)viewport)) {
                for (Viewport childViewport = viewport.getFirstChild(); childViewport != null; childViewport = childViewport.getNextSibling()) {
                    viewports.addAll(this.getViewports(childViewport));
                }
            }
        }
        return viewports;
    }

    void setHeaderContentProvider(HeaderFooterContentProvider headerFooterContentProvider) {
        this.headerContentProvider = headerFooterContentProvider;
    }

    void setFooterContentProvider(HeaderFooterContentProvider footerContentProvider) {
        this.footerContentProvider = footerContentProvider;
    }

    void setPageNoCallbackHandler(PageNoCallbackHandler pageNoCbh) {
        this.pageNoCbh = pageNoCbh;
    }

    void setDocumentProperties(DocumentProperties docProps) {
        this.docProps = docProps;
    }

    void setDocumentSectionProperties(DocumentSectionProperties docSectionProps) {
        this.docSectionProps = docSectionProps;
    }

    void setBaseURL(URL url) {
        this.baseurl = url;
    }

    void exportContent(Exporter exporter, List sectionQueue) throws Exception {
        Viewport[] viewports;
        Viewport activeViewport = this.stormBase.getActiveViewport();
        boolean printAllFrames = this.docProps.isPrintAllFrames();
        if (activeViewport == null || activeViewport.getId().equals(this.viewport.getId())) {
            if (printAllFrames) {
                List viewportList = this.getViewports(this.viewport);
                viewports = viewportList.toArray(new Viewport[viewportList.size()]);
            } else {
                viewports = new Viewport[]{this.viewport};
            }
        } else {
            viewports = new Viewport[]{activeViewport};
        }
        if (sectionQueue == null) {
            exporter.export(viewports, this.docProps, this.headerContentProvider, this.footerContentProvider, this.pageNoCbh, this.baseurl);
        } else {
            exporter.export(viewports, this.docProps, this.docSectionProps, this.headerContentProvider, this.footerContentProvider, this.pageNoCbh, this.baseurl, sectionQueue);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
    }
}

