/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.document;

import coldfusion.server.SystemInfo;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.FontFactory;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.DefaultFontMapper;
import java.awt.Font;
import java.util.HashMap;
import java.util.Properties;
import java.util.StringTokenizer;

public class DocumentFontMapper
extends DefaultFontMapper {
    static final boolean TurnOnSpecialEncoding = true;
    public static final int EMBED = 0;
    public static final int NON_EMBED = 1;
    public static final int SELECTIVE = 2;
    private boolean bFontembed = true;
    private boolean bSelective = false;
    private HashMap fontMap;
    private Properties primaryFontMapper;
    private Properties backupFontMapper;

    public DocumentFontMapper(int embedMode, Properties primaryFontProperties, Properties backupFontProperties) {
        this.primaryFontMapper = primaryFontProperties;
        this.backupFontMapper = backupFontProperties;
        switch (embedMode) {
            case 2: {
                this.bSelective = true;
                break;
            }
            case 0: {
                this.bFontembed = true;
                break;
            }
            case 1: {
                this.bFontembed = false;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.fontMap = new HashMap();
    }

    public BaseFont awtToPdf(Font font) {
        BaseFont baseFont = (BaseFont)this.fontMap.get(font);
        if (baseFont != null) {
            return baseFont;
        }
        com.lowagie.text.Font iTextFont = null;
        String encoding = "Identity-H";
        try {
            if (this.bSelective) {
                this.bFontembed = DocumentFontMapper.isCommonFont(font.getFontName());
            }
            iTextFont = FontFactory.getFont((String)font.getFontName(), (String)encoding, (boolean)this.bFontembed, (float)font.getSize2D(), (int)font.getStyle(), null);
            baseFont = this.getBaseFont(iTextFont, font, encoding);
        }
        catch (Exception e) {
            if (e instanceof ExceptionConverter) {
                if (e.getMessage().indexOf("licensing restrictions") > 0 && this.bFontembed) {
                    iTextFont = FontFactory.getFont((String)font.getFontName(), (String)encoding, (boolean)false, (float)font.getSize2D(), (int)font.getStyle(), null);
                    this.bFontembed = false;
                    baseFont = this.getBaseFont(iTextFont, font, encoding);
                }
                if (e.getMessage().equals("Identity-H")) {
                    iTextFont = FontFactory.getFont((String)font.getFontName(), (String)"Cp1252", (boolean)false, (float)font.getSize2D(), (int)font.getStyle(), null);
                    baseFont = this.getBaseFont(iTextFont, font, "Cp1252");
                }
                throw (ExceptionConverter)e;
            }
            throw new ExceptionConverter(e);
        }
        if (baseFont == null) {
            String fontKey = null;
            fontKey = font.isItalic() ? (font.isBold() ? "Helvetica-BoldOblique" : "Helvetica-Oblique") : (font.isBold() ? "Helvetica-Bold" : "Helvetica");
            try {
                baseFont = BaseFont.createFont((String)fontKey, (String)"Cp1252", (boolean)false, (boolean)true, null, null);
            }
            catch (Exception e) {
                throw new ExceptionConverter(e);
            }
        }
        this.fontMap.put(font, baseFont);
        baseFont.setSubset(this.bFontembed);
        return baseFont;
    }

    private BaseFont getBaseFont(com.lowagie.text.Font iTextFont, Font font, String encoding) {
        BaseFont baseFont = iTextFont.getBaseFont();
        if (baseFont == null) {
            String fontkey = this.getAwtToTrueTypeFonts(font, false);
            if (fontkey != null) {
                baseFont = FontFactory.getFont((String)fontkey, (String)encoding, (boolean)this.bFontembed, (float)font.getSize2D(), (int)font.getStyle(), null).getBaseFont();
            }
            if (baseFont == null && (fontkey = this.getAwtToTrueTypeFontsBak(font)) != null) {
                baseFont = FontFactory.getFont((String)fontkey, (String)encoding, (boolean)this.bFontembed, (float)font.getSize2D(), (int)font.getStyle(), null).getBaseFont();
            }
            if (baseFont == null) {
                iTextFont.setFamily("Times-Roman");
                baseFont = iTextFont.getCalculatedBaseFont(true, this.bFontembed);
            }
            baseFont.setSubset(this.bFontembed);
        }
        return baseFont;
    }

    private String getAwtToTrueTypeFonts(Font font, boolean bUseBackUp) {
        Properties awtfontmapper;
        String fontKey = null;
        String logicalName = font.getName().toLowerCase();
        String style = null;
        style = font.isItalic() ? (font.isBold() ? "bolditalic" : "italic") : (font.isBold() ? "bold" : null);
        Properties properties = awtfontmapper = bUseBackUp ? this.backupFontMapper : this.primaryFontMapper;
        if (awtfontmapper != null && !awtfontmapper.isEmpty() && (fontKey = style == null ? awtfontmapper.getProperty(logicalName) : awtfontmapper.getProperty(logicalName + "." + style)) == null && logicalName.equals("sanserif")) {
            fontKey = style == null ? awtfontmapper.getProperty("sansserif") : awtfontmapper.getProperty("sansserif." + style);
        }
        String fontName = null;
        if (fontKey != null) {
            StringTokenizer tokenizer = new StringTokenizer(fontKey.toLowerCase(), ",");
            while (tokenizer.hasMoreTokens()) {
                fontName = tokenizer.nextToken().trim();
                if (FontFactory.getFontProperties().get(fontName) == null) continue;
                return fontName;
            }
        }
        return fontName;
    }

    private String getAwtToTrueTypeFontsBak(Font font) {
        if (!SystemInfo.isWindows()) {
            return this.getAwtToTrueTypeFonts(font, true);
        }
        String fontKey = null;
        String logicalName = font.getName().toLowerCase();
        String style = null;
        style = font.isItalic() ? (font.isBold() ? "bolditalic" : "italic") : (font.isBold() ? "bold" : null);
        int componentindex = 0;
        Properties awtfontmapper = this.backupFontMapper;
        if (style == null) {
            fontKey = awtfontmapper.getProperty(logicalName + "." + componentindex);
            if (fontKey == null) {
                fontKey = awtfontmapper.getProperty(logicalName + ".plain." + componentindex);
            }
        } else {
            fontKey = awtfontmapper.getProperty(logicalName + "." + style + "." + componentindex);
        }
        if (fontKey == null && logicalName.equals("sanserif")) {
            if (style == null) {
                fontKey = awtfontmapper.getProperty("sansserif." + componentindex);
                if (fontKey == null) {
                    fontKey = awtfontmapper.getProperty("sansserif.plain." + componentindex);
                }
            } else {
                fontKey = awtfontmapper.getProperty("sansserif." + style + "." + componentindex);
            }
        }
        if (fontKey != null && fontKey.length() > 0 && fontKey.indexOf(",") >= 0) {
            fontKey = fontKey.substring(0, fontKey.indexOf(",")).trim();
        }
        return fontKey;
    }

    private static boolean isCommonFont(String fontName) {
        return false;
    }
}

