/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.document;

import coldfusion.util.XmlUtils;
import java.io.File;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class BreezeConfigXmlBuilder {
    private File configFile;
    private Document document;
    private Element root;
    private static final String LAYOUT = "layout";
    private static final String UI_SHOW = "uishow";

    public BreezeConfigXmlBuilder(File configFile) throws ParserConfigurationException, IOException, SAXException {
        this.configFile = configFile;
        this.document = XmlUtils.getDocument((File)configFile);
        this.root = this.document.getDocumentElement();
    }

    public void setOutlineVisible(boolean visible) {
        this.setUIShowElement("outline", visible);
    }

    public void setSearchVisible(boolean visible) {
        this.setUIShowElement("search", visible);
    }

    public void setNotesVisible(boolean visible) {
        this.setUIShowElement("notes", visible);
    }

    public void setControl(String type) {
        this.setUIShowElement("initialdisplaymodeisnormal", type.equals("normal"));
    }

    public void setControlLocation(String location) {
        this.setUIShowElement("sidebaronright", location.equalsIgnoreCase("right"));
    }

    public void setInitialTab(String initialTab) {
        Element layoutElem = (Element)this.root.getElementsByTagName(LAYOUT).item(0);
        Element element = this.getElementWithAttribute(layoutElem, "uireplace", "name", "initialtab");
        element.setAttribute("value", initialTab);
    }

    public void setPrimaryColor(String hexColor) {
        this.setColor("primary", hexColor);
    }

    public void setBackgroundColor(String hexColor) {
        this.setColor("background", hexColor);
    }

    public void setTextColor(String hexColor) {
        this.setColor("text", hexColor);
    }

    public void setLightColor(String hexColor) {
        this.setColor("light", hexColor);
    }

    public void setShadowColor(String hexColor) {
        this.setColor("shadow", hexColor);
    }

    public void setGlowColor(String hexColor) {
        this.setColor("glow", hexColor);
    }

    private void setColor(String type, String color) {
        Element colorsElem = (Element)this.root.getElementsByTagName("colors").item(0);
        Element element = this.getElementWithAttribute(colorsElem, "uicolor", "name", type);
        element.setAttribute("value", color);
    }

    private void setUIShowElement(String attrName, boolean visible) {
        Element layoutElem = (Element)this.root.getElementsByTagName(LAYOUT).item(0);
        Element element = this.getElementWithAttribute(layoutElem, UI_SHOW, "name", attrName);
        element.setAttribute("value", "" + visible);
    }

    private Element getElementWithAttribute(Element parent, String tagName, String attributeName, String value) {
        NodeList nodeList = parent.getElementsByTagName(tagName);
        int length = nodeList.getLength();
        for (int i = 0; i < length; ++i) {
            Element node = (Element)nodeList.item(i);
            Attr attr = node.getAttributeNode(attributeName);
            if (attr == null || !attr.getValue().equals(value)) continue;
            return node;
        }
        return null;
    }

    public void save() throws IOException {
        XmlUtils.saveDocument((Document)this.document, (File)this.configFile);
    }
}

