/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.cloud.aws.dynamodb.exceptions;

import coldfusion.cloud.aws.dynamodb.casesensitive.CFHandleCaseSensitiveReturn;
import coldfusion.util.RB;
import java.util.Map;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.services.dynamodb.model.DynamoDbException;

public class CFDynamoDbException
extends RuntimeException {
    private String exceptionCause;
    private String exceptionMessage;
    private String exceptionName;
    private String exceptionCode;
    private String serviceName;
    private String awsExceptionClass;
    private String apiName;
    private String awsStackTraceString;
    private StackTraceElement[] awsStackTrace;
    protected Map exceptionDetails;
    private Map httpResponse;

    public CFDynamoDbException(String msg) {
        this.exceptionMessage = msg;
    }

    public CFDynamoDbException(DynamoDbException dynamoDbException, String apiName, String detailedMessage) {
        this(dynamoDbException, apiName);
        this.exceptionMessage = detailedMessage;
    }

    public CFDynamoDbException(DynamoDbException dynamoDbException, String apiName) {
        this.apiName = apiName;
        this.buildErrorDetails(dynamoDbException);
        this.filterExceptionMessage(apiName);
        this.buildStackTrace();
        this.buildExceptionDetails();
    }

    private void buildErrorDetails(DynamoDbException dynamoDbException) {
        AwsErrorDetails awsErrorDetails = dynamoDbException.awsErrorDetails();
        this.exceptionMessage = awsErrorDetails.errorMessage();
        this.exceptionName = this.getClass().getSimpleName();
        this.awsExceptionClass = ((Object)((Object)dynamoDbException)).getClass().getName();
        this.exceptionCode = awsErrorDetails.errorCode();
        this.serviceName = awsErrorDetails.serviceName();
        this.awsStackTrace = dynamoDbException.getStackTrace();
        this.exceptionCause = "An Exception occured while performing " + this.apiName + " dynamo operation.";
        this.httpResponse = CFHandleCaseSensitiveReturn.contructReturn(awsErrorDetails.sdkHttpResponse());
    }

    private void buildStackTrace() {
        this.awsStackTraceString = new String("");
        this.awsStackTraceString = this.awsStackTraceString + this.awsStackTrace[0].toString() + " ";
        for (int i = 1; i < this.awsStackTrace.length; ++i) {
            this.awsStackTraceString = this.awsStackTraceString + " at " + this.awsStackTrace[i].toString();
        }
    }

    private void buildExceptionDetails() {
        this.exceptionDetails = CFHandleCaseSensitiveReturn.getReturnObject();
        this.exceptionDetails.put("ExceptionMessage", this.exceptionMessage);
        this.exceptionDetails.put("AWSExceptionClass", this.awsExceptionClass);
        this.exceptionDetails.put("ExceptionCause", this.exceptionCause);
        this.exceptionDetails.put("ExceptionName", this.exceptionName);
        this.exceptionDetails.put("ExceptionCode", this.exceptionCode);
        this.exceptionDetails.put("ServiceName", this.serviceName);
        this.exceptionDetails.put("AWSStackTrace", this.awsStackTraceString);
    }

    private void filterExceptionMessage(String apiName) {
        String awsProjExpMsg = RB.getString(CFDynamoDbException.class, (String)"Exception.ProjectionExpressionException");
        String CfProjExpMsg = RB.getString(CFDynamoDbException.class, (String)"Exception.CFProjectionExpressionException");
        String awsIndxNameExp = RB.getString(CFDynamoDbException.class, (String)"Exception.IndexNameException");
        String CfIndxNameExp = RB.getString(CFDynamoDbException.class, (String)"Exception.CFIndexNameException");
        if (this.exceptionMessage.contains(awsProjExpMsg)) {
            this.exceptionMessage = this.exceptionMessage.replace(awsProjExpMsg, CfProjExpMsg);
        } else if (apiName.equals("scan") && this.exceptionMessage.contains(awsIndxNameExp)) {
            this.exceptionMessage = this.exceptionMessage.replace(awsIndxNameExp, CfIndxNameExp);
        }
    }

    @Override
    public String getMessage() {
        return this.exceptionMessage;
    }

    public Map getExceptionDetails() {
        return this.exceptionDetails;
    }

    public Map getHttpResponse() {
        return this.httpResponse;
    }
}

